/* Canter Keygen 5 - Interface */

#define  WIN32_LEAN_AND_MEAN
#include <windows.h>

#include "identifiers.h"

/* colors used in fields */
#define CR_FIELD    RGB(240, 230, 200) /* background */
#define CR_INFIELD  RGB(0  , 0  , 0  ) /* infiel     */
#define CR_OUTFIELD RGB(215, 65 , 75 ) /* outfield   */

/* generator's functions, defined in core.c */
BOOL Init(HWND);
BOOL Gen (HWND);
BOOL Copy(HWND);
BOOL Exit(HWND);

BOOL CALLBACK DlgProc    (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK InfoDlgProc(HWND, UINT, WPARAM, LPARAM);
BOOL EnableDlgItem(HWND, DWORD, BOOL);
BOOL SetStatusText(HWND, LPCTSTR);

#include "core.c"

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow) {
  return DialogBox(hInstance, MAKEINTRESOURCE(IDD_KEYGEN), NULL, DlgProc);
}

BOOL CALLBACK DlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
  static HINSTANCE hInstance;
  static HBRUSH hFieldColor;
  static HFONT hBoldFont;
  HICON hIcon;
  LOGFONT BoldFont;
  int nFieldId;

  /* text displayed if auto-update is disabled */
  #if !AUTO_UPDATE
    TCHAR sGen[] = TEXT("Hit Generate, please");
  #endif

  switch (uMsg) {

    case WM_COMMAND:

      switch(LOWORD(wParam)) {

        /* "?" is pushed: the information dialog is displayed */
        case IDC_INFO:
          DialogBox(hInstance, MAKEINTRESOURCE(IDD_INFO), hWnd, InfoDlgProc);
          break;

        /* "Generate" is pushed: generates registration information and switch the status of buttons if needed */
        case IDC_GEN:

          if(Gen(hWnd)) {

            #if !AUTO_UPDATE && !MULTI_SERIALS
              EnableDlgItem(hWnd, IDC_GEN, FALSE);
            #endif

            EnableDlgItem(hWnd, IDC_COPY, TRUE);
          }
          else {
            EnableDlgItem(hWnd, IDC_GEN, FALSE);
            EnableDlgItem(hWnd, IDC_COPY, FALSE);
          }

          break;

        /* "Copy" is pushed: copies the current registration information */
        case IDC_COPY:

          if(Copy(hWnd))
            EnableDlgItem(hWnd, IDC_COPY, FALSE);

          break;

        /* "Exit" is pushed: ask the program to quit (that will invoke the Exit function) */
        case IDC_EXIT:
          SendMessage(hWnd, WM_CLOSE, 0, 0);
          break;

        /* other messages may come from an updated field: this triggers the auto-update process */
        default:

          if(LOWORD(wParam) >= INFIELD_BEGIN && LOWORD(wParam) <= INFIELD_END && HIWORD(wParam) == EN_UPDATE) {

            #if AUTO_UPDATE

              if(Gen(hWnd)) {

                #if MULTI_SERIALS
                  EnableDlgItem(hWnd, IDC_GEN, TRUE);
                #endif

                EnableDlgItem(hWnd, IDC_COPY, TRUE);
              }
              else {

                #if MULTI_SERIALS
                  EnableDlgItem(hWnd, IDC_GEN, FALSE);
                #endif

                EnableDlgItem(hWnd, IDC_COPY, FALSE);
              }

            #else
              EnableDlgItem(hWnd, IDC_GEN, TRUE);
              EnableDlgItem(hWnd, IDC_COPY, FALSE);
              SetStatusText(hWnd, sGen);
            #endif

          }
          else
            return FALSE;

      }

      break;

    case WM_INITDIALOG:
      hInstance = GetModuleHandle(NULL);
      hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_KEYGEN));

      SendMessage(hWnd, WM_SETICON, ICON_BIG, (LPARAM) hIcon);
      SendMessage(hWnd, WM_SETICON, ICON_SMALL,(LPARAM) hIcon);

      /* set the font used in fields; even non-existing fields are tested */

      hFieldColor = CreateSolidBrush(CR_FIELD);
      GetObject((HFONT) SendMessage(hWnd, WM_GETFONT, 0, 0), sizeof(LOGFONT), &BoldFont);
      BoldFont.lfWeight = FW_BOLD;
      hBoldFont = CreateFontIndirect(&BoldFont);

      for(nFieldId = OUTFIELD_BEGIN; nFieldId <= OUTFIELD_END; nFieldId++)

        if(GetDlgItem(hWnd, nFieldId) != NULL)
          SendDlgItemMessage(hWnd, nFieldId, WM_SETFONT, (WPARAM) hBoldFont, TRUE);
        else
          break;

      for(nFieldId = INFIELD_BEGIN; nFieldId <= INFIELD_END; nFieldId++)

        if(GetDlgItem(hWnd, nFieldId) != NULL)
          SendDlgItemMessage(hWnd, nFieldId, WM_SETFONT, (WPARAM) hBoldFont, TRUE);
        else
          break;

      /* set the title */
      #ifdef TARGET_VERSION
        SetWindowText(hWnd, TEXT(TARGET " " TARGET_VERSION " " TYPE));
      #else
        SetWindowText(hWnd, TEXT(TARGET " " TYPE));
      #endif

      /* initializes the generator */
      if(!Init(hWnd)) {
        SendMessage(hWnd, WM_CLOSE, 0, 0);
        break;
      }

      /* generates the initial registration information if auto-update is activated */
      #if AUTO_UPDATE

        #if !MULTI_SERIALS
          EnableDlgItem(hWnd, IDC_GEN, FALSE);
        #endif

        if(!Gen(hWnd)) {

          #if MULTISERIALS
            EnableDlgItem(hWnd, IDC_GEN, FALSE);
          #endif

          EnableDlgItem(hWnd, IDC_COPY, FALSE);
        }

      #else
        EnableDlgItem(hWnd, IDC_COPY, FALSE);
        SetDlgItemText(hWnd, IDC_STATUS, sGen);
      #endif

      break;

    case WM_CLOSE:

      /* terminates the generator */
      Exit(hWnd);

      DeleteObject(hBoldFont);
      DeleteObject(hFieldColor);

      EndDialog(hWnd, TRUE);
      break;

    /* change the colors of outfields */
    case WM_CTLCOLORSTATIC:
      nFieldId = GetDlgCtrlID((HWND) lParam);

      if(nFieldId >= OUTFIELD_BEGIN && nFieldId <= OUTFIELD_END) {
        SetBkColor((HDC) wParam, CR_FIELD);
        SetTextColor((HDC) wParam, CR_OUTFIELD);
        return (LRESULT) hFieldColor;
      }
      else
        return FALSE;

    /* change the colors of infields */
    case WM_CTLCOLOREDIT:
      SetBkColor((HDC) wParam, CR_FIELD);
      SetTextColor((HDC) wParam, CR_INFIELD);
      return (LRESULT) hFieldColor;

    default:
      return FALSE;

  }

  return TRUE;
}

BOOL CALLBACK InfoDlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {

  switch(uMsg) {

    case WM_COMMAND:

      switch(LOWORD(wParam)) {

        case IDOK:
          EndDialog(hWnd, TRUE);

        default:
          return FALSE;

      }

      break;

    case WM_INITDIALOG:

      /* set the information that will be shown */
      SetDlgItemText(hWnd, IDC_TITLE, TEXT("Canter S2 #" ID " - " TARGET " " TYPE));
      SetDlgItemText(hWnd, IDC_NOTE, TEXT(NOTE));
      SetDlgItemText(hWnd, IDC_DATE, TEXT("C code compiled on " __DATE__ " @ " __TIME__));

      break;

    default:
      return FALSE;

  }

  return TRUE;
}

/* the equivalent of EnableWindow, for controls */
BOOL EnableDlgItem(HWND hWnd, DWORD nDlgItem, BOOL bEnable) {
  return EnableWindow(GetDlgItem(hWnd, nDlgItem), bEnable);
}

/* quick update of the status bar */
BOOL SetStatusText(HWND hWnd, LPCTSTR sText) {
  return SetDlgItemText(hWnd, IDC_STATUS, sText);
}
