/* Canter Keygen 5 - Core */

/* additional libraries and sources used are referenced just below */

/* configuration */

#define ID             "1"        /* keygen identifier, generally a number              */
#define TARGET         "Softname" /* target's (short) name                              */
#define TARGET_VERSION "1.0"      /* target version, optional (the line may be deleted) */
#define TYPE           "keygen"   /* type of release, ie. keygen, keymaker, etc.        */

/* a quick notice, description... */
#define NOTE "Just enjoy this keygen!"

#define AUTO_UPDATE   TRUE /* update registration information without pushing any button (recommended) */
#define MULTI_SERIALS TRUE /* allow various serials for the same input value (depends on target)       */

/* field values (serial/name-serial/name-company-serial in most cases) */
CHAR sInfield1 [0x100];
CHAR sOutfield1[0x100];

/* generator's initialization: initial computations, objects creation, etc. */
BOOL Init(HWND hWnd) {
  DWORD nInfield1Size = sizeof sInfield1;

  /* limits the name size */
  SendDlgItemMessage(hWnd, IDC_INFIELD1, EM_SETLIMITTEXT, sizeof sInfield1 - 1, 0);

  /* retrieves the computer user's name */
  GetUserName(sInfield1, &nInfield1Size);

  SetDlgItemText(hWnd, IDC_INFIELD1, sInfield1);

  SetStatusText(hWnd, TEXT("Keygen ready..."));
  return TRUE;
}

/* generation */
BOOL Gen(HWND hWnd) {

  /* checks if a name has been entered */
  if(GetDlgItemText(hWnd, IDC_INFIELD1, sInfield1, sizeof sInfield1)) {

    /* a (very very) basic generation routine */
    SetDlgItemText(hWnd, IDC_OUTFIELD1, sInfield1);

    SetStatusText(hWnd, TEXT("Serial generated successfully."));
    return TRUE;
  }
  else {
    SetStatusText(hWnd, TEXT("Enter your name, please..."));
    return FALSE;
  }

}

/* copying: in the clipboard, the registry, or directly into a license file... */
BOOL Copy(HWND hWnd) {
  HGLOBAL hOutfield1;

  GetDlgItemText(hWnd, IDC_OUTFIELD1, sOutfield1, sizeof sOutfield1);

  /* copy the serial into a shareable memory block */
  hOutfield1 = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, sizeof sOutfield1);
  lstrcpy(GlobalLock(hOutfield1), sOutfield1);
  GlobalUnlock(hOutfield1);

  /* move it in the clipboard */
  OpenClipboard(hWnd);
  EmptyClipboard();
  SetClipboardData(CF_TEXT, hOutfield1);
  CloseClipboard();

  SetStatusText(hWnd, TEXT("Serial copied into the clipboard."));
  return TRUE;
}

/* termination: may be used to give a message to the user, to delete objects, etc. */
BOOL Exit(HWND hWnd) {
  SetStatusText(hWnd, TEXT("See you later..."));
  return TRUE;
}
