; Keygen - n0!se KeygenMe
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v2.0

; libraries used
INCLUDE    \masm32\INCLUDE\advapi32.inc
INCLUDELIB \masm32\LIB\advapi32.lib

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation
Copy       PROTO :HWND ; copying into the clipboard or the registry, a keyfile...

; configuration
AUTO_UPDATE   = TRUE
MULTI_SERIALS = FALSE

.DATA

; parameters
; ------------------------------------------------------------------------------

; required data
sTeam        TCHAR "NGEN", 0
sSoftware    TCHAR "n0!se KeygenMe", 0
sType        TCHAR "keygen", 0
sInformation TCHAR "Protection: Standard {anti-debugging tricks}", 0
sSignature   TCHAR "Canterwood", 0

; defined variables
dword_4066D8 DWORD 04E58F4B4h
dword_4066DC DWORD 0E87F7B78h
dword_4066E0 DWORD 0F47E4A5Bh
dword_4066E4 DWORD 0DF48ABC8h

.DATA?

; required data

pTargetVersion LPCTSTR         ?
sTitle         CHAR    40h dup(?)

sName   CHAR 20h dup(?)
sSerial CHAR 60h dup(?)

; undefined variables

; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC hWnd: HWND
LOCAL nNameSize:DWORD

  ; make the release title
  INVOKE FindResource, hInstance, SADD("TARGETVERSION"), RT_RCDATA
  INVOKE LoadResource, hInstance, eax
  INVOKE LockResource, eax
  mov pTargetVersion, eax
  INVOKE wsprintf, ADDR sTitle, SADD("%s - %s %s %s"), ADDR sTeam, ADDR sSoftware, pTargetVersion, ADDR sType

  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_INFORMATION, ADDR sInformation
  INVOKE SetDlgItemText, hWnd, IDC_SIGNATURE, ADDR sSignature

  ; set the limit for the name text field
  INVOKE SendDlgItemMessage, hWnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF sName - 1, 0

  mov nNameSize, SIZEOF sName

  ; retrieve the default username
  INVOKE GetUserName, ADDR sName, ADDR nNameSize

  .IF eax
    INVOKE SetDlgItemText, hWnd, IDC_NAME, ADDR sName
  .ENDIF

  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------
sub_403958 PROC NEAR
  mov eax, dword_4066D8
  imul dword_4066DC
  add eax, dword_4066E0
  xor eax, dword_4066E4
  mov edx, dword_4066D8
  or edx, dword_4066DC
  add eax, edx
  ret
sub_403958 ENDP

sub_403980 PROC NEAR
  mov eax, dword_4066DC
  imul dword_4066E0
  add eax, dword_4066E4
  or eax, dword_4066D8
  mov edx, dword_4066E4
  xor edx, dword_4066E0
  add eax, edx
  ret
sub_403980 ENDP

Generate PROC USES ebx esi edi hWnd: HWND
LOCAL var_4, var_8:DWORD

  INVOKE GetDlgItemText, hWnd, IDC_NAME, ADDR sName, SIZEOF sName
  cmp eax, 4
  jb nameError
  xor esi, esi
  mov edi, eax

  mov eax, edi
  sar eax, 1
  jns loc_404125
  adc eax, 0

  loc_404125:
  mov var_4, eax
  mov eax, edi
  and eax, 80000001h
  jns loc_404136
  dec eax
  or eax, 0FFFFFFFEh
  inc eax

  loc_404136:
  mov var_8, eax
  mov eax, var_4
  test eax, eax
  jle loc_404160
  lea edx, [OFFSET sName+1]

  loc_404146:
  xor ecx, ecx
  mov cl, [edx]
  imul ecx, var_4
  add esi, ecx
  xor esi, 0CCh
  test esi, esi
  jge loc_40415C
  neg esi

  loc_40415C:
  inc edx
  dec eax
  jnz loc_404146

  loc_404160:
  mov edx, var_4
  mov eax, edi
  sub eax, var_8
  sub eax, edx
  jl loc_404191
  inc eax
  lea edx, [OFFSET sName+edx]

  loc_404174:
  xor ecx, ecx
  mov cl, [edx]
  imul ecx, var_8
  imul ecx, ebx
  mov ebx, ecx
  xor ebx, 0DDh
  test ebx, ebx
  jge loc_40418D
  neg ebx

  loc_40418D:
  inc edx
  dec eax
  jnz loc_404174

  loc_404191:
  cmp ebx, esi
  jle loc_40419E
  call sub_403958
  mov edi, eax
  jmp loc_4041A5

  loc_40419E:
  call sub_403980
  mov edi, eax

  loc_4041A5:
  test edi, edi
  jge loc_4041AB
  neg edi

  loc_4041AB:
  INVOKE wsprintf, ADDR sSerial, SADD("RK302%uQ-ZX%uA-PM%uOU"), edi, esi, ebx
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  mov eax, TRUE
  jmp endGenerate

  nameError:
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, SADD("You must enter 4 characters at least.")
  mov eax, FALSE

  endGenerate:
  ret
Generate ENDP
; ------------------------------------------------------------------------------

; Copying
; ------------------------------------------------------------------------------
Copy PROC USES ebx esi edi hWnd:HWND
  mov ebx, FALSE ; success flag

  INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

  .IF eax
    INVOKE OpenClipboard, hWnd

    .IF eax
      INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

      .IF eax != NULL
        push eax
        push eax

        ; Copy the serial into the clipboard
        INVOKE GlobalLock, eax
        mov edi, eax
        mov esi, OFFSET sSerial
        mov ecx, SIZEOF sSerial
        rep movsb
        pop eax
        INVOKE GlobalUnlock, eax

        INVOKE EmptyClipboard
        pop eax
        INVOKE SetClipboardData, CF_TEXT, eax
        mov ebx, TRUE
      .ENDIF

      INVOKE CloseClipboard
    .ENDIF

  .ENDIF

  .IF ebx
    INVOKE MessageBox, hWnd, SADD("The serial has been copied into the clipboard."), SADD("Information"), MB_ICONINFORMATION OR MB_OK
  .ELSE
    INVOKE MessageBox, hWnd, SADD("An error occured, please copy the serial by hand."), SADD("Error"), MB_ICONERROR OR MB_OK
  .ENDIF

  mov eax, TRUE
  ret
Copy ENDP
; ------------------------------------------------------------------------------