; Keygen - n0!se KeygenMe #1
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0

; libraries used
INCLUDE    \masm32\INCLUDE\advapi32.inc
INCLUDELIB \masm32\LIB\advapi32.lib

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation
Copy       PROTO :HWND ; copying into the clipboard or the registry, a keyfile...

; configuration
AUTO_UPDATE   = TRUE
MULTI_SERIALS = FALSE

.DATA

; parameters
; ------------------------------------------------------------------------------

; required data
% sTitle       TCHAR "NGEN - n0!se KeygenMe #1 keygen", 0 ; target version defined in the batch file for quick update
  sInformation TCHAR "Protection: Standard", 0
  sSignature   TCHAR "Canterwood", 0

; defined variables

.DATA?

; required data
sName   CHAR 20h dup(?)
sSerial CHAR 60h dup(?)

; undefined variables
OSVersion    OSVERSIONINFO <?>
dword_41062C DWORD          ?
dword_410830 DWORD          ?
stru_41084C  SYSTEMTIME    <?>
word_41085C  WORD           ?
word_41085E  WORD           ?
word_410860  WORD           ?
dword_41083C DWORD          ?
dword_410840 DWORD          ?
dword_410844 DWORD          ?
dword_410848 DWORD          ?

; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC hWnd: HWND
  LOCAL nNameSize:DWORD

  mov OSVersion.dwOSVersionInfoSize, SIZEOF OSVERSIONINFO
  INVOKE GetVersionEx, ADDR OSVersion

  mov     eax, OSVersion.dwPlatformId
  sub     eax, 1
  jb      short loc_407883
  jz      short loc_40788F
  dec     eax
  jz      short loc_40789B
  jmp     short loc_4078A5

  loc_407883:
  mov     ds:dword_41062C, 228Ch
  jmp     short loc_4078A5

  loc_40788F:
  mov     ds:dword_41062C, 26CDh
  jmp     short loc_4078A5

  loc_40789B:
  mov     ds:dword_41062C, 1E4Bh

  loc_4078A5:
  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_INFORMATION, ADDR sInformation
  INVOKE SetDlgItemText, hWnd, IDC_SIGNATURE, ADDR sSignature

  ; Set the limit for the name text field
  INVOKE SendDlgItemMessage, hWnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF sName - 1, 0

  mov nNameSize, SIZEOF sName

  ; Retrieve the default username
  INVOKE GetUserName, ADDR sName, ADDR nNameSize

  .IF eax
    INVOKE SetDlgItemText, hWnd, IDC_NAME, ADDR sName
  .ENDIF

  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------
Generate PROC USES ebx esi edi hWnd: HWND
  INVOKE GetDlgItemText, hWnd, IDC_NAME, ADDR sName, SIZEOF sName
  cmp eax, 5
  jb nameError
  mov dword_410830, eax

  INVOKE GetSystemTime, ADDR stru_41084C

  mov     ax, ds:stru_41084C.wYear
  mov     ds:word_41085C, ax
  mov     ax, ds:stru_41084C.wMonth
  mov     ds:word_41085E, ax
  mov     ax, ds:stru_41084C.wDay
  mov     ds:word_410860, ax
  xor     eax, eax
  mov     ds:dword_41083C, eax
  xor     eax, eax
  mov     ds:dword_410840, eax
  xor     eax, eax
  mov     ds:dword_410844, eax

  mov     eax, ds:dword_410830
  mov     ds:dword_410848, 1

  loc_407A8B:
  mov     edx, ds:dword_410848
  movzx   edx, ds:sName[edx]
  imul    edx, ds:dword_41062C
  imul    edx, ds:dword_410830
  add     ds:dword_41083C, edx
  inc     ds:dword_410848
  dec     eax
  jnz     short loc_407A8B

  mov     eax, ds:dword_410830
  mov     ds:dword_410848, 1

  loc_407AC8:
  movzx   edx, ds:word_41085C
  xor     edx, ds:dword_41083C
  mov     ecx, ds:dword_410848
  movzx   ecx, ds:sName[ecx]
  xor     edx, ecx
  add     ds:dword_410840, edx
  inc     ds:dword_410848
  dec     eax
  jnz     short loc_407AC8

  mov     eax, ds:dword_410830
  mov     ds:dword_410848, 1

  loc_407B06:
  mov     edx, ds:dword_410848
  movzx   edx, ds:sName[edx]
  movzx   ecx, ds:word_41085E
  xor     ecx, ds:dword_410840
  imul    edx, ecx
  add     ds:dword_410844, edx
  inc     ds:dword_410848
  dec     eax
  jnz     short loc_407B06

  INVOKE wsprintf, ADDR sSerial, SADD("%d-%d-%d"), dword_41083C, dword_410840, dword_410844
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  mov eax, TRUE
  jmp endGenerate

  nameError:
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, SADD("You must enter 5 characters at least.")
  mov eax, FALSE

  endGenerate:
  ret
Generate ENDP
; ------------------------------------------------------------------------------

; Copying
; ------------------------------------------------------------------------------
Copy PROC USES ebx esi edi hWnd:HWND
  mov ebx, FALSE ; success flag

  INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

  .IF eax
    INVOKE OpenClipboard, hWnd

    .IF eax
      INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

      .IF eax != NULL
        push eax
        push eax

        ; Copy the serial into the clipboard
        INVOKE GlobalLock, eax
        mov edi, eax
        mov esi, OFFSET sSerial
        mov ecx, SIZEOF sSerial
        rep movsb
        pop eax
        INVOKE GlobalUnlock, eax

        INVOKE EmptyClipboard
        pop eax
        INVOKE SetClipboardData, CF_TEXT, eax
        mov ebx, TRUE
      .ENDIF

      INVOKE CloseClipboard
    .ENDIF

  .ENDIF

  .IF ebx
    INVOKE MessageBox, hWnd, SADD("The serial has been copied into the clipboard."), SADD("Information"), MB_ICONINFORMATION OR MB_OK
  .ELSE
    INVOKE MessageBox, hWnd, SADD("An error occured, please copy the serial by hand."), SADD("Error"), MB_ICONERROR OR MB_OK
  .ENDIF

  mov eax, TRUE
  ret
Copy ENDP
; ------------------------------------------------------------------------------