; Keygen - jB KeygenMe 2
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0

; libraries used
include    sha256.inc
include    biglib.inc
includelib biglib.lib

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation
Copy       PROTO :HWND ; copying into the clipboard or the registry, a keyfile...

; configuration
AUTO_UPDATE = TRUE

.DATA

; parameters
; ------------------------------------------------------------------------------

; required data
% sTitle TCHAR "NGEN - jB KeygenMe 2 keygen", 0 ; target version defined in the batch file for quick update
  sAbout TCHAR "by Canterwood // Team NGEN 2004 - gfx: dax`", 0
            
  sNameError   TCHAR "You should enter a name.", 0
  sCopySuccess TCHAR "The serial has been copied into the clipboard.", 0
  sCopyError   TCHAR "An error occured, please copy the serial by hand.", 0

; defined variables
IDC_ID = 306

.DATA?

; required data
sName   CHAR 20h dup(?)
sId     CHAR 10h dup(?)
sSerial CHAR 60h dup(?)

; undefined variables
aNameSHA256    BYTE   36 dup(?)
pbigOrder      LPVOID    ?
pbigNameSHA256 LPVOID    ?
pbigId         LPVOID    ?

tableHeader     dd     ?
table           db     ?
                dd 3Fh dup(?)
; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC hWnd: HWND
  LOCAL nNameSize:DWORD

  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_ABOUT, ADDR sAbout

  ; Set the limit for the name text field
  INVOKE SendDlgItemMessage, hWnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF sName - 1, 0

  mov nNameSize, SIZEOF sName

  ; Retrieve the default username
  INVOKE GetUserName, ADDR sName, ADDR nNameSize

  .IF eax
    INVOKE SetDlgItemText, hWnd, IDC_NAME, ADDR sName
  .ENDIF

  INVOKE Generate, hWnd
  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------
Generate PROC USES ebx esi edi hWnd: HWND
  INVOKE GetDlgItemText, hWnd, IDC_NAME, ADDR sName, SIZEOF sName
  cmp eax, 0
  je ValidityError

  push OFFSET sName
  push eax
  push OFFSET aNameSHA256
  call SHA256

  lea esi, aNameSHA256
  mov ecx, 7

  swap:
  mov eax, [esi+ecx*4]
  bswap eax
  mov [esi+ecx*4], eax
  dec ecx
  jns swap
  mov dword ptr[esi+8*4], 0

  INVOKE _BigCreate, 0
  mov pbigId, eax
  INVOKE _BigCreate, 0
  mov pbigNameSHA256, eax
  INVOKE _BigCreate, 0
  mov pbigOrder, eax

  INVOKE _BigIn, SADD("4AAB90B4031"), 16, pbigId
  INVOKE _BigInB256, ADDR aNameSHA256, 32, pbigNameSHA256
  INVOKE _BigIn, SADD("6AB353F03E1"), 16, pbigOrder

  INVOKE _BigMulMod, pbigId, pbigNameSHA256, pbigOrder, pbigId
  INVOKE _BigOut, pbigId, 10, ADDR sId

  INVOKE SetDlgItemText, hWnd, IDC_ID, ADDR sId

  INVOKE _BigDestroy, pbigOrder
  INVOKE _BigDestroy, pbigNameSHA256
  INVOKE _BigDestroy, pbigId

  push 16
  push CTXT("KeygenMe 2 by jB")
  call buildTable
  push 36
  push OFFSET aNameSHA256
  call coolXor

  lea esi, aNameSHA256
  lea edi, sSerial
  xor ecx, ecx
  xor ebx, ebx

  push ebp

  translate:
  mov edx, [esi+ecx*4]

  xor ebp, ebp

  rol edx, 2
  mov eax, edx
  and eax, 11b
  jmp dumpCharsBegin

  dumpChars:
  rol edx, 5
  mov eax, edx
  and eax, 11111b

  dumpCharsBegin:
  cmp eax, 1Ah
  jb letter
  add eax, 16h
  jmp dump

  letter:
  add eax, 41h

  dump:
  mov [edi+ebx], al
  inc ebx

  inc ebp
  cmp ebp, 7
  jb dumpChars

  dumpCharsEnd:
  mov byte ptr[edi+ebx], '-'
  inc ebx

  inc ecx
  cmp ecx, 9
  jb translate

  dec ebx
  mov byte ptr[edi+ebx], 0

  pop ebp

  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  jmp EndGenerate

  ValidityError:
  INVOKE SetDlgItemText, hWnd, IDC_ID, ADDR sNameError
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sNameError

  EndGenerate:
  ret
Generate ENDP

buildTable      proc near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp
                pusha
                mov     eax, 0FFFEFDFCh
                mov     ecx, 40h

loc_4041F4:
                mov     ds:tableHeader[ecx*4], eax
                sub     eax, 4040404h
                dec     ecx
                jnz     short loc_4041F4
                xor     eax, eax
                mov     edi, [ebp+arg_0]

loc_404208:
                xor     ebx, ebx
                mov     esi, [ebp+arg_4]
                jmp     short loc_404214

loc_40420F:
                inc     bl
                dec     esi
                jz      short loc_404208

loc_404214:
                mov     dl, ds:table[ecx]
                add     al, [ebx+edi]
                add     al, dl
                mov     dh, ds:table[eax]
                mov     ds:table[ecx], dh
                mov     ds:table[eax], dl
                inc     cl
                jnz     short loc_40420F
                popa
                leave
                retn    8
buildTable      endp

coolXor         proc near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp
                pusha
                mov     edi, [ebp+arg_4]
                mov     esi, [ebp+arg_0]
                test    edi, edi
                jz      short loc_404289
                xor     eax, eax
                xor     ebx, ebx
                xor     ecx, ecx
                xor     edx, edx

loc_404250:
                inc     bl
                mov     dl, ds:table[ebx]
                add     al, dl
                mov     cl, ds:table[eax]
                mov     ds:table[ebx], cl
                mov     ds:table[eax], dl
                add     cl, dl
                mov     cl, ds:table[ecx]
                xor     [esi], cl
                inc     esi
                dec     edi
                jnz     short loc_404250
                xor     eax, eax
                mov     edi, offset table
                mov     ecx, 40h
                cld
                rep stosd

loc_404289:
                popa
                leave
                retn    8
coolXor         endp
; ------------------------------------------------------------------------------

; Copying
; ------------------------------------------------------------------------------
Copy PROC USES ebx hWnd:HWND
  mov ebx, FALSE ; success flag

  INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

  .IF eax
    INVOKE OpenClipboard, hWnd

    .IF eax
      INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

      .IF eax != NULL
        push eax
        push eax

        ; Copy the serial into the clipboard
        INVOKE GlobalLock, eax
        mov edi, eax
        mov esi, OFFSET sSerial
        mov ecx, SIZEOF sSerial
        rep movsb
        pop eax
        INVOKE GlobalUnlock, eax

        INVOKE EmptyClipboard
        pop eax
        INVOKE SetClipboardData, CF_TEXT, eax
        mov ebx, TRUE
      .ENDIF

      INVOKE CloseClipboard
    .ENDIF

  .ENDIF

  .IF ebx
    INVOKE MessageBox, hWnd, ADDR sCopySuccess, SADD("Information"), MB_ICONINFORMATION OR MB_OK
  .ELSE
    INVOKE MessageBox, hWnd, ADDR sCopyError, SADD("Error"), MB_ICONERROR OR MB_OK
  .ENDIF

  ret
Copy ENDP
; ------------------------------------------------------------------------------