; Keymaker - devilz KeyGen-me N5
; ==============================================================================
; Author : Canter <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0

; Libs used

; Functions
Initialize PROTO : HWND
CheckName  PROTO : LPCTSTR
Generate   PROTO : HWND
QuickCopy  PROTO : HWND

.data

; Parameters (defined)
; ------------------------------------------------------------------------------

; Required data
sTitle      TCHAR "devilz KeyGen-me N5 keymaker", 0
sAuthor     TCHAR "Canter", 0
sInfo       TCHAR "Protection: modified CRC-32, maths (FPU)", 10, 13
            TCHAR 10, 13
            TCHAR "Thanks to: +Analyst, Iczelion, ShmeitCorp, Lise_Grim, +Christal, NGEN", 10, 13
            TCHAR 10, 13
            TCHAR "Greetings fly out to: ICI (RIP), FFF, RIF and all those who are listed using the #Ran function of this keymaker...", 10, 13
            TCHAR 10, 13
            TCHAR "Music: Ghidorah - Toilet Story", 0
            
sNameError  TCHAR "Please enter a name...", 0
sMakeOK     TCHAR "The serial has been copied into the clipboard.", 0

; Defined-variables
nMaxPath  DWORD 0FFh
nSysFlags DWORD 000700FFh

; CRC-32 & "FPUHash" tables
include tables.asm

; Used in the polynomial
nTwo DWORD 2

; ------------------------------------------------------------------------------

.data?

; Parameters (undefined)
; ------------------------------------------------------------------------------

; Required data
sName   CHAR 20h dup(?)
sSerial CHAR 60h dup(?)

; Undefined-variables

nNameLen DWORD ?

sWinDir  TCHAR MAX_PATH dup(?)
sRoot    TCHAR 10       dup(?)
sVolName TCHAR 50       dup(?)
sFileSys TCHAR 50       dup(?)
nVolNum  DWORD          ?

nModifVolN DWORD ?
nModif     DWORD ?
nFinalRes  DWORD ?
nCRC32     DWORD ?

; Polynomial
nA     DWORD ?
nB     DWORD ?
nDelta DWORD ?

p1 DWORD ?
p2 DWORD ?
p3 DWORD ?
p4 DWORD ?
; ------------------------------------------------------------------------------

.code

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC hWnd: HWND

  ; Set the limit for the name text field
  INVOKE SendDlgItemMessage, hWnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF sName - 1, 0

  INVOKE SetDlgItemText, hWnd, IDC_NAME, ADDR sAuthor
  INVOKE Generate, hWnd
  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; I. Name-checking
; Input : pName
; Output: name length or 0 (failure)
; ------------------------------------------------------------------------------
CheckName PROC pName: LPCTSTR
  INVOKE lstrlen, pName
  ret
CheckName ENDP
; ------------------------------------------------------------------------------

; II. Serial-generation
; ------------------------------------------------------------------------------
Generate PROC USES ebx esi edi hWnd: HWND

  INVOKE GetDlgItemText, hWnd, IDC_NAME, ADDR sName, SIZEOF sName
  INVOKE CheckName, ADDR sName
  test eax, eax
  je @@validityerror

  ; Generation routine

  mov nNameLen, eax

  ; Get disk serial number
  INVOKE GetWindowsDirectory, ADDR sWinDir, SIZEOF sWinDir
  INVOKE lstrcpyn, ADDR sRoot, ADDR sWinDir, 4
  INVOKE GetVolumeInformation, ADDR sRoot, ADDR sVolName, SIZEOF sVolName, ADDR nVolNum, ADDR nMaxPath, ADDR nSysFlags, ADDR sFileSys, SIZEOF sFileSys

  ; Compute p1
  mov ecx, nVolNum
  mov ebx, nVolNum
  and ecx, 0FFFFh
  shr ebx, 10h
  add ecx, ebx
  and ecx, 0FFFFh
  mov p1, ecx

  and ebx, 5Fh
  mov nModifVolN, ebx

  xor ecx, ecx
  xor edx, edx
  mov cl, byte ptr nNameLen
  mov nCRC32, 0FD12EA30h    ; modified CRC-32 (init != 0)

  ; Compute p3
  CRC32:
  movzx eax, sName[edx]
  mov ebx, nCRC32
  and ebx, 0FFh
  xor eax, ebx
  mov eax, CRCTable[eax*4]
  mov ebx, nCRC32
  shr ebx, 8
  xor eax, ebx
  mov nCRC32, eax
  inc edx
  loopne CRC32
  not eax
  mov p3, eax

  ; Compute p2
  mov ecx, eax
  mov eax, nCRC32
  and eax, 0FFFFh
  shr ecx, 10h
  and eax, ecx
  and ax, 0FF00h
  mov p2, eax

  xor esi, esi
  movsx edx, byte ptr nNameLen
  dec edx

  sumName:
  movsx ebx, sName[edx]
  add esi, ebx
  imul esi, ebx
  lea esi, [esi+ebx*4]
  dec edx
  cmp edx, -1
  jnz sumName

  mov ebx, esi
  add bl, bh
  movzx ecx, word ptr p2
  mov cl, 1
  xor cl, bl
  sub cl, ch
  mov p2, ecx

  call sub_401499
  cmp eax, -1
  je @@exception

  mov eax, nModifVolN
  mov nA, eax
  mov eax, nModif
  mov nB, eax

  mov ebx, nB
  imul ebx, ebx
  mov eax, nA
  imul eax, -74565 * 4
  sub ebx, eax
  mov nDelta, ebx
  cmp nDelta, 0
  jb @@exception

  ; Compute p4, the positive root of equation: ax^2 + bx + c
  fild nDelta
  fsqrt
  fild nB
  fchs
  faddp st(1), st
  fild nTwo
  fimul nA
  fdivp st(1), st
  fstp p4
  wait

  mov eax, p4
  bswap eax
  xor eax, 2004h
  sub eax, nCRC32
  bswap eax
  mov p4, eax

  INVOKE wsprintf, ADDR sSerial, SADD("devilz-%04X-%04X-%08X-%08X"), p1, p2, p3, p4

  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  jmp @@endgenerate

  @@exception:
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, SADD("No serial exists for this name.")
  jmp @@endgenerate

  @@validityerror:
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sNameError

  @@endgenerate:
  ret
Generate ENDP

sub_401499      proc near               ; CODE XREF: DialogFunc+146 p
                push ebx
                push esi
                push edi
                mov     edx, nCRC32
                not     edx
                mov     eax, nCRC32
                call    sub_40158A
                and     edx, 0FFh
                mov     ecx, edx
                xor     edx, edx
                test ecx, ecx
                je @@divby0
                div     ecx
                mov     al, FPUHash[edx]
                and     eax, 0ABh
                mov     ebx, nModifVolN
                xor     eax, ebx
                mov     nModifVolN, eax
                mov     edx, nCRC32
                bswap   edx
                mov     eax, nCRC32
                add     eax, edx
                call    sub_40158A
                and     edx, 0FFh
                mov     ecx, edx
                xor     edx, edx
                test ecx, ecx
                je @@divby0
                div     ecx
                mov     al, FPUHash[edx]
                and     eax, 0FBh
                mov     nModif, eax
                mov     ecx, 50h
                mov     eax, nCRC32

loc_40150A:                             ; CODE XREF: sub_401499+7E j
                add     eax, 2004h
                xor     eax, 4002h
                imul    eax, ecx
                loopne  loc_40150A
                and     eax, 0FFh
                jmp @@endFPUHash

                @@divby0:
                mov eax, -1

                @@endFPUHash:
                pop edi
                pop esi
                pop ebx
                retn
sub_401499      endp

sub_40158A      proc near               ; CODE XREF: sub_401499+E p
                                        ; sub_401499+46 p
                mov     ecx, 0FFh

loc_40158F:                             ; CODE XREF: sub_40158A+73 j
                add     eax, ecx
                xor     edx, ecx
                shl     eax, 1
                ror     edx, 1
                imul    eax, edx
                add     eax, ecx
                add     eax, edx
                xor     edx, ecx
                shr     eax, 3
                rol     edx, 5
                imul    eax, edx
                add     eax, ecx
                add     eax, edx
                xor     edx, ecx
                shl     eax, 2
                ror     edx, 4
                imul    eax, edx
                add     eax, ecx
                add     eax, edx
                xor     edx, ecx
                shr     eax, 1
                rol     edx, 1
                imul    eax, edx
                add     eax, ecx
                add     eax, edx
                xor     edx, ecx
                shl     eax, 1
                ror     edx, 3
                imul    eax, edx
                add     eax, ecx
                add     eax, edx
                xor     edx, ecx
                shr     eax, 2
                rol     edx, 5
                imul    eax, edx
                add     eax, ecx
                add     eax, edx
                xor     edx, ecx
                shl     eax, cl
                ror     edx, cl
                imul    eax, edx
                add     eax, ecx
                add     eax, edx
                xor     edx, ecx
                shr     eax, 1
                rol     edx, 3
                imul    eax, edx
                loopne  loc_40158F
                add     eax, 2004h
                sub     edx, 2004h
                retn
sub_40158A      endp
; ------------------------------------------------------------------------------

; III. Quick Copy
; ------------------------------------------------------------------------------
QuickCopy PROC hWnd: HWND
  INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

  .IF eax
    INVOKE OpenClipboard, hWnd

    .IF eax
      INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

      .IF eax != NULL
        push eax
        push eax

        ; Copy the serial into the clipboard
        INVOKE GlobalLock, eax
        mov edi, eax
        mov esi, OFFSET sSerial
        mov ecx, SIZEOF sSerial
        rep movsb
        pop eax
        INVOKE GlobalUnlock, eax

        INVOKE EmptyClipboard
        pop eax
        INVOKE SetClipboardData, CF_TEXT, eax
      .ENDIF

      INVOKE CloseClipboard

      INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sMakeOK
    .ENDIF

  .ENDIF

  ret
QuickCopy ENDP
; ------------------------------------------------------------------------------