; Keymaker
; ==============================================================================
; Author : Canter <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v3.0

.486
.model flat, stdcall
option casemap: none

; Library imports
; ------------------------------------------------------------------------------

; Windows API
include    \masm32\include\windows.inc
include    \masm32\include\user32.inc
includelib \masm32\lib\user32.lib
include    \masm32\include\kernel32.inc
includelib \masm32\lib\kernel32.lib
include    \masm32\include\gdi32.inc
includelib \masm32\lib\gdi32.lib

; XM player
include    mfmplayer\mfmplayer.inc
includelib mfmplayer\mfmplayer.lib

; MASM32 macros
include    \masm32\macros\macros.asm

; ------------------------------------------------------------------------------

; Functions
; ------------------------------------------------------------------------------
DialogProc    PROTO : HWND, : UINT, : WPARAM, : LPARAM
InfoProc      PROTO : HWND, : UINT, : WPARAM, : LPARAM
ShowInfo2Proc PROTO : HWND, : UINT, : WPARAM, : LPARAM
DrawItem      PROTO : HWND, : LPARAM
; ------------------------------------------------------------------------------

.const

; Resource ids
; ------------------------------------------------------------------------------

; Dialogs
IDD_KEYMAKER  = 100
IDD_INFO      = 101

; Keymaker
IDI_KEYMAKER  = 200
IDC_TITLE     = 400
IDC_SHOWINFO2 = 401
IDC_DRAWNAME  = 402
IDC_NAME      = 403
IDC_SERIAL    = 404
IDC_GENERATE  = 405
IDC_SHOWINFO  = 406
IDC_QUICKCOPY = 407
IDC_EXIT      = 408
IDM_KEYMAKER  = 500

; Information
IDC_INFO      = 409
IDC_CLOSE     = 410

; ------------------------------------------------------------------------------

; Colors
; ------------------------------------------------------------------------------
CR_BACKGROUND = 0361E7Fh
CR_FOREGROUND = 0583D9Ah
CR_HIGHLIGHT  = 0E7E7F7h
CR_INPUT      = 07A69BFh
CR_INPUT2     = 0897FCFh
CR_TEXT       = 0CFCCF0h
; ------------------------------------------------------------------------------

.data

sCRLF            TCHAR 10, 13, 0
bAutoUpdate      BOOL TRUE

.data?

hInstance        HINSTANCE ?
DefShowInfo2Proc WNDPROC   ?
sInfoBuf         TCHAR     200h dup(?)

; Images
hIcon            HICON     ?
hHandCursor      HCURSOR   ?

; Brushes & pens
hBgColor         HBRUSH    ?
hFgColor         HBRUSH    ?
hInColor         HBRUSH    ?
hIn2Color        HBRUSH    ?
hEdge            HPEN      ?

; Font & text
BoldFont         LOGFONT   <?>
sBtnText         TCHAR     16 dup(?)

; Music
nMusicSize       DWORD     ?
pMusic           LPVOID    ?

.code

; Local modules
; ------------------------------------------------------------------------------
include macros.asm
include functions.asm      ; a small set of common functions
include greetings.list.asm ; a list of crackers names
include release.asm        ; all information about the current release
; ------------------------------------------------------------------------------

start:

; Main procedure
; ------------------------------------------------------------------------------
INVOKE GetModuleHandle, NULL
mov hInstance, eax

; Load icon & cursor
INVOKE LoadIcon, eax, IDI_KEYMAKER
mov hIcon, eax
INVOKE LoadCursor, NULL, IDC_HAND
mov hHandCursor, eax

; Create brushes for custom colors
INVOKE CreateSolidBrush, CR_BACKGROUND
mov hBgColor, eax
INVOKE CreateSolidBrush, CR_FOREGROUND
mov hFgColor, eax
INVOKE CreateSolidBrush, CR_INPUT
mov hInColor, eax
INVOKE CreateSolidBrush, CR_INPUT2
mov hIn2Color, eax
INVOKE CreatePen, PS_INSIDEFRAME, 1, CR_BACKGROUND
mov hEdge, eax

; Load dynamically the music
push esi
INVOKE FindResource, hInstance, IDM_KEYMAKER, RT_RCDATA
push eax
INVOKE SizeofResource, hInstance, eax
mov nMusicSize, eax
pop eax
INVOKE LoadResource, hInstance, eax
INVOKE LockResource, eax
mov esi, eax
mov eax, nMusicSize
add eax, SIZEOF nMusicSize
INVOKE GlobalAlloc, GPTR, eax
mov pMusic, eax
mov ecx, nMusicSize
mov dword ptr [eax], ecx
add eax, SIZEOF nMusicSize
mov edi, eax
rep movsb
pop esi

; Display the main dialog box
INVOKE DialogBoxParam, hInstance, IDD_KEYMAKER, NULL, ADDR DialogProc, 0

; Restore the memory used for the music
INVOKE GlobalFree, pMusic

; Restore the memory used for graphic objects
INVOKE DeleteObject, hEdge
INVOKE DeleteObject, hInColor
INVOKE DeleteObject, hIn2Color
INVOKE DeleteObject, hFgColor
INVOKE DeleteObject, hBgColor

; Exit the program
INVOKE ExitProcess, 0
; ------------------------------------------------------------------------------

; Main dialog procedure
; ------------------------------------------------------------------------------
DialogProc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_CTLCOLORDLG

    ; Fill the dialog window with the background color
    mov eax, hBgColor
    ret

  .ELSEIF uMsg == WM_CTLCOLORSTATIC
    INVOKE SetBkMode, wParam, TRANSPARENT

    INVOKE GetDlgCtrlID, lParam

    .IF eax == IDC_TITLE

      ; Change the font of the title

      INVOKE SendMessage, hWnd, WM_GETFONT, 0, 0
      INVOKE GetObject, eax, SIZEOF LOGFONT, ADDR BoldFont
      mov BoldFont.lfWeight, FW_BOLD
      mov BoldFont.lfItalic, TRUE
      INVOKE CreateFontIndirect, ADDR BoldFont
      INVOKE SelectObject, wParam, eax

      INVOKE SetTextColor, wParam, CR_HIGHLIGHT
      mov eax, hFgColor
      ret

    .ELSE

      .IF eax == IDC_SERIAL
        INVOKE SetTextColor, wParam, CR_HIGHLIGHT
      .ELSE
        INVOKE SetTextColor, wParam, CR_TEXT
      .ENDIF

      mov eax, hBgColor
      ret
    .ENDIF

  .ELSEIF uMsg == WM_CTLCOLOREDIT

    ; Set the name edit box colors
    INVOKE SetBkMode, wParam, TRANSPARENT
    INVOKE SetTextColor, wParam, CR_HIGHLIGHT
    mov eax, hInColor
    ret

  .ELSEIF uMsg == WM_DRAWITEM

    ; Draw the owner-drawn controls (ie the buttons)
    INVOKE DrawItem, hWnd, lParam

  .ELSEIF uMsg == WM_LBUTTONDOWN

    ; Enable the user to drag the window by pressing the mouse button on it
    INVOKE SendMessage, hWnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam

  .ELSEIF uMsg == WM_COMMAND
    mov eax, wParam
    mov edx, wParam
    shr edx, 16

    .IF (edx == EN_UPDATE && ax == IDC_NAME) || wParam == IDC_GENERATE

      .IF bAutoUpdate || wParam == IDC_GENERATE

        ; Serial update
        INVOKE Generate, hWnd

      .ELSE
        INVOKE SetDlgItemText, hWnd, IDC_SERIAL, SADD("Please hit generate...")
      .ENDIF

    .ELSEIF wParam == IDC_SHOWINFO || wParam == IDC_SHOWINFO2

      ; Display the information dialog box
      INVOKE DialogBoxParam, hInstance, IDD_INFO, hWnd, ADDR InfoProc, 0

    .ELSEIF wParam == IDC_QUICKCOPY

      ; Make a keyfile or write a key in registry, etc...

      INVOKE CheckName, ADDR sName

      .IF eax
        INVOKE QuickCopy, hWnd
      .ENDIF

    .ELSEIF wParam == IDC_DRAWNAME

      ; Display a random cracker name

      push esi

      @@drawname:
      INVOKE GetRandomString, greetings_list_start, greetings_list_end
      mov esi, eax
      INVOKE CheckName, eax
      test eax, eax
      je @@drawname

      INVOKE SetDlgItemText, hWnd, IDC_NAME, esi
      pop esi

    .ELSEIF wParam == IDC_EXIT
      INVOKE SendMessage, hWnd, WM_CLOSE, 0, 0
    .ENDIF

  .ELSEIF uMsg == WM_INITDIALOG

    ; Subclass the bitmap control to change the cursor
    INVOKE GetDlgItem, hWnd, IDC_SHOWINFO2
    INVOKE SetWindowLong, eax, GWL_WNDPROC, ADDR ShowInfo2Proc
    mov DefShowInfo2Proc, eax

    INVOKE SendMessage, hWnd, WM_SETICON, ICON_BIG, hIcon

    INVOKE SetWindowText, hWnd, ADDR sTitle
    INVOKE SetDlgItemText, hWnd, IDC_TITLE, ADDR sTitle

    ; Start music
    INVOKE mfmPlay, pMusic

    INVOKE Initialize, hWnd
  .ELSEIF uMsg == WM_CLOSE

    ; Stop music
    INVOKE mfmPlay, 0

    INVOKE EndDialog, hWnd, 0
  .ENDIF

  xor eax, eax
  ret
DialogProc ENDP
; ------------------------------------------------------------------------------

; Info dialog procedure
; ------------------------------------------------------------------------------
InfoProc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_CTLCOLORDLG
    mov eax, hFgColor
    ret
  .ELSEIF uMsg == WM_CTLCOLORSTATIC
    INVOKE SetBkMode, wParam, TRANSPARENT
    INVOKE SetTextColor, wParam, CR_TEXT
    mov eax, hBgColor
    ret
  .ELSEIF uMsg == WM_DRAWITEM
    INVOKE DrawItem, hWnd, lParam
  .ELSEIF uMsg == WM_COMMAND

    .IF wParam == IDC_CLOSE
      INVOKE SendMessage, hWnd, WM_CLOSE, 0, 0
    .ENDIF

  .ELSEIF uMsg == WM_INITDIALOG

    ; Make the final information string
    INVOKE lstrcpy, ADDR sInfoBuf, SADD("*")
    INVOKE lstrcat, ADDR sInfoBuf, ADDR sTitle
    INVOKE lstrcat, ADDR sInfoBuf, SADD("*")
    INVOKE lstrcat, ADDR sInfoBuf, ADDR sCRLF
    INVOKE lstrcat, ADDR sInfoBuf, SADD("by ")
    INVOKE lstrcat, ADDR sInfoBuf, ADDR sAuthor
    INVOKE lstrcat, ADDR sInfoBuf, ADDR sCRLF
    INVOKE lstrcat, ADDR sInfoBuf, ADDR sCRLF
    INVOKE lstrcat, ADDR sInfoBuf, ADDR sInfo

    INVOKE SetDlgItemText, hWnd, IDC_INFO, ADDR sInfoBuf
  .ELSEIF uMsg == WM_CLOSE
    INVOKE EndDialog, hWnd, 0
  .ENDIF

  xor eax, eax
  ret
InfoProc ENDP
; ------------------------------------------------------------------------------

; Bitmap control procedure
; ------------------------------------------------------------------------------
ShowInfo2Proc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_SETCURSOR
    INVOKE SetCursor, hHandCursor
  .ELSE
    INVOKE CallWindowProc, DefShowInfo2Proc, hWnd, uMsg, wParam, lParam
    ret
  .ENDIF

  xor eax, eax
  ret
ShowInfo2Proc ENDP
; ------------------------------------------------------------------------------

; Custom draw of buttons
; ------------------------------------------------------------------------------
DrawItem PROC hWnd: HWND, lParam: LPARAM
  push esi
  mov esi, lParam
  assume esi: ptr DRAWITEMSTRUCT

  ; Change the control background color if pushed
  .IF [esi].itemState & ODS_SELECTED
    INVOKE SelectObject, [esi].hdc, hIn2Color
  .ELSE
    INVOKE SelectObject, [esi].hdc, hInColor
  .ENDIF

  INVOKE SelectObject, [esi].hdc, hEdge

  INVOKE FillRect, [esi].hdc, ADDR [esi].rcItem, hFgColor
  INVOKE RoundRect, [esi].hdc, [esi].rcItem.left, [esi].rcItem.top, [esi].rcItem.right, [esi].rcItem.bottom, 6, 6

  .IF [esi].itemState & ODS_SELECTED
    INVOKE OffsetRect, ADDR [esi].rcItem, 1, 1
  .ENDIF

  ; Write the text
  INVOKE GetDlgItemText, hWnd, [esi].CtlID, ADDR sBtnText, SIZEOF sBtnText
  INVOKE SetBkMode, [esi].hdc, TRANSPARENT
  INVOKE SetTextColor, [esi].hdc, CR_HIGHLIGHT
  INVOKE DrawText, [esi].hdc, ADDR sBtnText, -1, ADDR [esi].rcItem, DT_CENTER or DT_VCENTER or DT_SINGLELINE

  .IF [esi].itemState & ODS_SELECTED
    INVOKE OffsetRect, ADDR [esi].rcItem, -1, -1
  .ENDIF

  ; Change the position of the text
  .IF [esi].itemState & ODS_FOCUS
    INVOKE InflateRect, ADDR [esi].rcItem, -3, -3
    INVOKE DrawFocusRect, [esi].hdc, ADDR [esi].rcItem
  .ENDIF

  assume esi:nothing
  pop esi
  mov eax, TRUE
  ret
DrawItem ENDP
; ------------------------------------------------------------------------------

END start