; Keygen - Winamp
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.1

; libraries used
INCLUDE    \masm32\INCLUDE\advapi32.inc
INCLUDELIB \masm32\LIB\advapi32.lib

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation
Copy       PROTO :HWND ; copying into the clipboard or the registry, a keyfile...

; configuration
AUTO_UPDATE   = TRUE
MULTI_SERIALS = TRUE

.DATA

; parameters
; ------------------------------------------------------------------------------

; required data
% sTitle       TCHAR "NGEN - Winamp &TARGETVERSION keymaker", 0 ; target version defined in the batch file for quick update
  sInformation TCHAR "Protection: Crypto {Base32, SHA-1}", 0
  sSignature   TCHAR "Canterwood", 0

  sNameError   TCHAR "You should enter a name.", 0
  sCopySuccess TCHAR "The serial has been written in the registry.", 0
  sCopyError   TCHAR "An error occured, please copy the serial by hand.", 0

; defined variables
aNullString     DWORD 0
aProductKey     BYTE  0E7h, 04Ah, 067h, 03Ch, 044h, 005h, 00Bh, 039h, 0B9h, 0D2h, 0EBh, 063h, 0CCh, 0FDh, 007h, 069h
sBase32Alphabet CHAR "OL23456789ABCDEFHJKMNPQRSTUVWXYZ", 0

.DATA?

; required data
sName   CHAR 20h dup(?)
sSerial CHAR 60h dup(?)

; undefined variables
nMagic1      DWORD         ?
nMagic2      DWORD         ?
aMagics      DWORD 3   dup(?)
aSHA1Data    BYTE  400 dup(?)
aSHA1Hash    DWORD 3   dup(?)
aBase32Input DWORD 3   dup(?)
nChecksum    DWORD         ?
sKey         CHAR  60h dup(?)

hKey            HKEY  ?
pSerial         DWORD ?
sCryptedSerial2 CHAR  ?
sCryptedSerial1 CHAR  SIZEOF sSerial dup(?)

; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC hWnd: HWND
  LOCAL nNameSize:DWORD

  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_INFORMATION, ADDR sInformation
  INVOKE SetDlgItemText, hWnd, IDC_SIGNATURE, ADDR sSignature

  ; Set the limit for the name text field
  INVOKE SendDlgItemMessage, hWnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF sName - 1, 0

  mov nNameSize, SIZEOF sName

  ; Retrieve the default username
  INVOKE GetUserName, ADDR sName, ADDR nNameSize

  .IF eax
    INVOKE SetDlgItemText, hWnd, IDC_NAME, ADDR sName
  .ENDIF

  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------
Random PROC nRange: DWORD
  INVOKE GetTickCount
  mov ecx, 41C64E6Dh
  mul ecx
  add eax, 3039h
  and eax, 7FFFFFFh
  mov ecx, nRange
  sub edx, edx
  div ecx
  xchg eax, edx
  ret
Random ENDP

include SHA-1.asm

Generate PROC USES ebx esi edi hWnd: HWND
  INVOKE GetDlgItemText, hWnd, IDC_NAME, ADDR sName, SIZEOF sName
  cmp eax, 0
  je nameError

  ; set magic numbers 1 & 2 (variants of serial)
  ;INVOKE Random, 111111b
  ;inc eax                      ; 1 = Winamp 5.0 serial, other = Winamp > 5.0
  mov eax, 111111b
  mov nMagic1, eax
  INVOKE Random, 111111111111b
  inc eax
  mov nMagic2, eax

  ; hash the name using the SHA-1 algorithm (ripped from Winamp)

  lea     eax, aSHA1Data
  push    eax
  call    SHA1Init

  push    OFFSET sName
  lea     eax, aSHA1Data
  push    eax
  call    SHA1Set

  lea     eax, nMagic1
  lea     ebx, nMagic2
  push    1
  mov     al, [eax]
  mov     byte ptr [aMagics+0*SIZEOF DWORD], al
  mov     al, [ebx]
  mov     byte ptr [aMagics+1*SIZEOF DWORD], al
  mov     eax, [ebx]
  sar     eax, 8
  mov     byte ptr [aMagics+2*SIZEOF DWORD], al
  lea     eax, [aMagics+0*SIZEOF DWORD]
  push    eax
  lea     eax, aSHA1Data
  push    eax
  call    SHA1Core

  lea     eax, [aMagics+1*SIZEOF DWORD]
  push    1
  push    eax
  lea     eax, aSHA1Data
  push    eax
  call    SHA1Core

  lea     eax, [aMagics+2*SIZEOF DWORD]
  push    1
  push    eax
  lea     eax, aSHA1Data
  push    eax
  call    SHA1Core

  push    10h
  lea     eax, aSHA1Data
  push    offset aProductKey
  push    eax
  call    SHA1Core

  lea     eax, aSHA1Hash
  push    eax
  lea     eax, aSHA1Data
  push    eax
  call    SHA1Hash
  add     esp, 44h

  ; modify a bit the hash using the magic numbers

  mov edx, nMagic1
  lea edi, aSHA1Hash
  mov ecx, 5

  mapMagic1:
  mov eax, edx
  and eax, 1b
  shl eax, 7
  and byte ptr[edi+ecx], 1111111b
  or byte ptr[edi+ecx], al
  shr edx, 1
  dec ecx
  jns mapMagic1

  mov edx, nMagic2
  add edi, 6
  xor ecx, ecx

  mapMagic2:
  mov eax, edx
  and eax, 11b
  shl eax, 6
  and byte ptr[edi+ecx], 111111b
  or byte ptr[edi+ecx], al
  shr edx, 2
  inc ecx
  cmp ecx, 6
  jb mapMagic2

  ; reverse the hash and compute the checksum

  lea esi, aSHA1Hash
  lea edi, aBase32Input
  mov ecx, 12
  xor ebx, ebx
  mov edx, 0Bh

  reverseHash:
  movzx eax, byte ptr[esi+ecx-1]
  xor edx, eax
  mov byte ptr[edi+ebx], al
  inc ebx
  dec ecx
  jnz reverseHash

  and edx, 0Fh
  mov nChecksum, edx
  mov ecx, 2

  swapHash:
  mov eax, [edi+ecx*SIZEOF DWORD]
  bswap eax
  mov [edi+ecx*SIZEOF DWORD], eax
  dec ecx
  jns swapHash

  ; format the hash using a kind of Base32 algorithm

  lea ebx, sBase32Alphabet
  lea esi, aBase32Input
  lea edi, sKey
  xor ecx, ecx
  push ebp

  Base32Encode:
  mov eax, [esi+2*SIZEOF DWORD]
  and eax, 11111b
  mov ebp, eax
  movzx eax, byte ptr[ebx+eax]
  mov byte ptr[edi+ecx], al

  mov eax, [esi+2*SIZEOF DWORD]
  shr eax, 5
  mov edx, [esi+1*SIZEOF DWORD]
  and edx, 11111b
  shl edx, 27
  or eax, edx
  mov [esi+2*SIZEOF DWORD], eax

  mov eax, [esi+1*SIZEOF DWORD]
  shr eax, 5
  mov edx, [esi+0*SIZEOF DWORD]
  and edx, 11111b
  shl edx, 27
  or eax, edx
  mov [esi+1*SIZEOF DWORD], eax

  mov eax, [esi+0*SIZEOF DWORD]
  shr eax, 5
  mov [esi+0*SIZEOF DWORD], eax

  inc ecx
  cmp ecx, 20
  jb Base32Encode
  mov eax, ebp
  pop ebp

  ; add checksum information
  mov edx, nChecksum
  dec ecx
  add ebx, eax
  movzx eax, byte ptr[ebx+edx*2]
  mov byte ptr[edi+ecx], al

  ; add serial delimiters

  lea esi, sKey
  lea edi, sSerial
  xor ecx, ecx
  xor ebx, ebx

  formatKey:
  movzx eax, byte ptr[esi+ecx]
  test eax, eax
  je endFormatKey
  mov byte ptr[edi+ebx], al
  push ecx
  mov eax, ecx
  mov ecx, 5
  cdq
  div ecx
  cmp edx, 4
  jnz noDelimiter
  inc ebx
  mov byte ptr[edi+ebx], '-'

  noDelimiter:
  pop ecx
  inc ecx
  inc ebx
  jmp formatKey

  endFormatKey:
  dec ebx
  mov byte ptr[edi+ebx], 0
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  mov eax, TRUE
  jmp endGenerate

  nameError:
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sNameError
  mov eax, FALSE

  endGenerate:
  ret
Generate ENDP
; ------------------------------------------------------------------------------

; Copying
; ------------------------------------------------------------------------------
Copy PROC USES ebx esi edi hWnd:HWND
  mov ebx, FALSE ; success flag

  INVOKE RegCreateKeyEx, HKEY_LOCAL_MACHINE, SADD("SOFTWARE\Nullsoft\Winamp"), 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, ADDR hKey, NULL

  .IF eax == ERROR_SUCCESS

    ; write the name in the registry
    INVOKE lstrlen, ADDR sName
    inc eax
    INVOKE RegSetValueEx, hKey, SADD("regname"), 0, REG_SZ, ADDR sName, eax

    ; crypt the serial and add it (ripped from Winamp)

    push ebx
    xor ebx, ebx
    inc ebx
    lea eax, sSerial
    mov pSerial, eax

    push    20h
    lea     eax, sCryptedSerial1
    push    pSerial
    push    eax
    call    ds:lstrcpynA
    cmp     byte ptr[sCryptedSerial1], 0
    mov     [sCryptedSerial2], 7Eh
    mov     edi, ebx
    jz      short loc_442673
    mov     [pSerial], 1Bh

    loc_442618:
    lea     esi, [OFFSET sCryptedSerial2+edi]
    movsx   eax, byte ptr [esi]
    cmp     al, 41h
    jl      short loc_442643
    cmp     al, 5Ah
    jg      short loc_442643
    movsx   eax, al
    push    1Ah
    lea     eax, [eax+edi-41h]
    pop     ecx
    cdq
    idiv    ecx
    add     dl, 41h

    loc_44263F:
    mov     [esi], dl
    jmp     short loc_442667

    loc_442643:
    cmp     al, 30h
    jl      short loc_442660
    cmp     al, 39h
    jg      short loc_442660
    mov     ecx, pSerial
    push    0Ah
    movsx   eax, al
    lea     eax, [eax+ecx-30h]
    pop     ecx
    cdq
    idiv    ecx
    add     dl, 61h
    jmp     short loc_44263F

    loc_442660:
    cmp     al, 2Dh
    jnz     short loc_442667
    mov     byte ptr [esi], 2Fh

    loc_442667:
    add     pSerial, 1Bh
    inc     edi
    cmp     [OFFSET sCryptedSerial2+edi], 0
    jnz     short loc_442618

    loc_442673:
    INVOKE lstrlen, ADDR sCryptedSerial2
    inc eax
    INVOKE RegSetValueEx, hKey, SADD("regkey"), 0, REG_SZ, ADDR sCryptedSerial2, eax
    INVOKE RegCloseKey, hKey
    pop ebx

    mov ebx, TRUE
  .ENDIF

  .IF ebx
    INVOKE MessageBox, hWnd, ADDR sCopySuccess, SADD("Information"), MB_ICONINFORMATION OR MB_OK
  .ELSE
    INVOKE MessageBox, hWnd, ADDR sCopyError, SADD("Error"), MB_ICONERROR OR MB_OK
  .ENDIF

  mov eax, TRUE
  ret
Copy ENDP
; ------------------------------------------------------------------------------