; Keygen
; ==============================================================================
; Author      : Canterwood <canterwood@altern.org>
; Website     : http://zor.org/canterwood
; IDE         : MASM32 8
; Compilation :
; - RC keygen.rc
; - ML /c /Cp /coff /Gz keygen.asm
; - LINK /RELEASE /SUBSYSTEM:WINDOWS keygen.obj keygen.res
; ==============================================================================
; v1.6

.486P       ; 486 instruction set, including privilegied ones
.MODEL FLAT

INCLUDE    \masm32\INCLUDE\windows.inc
INCLUDE    \masm32\INCLUDE\user32.inc
INCLUDELIB \masm32\LIB\user32.lib
INCLUDE    \masm32\INCLUDE\kernel32.inc
INCLUDELIB \masm32\LIB\kernel32.lib

DialogProc    PROTO :HWND, :UINT, :WPARAM, :LPARAM
EnableDlgItem PROTO :HWND, :DWORD, :BOOL

; functions defined in release.asm
Initialize PROTO :HWND
Generate   PROTO :HWND
Copy       PROTO :HWND

; MASM32 useful macros (SADD, CTXT...)
INCLUDE \masm32\MACROS\MACROS.ASM

IDI_KEYGEN      = 100
IDD_KEYGEN      = 200
IDC_NAME        = 300
IDC_GENERATE    = 301
IDC_SERIAL      = 302
IDC_COPY        = 303
IDC_INFORMATION = 304
IDC_SIGNATURE   = 305
IDC_EXIT        = 306

.DATA?

hInstance HINSTANCE ?

.CODE

; all information about the current release
INCLUDE release.asm

keygen:

INVOKE GetModuleHandle, NULL
mov hInstance, eax
INVOKE DialogBoxParam, eax, IDD_KEYGEN, NULL, ADDR DialogProc, 0
INVOKE ExitProcess, 0

DialogProc PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

  .IF uMsg == WM_COMMAND
    mov eax, wParam ; item, control, or accelerator identifier
    mov edx, eax    ; notification code
    and eax, 0FFFFh
    shr edx, 16

    .IF (eax == IDC_NAME && edx == EN_UPDATE)

      IF AUTO_UPDATE
        INVOKE Generate, hWnd

        .IF eax

          IF MULTI_SERIALS
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, TRUE
          ENDIF

          INVOKE EnableDlgItem, hWnd, IDC_COPY, TRUE
        .ELSE

          IF MULTI_SERIALS
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
          ENDIF

          INVOKE EnableDlgItem, hWnd, IDC_COPY, FALSE
        .ENDIF

      ELSE
        INVOKE EnableDlgItem, hWnd, IDC_GENERATE, TRUE
        INVOKE EnableDlgItem, hWnd, IDC_COPY, FALSE
        INVOKE SetDlgItemText, hWnd, IDC_SERIAL, SADD("Please hit Generate...")
      ENDIF

    .ELSEIF eax == IDC_GENERATE

      INVOKE Generate, hWnd

      .IF eax

        IFE AUTO_UPDATE

          IF MULTI_SERIALS
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, TRUE
          ELSE
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
          ENDIF

        ENDIF

        INVOKE EnableDlgItem, hWnd, IDC_COPY, TRUE
      .ELSE

        IFE AUTO_UPDATE
          INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
        ENDIF

        INVOKE EnableDlgItem, hWnd, IDC_COPY, FALSE
      .ENDIF

    .ELSEIF eax == IDC_COPY
      INVOKE Copy, hWnd

      .IF eax
        INVOKE EnableDlgItem, hWnd, IDC_COPY, FALSE
      .ENDIF
    .ELSEIF eax == IDC_EXIT
      INVOKE SendMessage, hWnd, WM_CLOSE, 0, 0
    .ENDIF

  .ELSEIF uMsg == WM_INITDIALOG
    INVOKE LoadIcon, hInstance, IDI_KEYGEN
    INVOKE SendMessage, hWnd, WM_SETICON, ICON_BIG, eax

    INVOKE Initialize, hWnd

    IF AUTO_UPDATE
      INVOKE Generate, hWnd

      IFE MULTI_SERIALS
        INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
      ENDIF
    ELSE
      INVOKE EnableDlgItem, hWnd, IDC_COPY, FALSE
      INVOKE SetDlgItemText, hWnd, IDC_SERIAL, SADD("Please hit Generate...")
    ENDIF

  .ELSEIF uMsg == WM_CLOSE
    INVOKE EndDialog, hWnd, 0
  .ENDIF

  xor eax, eax
  ret
DialogProc ENDP

EnableDlgItem PROC hWnd:HWND, nDlgItem:DWORD, bEnable:BOOL
  INVOKE GetDlgItem, hWnd, nDlgItem
  INVOKE EnableWindow, eax, bEnable
  ret
EnableDlgItem ENDP

END keygen ; set the entry point of module