; Keygen - WebExpert
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0

; libraries used
INCLUDE    \masm32\INCLUDE\advapi32.inc
INCLUDELIB \masm32\LIB\advapi32.lib
INCLUDE    mblowfish.asm
INCLUDE    mb64.asm

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation
Copy       PROTO :HWND ; copying into the clipboard or the registry, a keyfile...

; configuration
AUTO_UPDATE   = TRUE
MULTI_SERIALS = FALSE

.DATA

; parameters
; ------------------------------------------------------------------------------

; required data
sTeam        TCHAR "NGEN", 0
sSoftware    TCHAR "WebExpert", 0
sType        TCHAR "keygen", 0
sInformation TCHAR "Protection: {Blowfish, Base64} - Thanks to x3chun, roy", 0
sSignature   TCHAR "Canterwood", 0

; defined variables
aXorKeyRef DWORD 0677C7D6Bh, 04B180812h

.DATA?

; required data

pTargetVersion LPCTSTR         ?
sTitle         CHAR    40h dup(?)

sName   CHAR 20h dup(?)
sSerial CHAR 60h dup(?)

; undefined variables
sCheckedName  CHAR  20h dup(?)
aName         BYTE  60h dup(?)
aXorKey       DWORD  2h dup(?)
aSerial       BYTE  60h dup(?)
sBase64Serial CHAR  60h dup(?)

; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC hWnd: HWND
LOCAL nNameSize:DWORD

  ; copy the Blowfish keys innto the ctx structure
  lea esi, mblowfishkeys
  lea edi, ctx
  mov ecx, SIZEOF blowfishctx
  rep movsb

  ; make the release title
  INVOKE FindResource, hInstance, SADD("TARGETVERSION"), RT_RCDATA
  INVOKE LoadResource, hInstance, eax
  INVOKE LockResource, eax
  mov pTargetVersion, eax
  INVOKE wsprintf, ADDR sTitle, SADD("%s - %s %s %s"), ADDR sTeam, ADDR sSoftware, pTargetVersion, ADDR sType

  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_INFORMATION, ADDR sInformation
  INVOKE SetDlgItemText, hWnd, IDC_SIGNATURE, ADDR sSignature

  ; set the limit for the name text field
  INVOKE SendDlgItemMessage, hWnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF sName - 1, 0

  mov nNameSize, SIZEOF sName

  ; retrieve the default username
  INVOKE GetUserName, ADDR sName, ADDR nNameSize

  .IF eax
    INVOKE SetDlgItemText, hWnd, IDC_NAME, ADDR sName
  .ENDIF

  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------

; copied from IDA
CleanString PROC NEAR
lpString1 = dword ptr  4
arg_4     = dword ptr  8

  mov eax, [esp+arg_4]
  cmp byte ptr [eax], 20h
  jnz loc_1000C282

  loc_1000C279:
  mov cl, [eax+1]
  inc eax
  cmp cl, 20h
  jz loc_1000C279

  loc_1000C282:
  push esi
  mov esi, [esp+4+lpString1]
  push eax
  push esi
  call lstrcpy
  push esi
  call CharUpper
  push esi
  call DeleteSpaces
  add esp, 4
  pop esi
  retn
CleanString ENDP

; copied from IDA
DeleteSpaces PROC NEAR
lpString = dword ptr  8

  push esi
  mov esi, [esp+lpString]
  push esi
  call lstrlen
  test eax, eax
  jbe loc_1000C262

  loc_1000C250:
  mov cl, [eax+esi-1]
  dec eax
  cmp cl, 20h
  jnz loc_1000C262
  test eax, eax
  mov byte ptr [eax+esi], 0
  ja loc_1000C250

  loc_1000C262:
  pop esi
  retn
DeleteSpaces ENDP

Generate PROC USES ebx esi edi hWnd: HWND
  lea esi, aXorKeyRef
  lea edi, aXorKey
  mov ecx, 2
  rep movsd

  INVOKE GetDlgItemText, hWnd, IDC_NAME, ADDR sName, SIZEOF sName
  lea esi, sName
  xor ecx, ecx

  checkCharset:
  movzx eax, byte ptr[esi+ecx]
  test eax, eax
  je endCheckCharset
  cmp eax, 128
  jge charsetError
  inc ecx
  jmp checkCharset

  endCheckCharset:
  push OFFSET sName
  push OFFSET sCheckedName
  call CleanString
  INVOKE lstrlen, ADDR sCheckedName
  test eax, eax
  je nameError

  lea edi, aName
  INVOKE lstrcpy, edi, ADDR sCheckedName
  INVOKE lstrlen, eax
  mov ecx, eax
  and eax, 111b
  mov edx, 8
  sub edx, eax
  mov eax, edx

  pad:
  mov byte ptr[edi+ecx], dl
  inc ecx
  dec eax
  jnz pad

  shr ecx, 3
  mov ebx, ecx
  lea esi, aName
  lea edi, aSerial
  xor ecx, ecx
  mov edx, 8

  blowfishCrypt:

  push ebx
  lea ebx, aXorKey
  mov eax, [ebx]
  xor [esi], eax
  mov eax, [ebx+4]
  xor [esi+4], eax
  pop ebx

  mov eax, [esi]
  bswap eax
  mov [esi], eax
  mov eax, [esi+4]
  bswap eax
  mov [esi+4], eax
  INVOKE blowfish_encrypt, esi, edi
  mov eax, [edi]
  bswap eax
  mov [edi], eax
  mov eax, [edi+4]
  bswap eax
  mov [edi+4], eax

  push ebx
  lea ebx, aXorKey
  mov eax, [edi]
  mov [ebx], eax
  mov eax, [edi+4]
  mov [ebx+4], eax
  pop ebx

  add esi, edx
  add edi, edx
  inc ecx
  cmp ecx, ebx
  jnz blowfishCrypt

  imul ebx, 8
  INVOKE B64encode, ADDR sBase64Serial, ADDR aSerial, ebx
  INVOKE lstrcat, ADDR sBase64Serial, SADD("ZZZZZZZZZZZZZZZZ")

  ; print the serial
  lea esi, sBase64Serial
  lea edi, sSerial
  xor ecx, ecx
  xor ebx, ebx

  printSerial:
  movzx eax, byte ptr[esi+ecx]
  mov byte ptr[edi+ebx], al
  push ecx
  mov eax, ecx
  mov ecx, 4
  cdq
  div ecx
  cmp edx, 3
  jnz noDelimiter
  inc ebx
  mov byte ptr[edi+ebx], '-'

  noDelimiter:
  pop ecx
  inc ecx
  inc ebx
  cmp ecx, 16
  jb printSerial

  endPrintSerial:
  dec ebx
  mov byte ptr[edi+ebx], 0
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  mov eax, TRUE
  jmp endGenerate

  charsetError:
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, SADD("Only US/ASCII characters are allowed.")
  mov eax, FALSE
  jmp endGenerate

  nameError:
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, SADD("You should enter a valid name.")
  mov eax, FALSE
  jmp endGenerate

  endGenerate:
  ret
Generate ENDP
; ------------------------------------------------------------------------------

; Copying
; ------------------------------------------------------------------------------
Copy PROC USES ebx esi edi hWnd:HWND
  mov ebx, FALSE ; success flag

  INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

  .IF eax
    INVOKE OpenClipboard, hWnd

    .IF eax
      INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

      .IF eax != NULL
        push eax
        push eax

        ; Copy the serial into the clipboard
        INVOKE GlobalLock, eax
        mov edi, eax
        mov esi, OFFSET sSerial
        mov ecx, SIZEOF sSerial
        rep movsb
        pop eax
        INVOKE GlobalUnlock, eax

        INVOKE EmptyClipboard
        pop eax
        INVOKE SetClipboardData, CF_TEXT, eax
        mov ebx, TRUE
      .ENDIF

      INVOKE CloseClipboard
    .ENDIF

  .ENDIF

  .IF ebx
    INVOKE MessageBox, hWnd, SADD("The serial has been copied into the clipboard."), SADD("Information"), MB_ICONINFORMATION OR MB_OK
  .ELSE
    INVOKE MessageBox, hWnd, SADD("An error occured, please copy the serial by hand."), SADD("Error"), MB_ICONERROR OR MB_OK
  .ENDIF

  mov eax, TRUE
  ret
Copy ENDP
; ------------------------------------------------------------------------------