; Keymaker
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://kickme.to/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0 [28.12.2003]

.486
.model flat, stdcall
option casemap: none

; Lib functions
; ------------------------------------------------------------------------------
include \masm32\include\windows.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\advapi32.inc
include \masm32\include\comdlg32.inc

includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\advapi32.lib 
includelib \masm32\lib\comdlg32.lib
; ------------------------------------------------------------------------------

; Functions
; ------------------------------------------------------------------------------
DialogProc PROTO : HWND, : UINT, : WPARAM, : LPARAM
; ------------------------------------------------------------------------------

.const

; Resource ids
; ------------------------------------------------------------------------------
IDD_KEYMAKER equ 100

IDI_KEYMAKER equ 200

IDC_NAME     equ 400
IDC_REGISTER equ 401
IDC_RESTORE  equ 402
IDC_EXIT     equ 404
IDC_ABOUT    equ 403

IDR_KEYFILE  equ 500
; ------------------------------------------------------------------------------

MAX_PATH equ 260

.data

; Parameters
; ------------------------------------------------------------------------------

; Layout strings
szTitle       TCHAR "NGEN Terragen 0.8.11-0.9.19 keymaker", 0
szAbout       TCHAR " 2003 Canterwood [NGEN] - Image by Luc Bianco", 0
szDefaultName TCHAR "Canterwood [NGEN]", 0

; FindApp - Method 1
szAppPathKey       TCHAR "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\Terragen.exe", 0
szAppPathValueName TCHAR "Path", 0

; FindApp - Method 2
mszFilterString TCHAR "Terragen (Terragen.exe)", 0, "Terragen.exe", 0, 0
szOfnTitle      TCHAR "Select the target application", 0
szAppFilename   TCHAR "Terragen.exe", 0

; Keyfile
szKeyfileName TCHAR "\terragen.key", 0

; Messages
szErrorTitle     TCHAR "Error", 0
szInfoTitle      TCHAR "Information", 0
szLengthError    TCHAR "You must enter a name.", 0
szRegSuccess     TCHAR "The keyfile was successully created.", 10, 13
                 TCHAR "Terragen is now registered!", 0
szRestoreSuccess TCHAR "Terragen is unregistered.", 0
szError          TCHAR "An error occured. Process aborted.", 0

; Keymaker
szRegInfo     TCHAR "SOFTWARE\NGEN\Terragen keymaker", 0
szRegInfoType TCHAR "REG_SZ", 0

; Other
dwNameSize        DWORD SIZEOF szName
dwValueType       DWORD REG_SZ

.data?

; FindApp - Method 1
dwKeyfilePathSize DWORD ?

; FindApp - Method  2
ofn       OPENFILENAME <>
szAppPath TCHAR        MAX_PATH dup(?)

; Keyfile
szKeyfilePath  TCHAR  MAX_PATH dup(?)
hKeyfile       HANDLE ?
pKeyfile       LPVOID ?
dwKeyfileSize  DWORD  ?
dwBytesWritten DWORD  ?

; Keymaker
dwDisp DWORD ?

; Other
szName TCHAR 20h dup(?)
hkKey  HKEY ?
bOK    BOOL ?

; ------------------------------------------------------------------------------

hInstance HINSTANCE ?
hIcon     HICON     ?

.code

start:

INVOKE GetModuleHandle, NULL
mov hInstance, eax
INVOKE LoadIcon, eax, IDI_KEYMAKER
mov hIcon, eax

INVOKE DialogBoxParam, hInstance, IDD_KEYMAKER, NULL, ADDR DialogProc, 0
INVOKE ExitProcess, 0

; Dialog procedure
; ------------------------------------------------------------------------------
DialogProc PROC hwnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_INITDIALOG

; Initialization
; ------------------------------------------------------------------------------
    INVOKE SendMessage, hwnd, WM_SETICON, ICON_BIG, hIcon
    INVOKE SetWindowText, hwnd, ADDR szTitle
    INVOKE SendDlgItemMessage, hwnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF szName - 1, 0

    ; Retrieve the default username
    INVOKE GetUserName, ADDR szName, ADDR dwNameSize

    .IF eax
      INVOKE SetDlgItemText, hwnd, IDC_NAME, ADDR szName
    .ELSE
      INVOKE SetDlgItemText, hwnd, IDC_NAME, ADDR szDefaultName
    .ENDIF

    ; Check if the user has already registered the app
    INVOKE RegOpenKeyEx, HKEY_LOCAL_MACHINE, ADDR szRegInfo, 0, KEY_QUERY_VALUE, ADDR hkKey

    .IF eax == ERROR_SUCCESS

      ; Permut the buttons state
      INVOKE GetDlgItem, hwnd, IDC_REGISTER
      INVOKE EnableWindow, eax, FALSE
      INVOKE GetDlgItem, hwnd, IDC_RESTORE
      INVOKE EnableWindow, eax, TRUE

    .ENDIF

    INVOKE SetDlgItemText, hwnd, IDC_ABOUT, ADDR szAbout
; ------------------------------------------------------------------------------

  .ELSEIF uMsg == WM_COMMAND

    .IF wParam == IDC_REGISTER

      ; Get the user name
      INVOKE RtlZeroMemory, ADDR szName, SIZEOF szName
      INVOKE GetDlgItemText, hwnd, IDC_NAME, ADDR szName, SIZEOF szName

      .IF eax > 0

; Look for the application
; ------------------------------------------------------------------------------
        mov bOK, FALSE

; FindApp - Method 1 : try to get information from the registry
; ------------------------------------------------------------------------------
        INVOKE RegOpenKeyEx, HKEY_LOCAL_MACHINE, ADDR szAppPathKey, 0, KEY_QUERY_VALUE, ADDR hkKey

        .IF eax == ERROR_SUCCESS
          mov dwKeyfilePathSize, SIZEOF szKeyfilePath
          INVOKE RegQueryValueEx, hkKey, ADDR szAppPathValueName, NULL, ADDR dwValueType, ADDR szKeyfilePath, ADDR dwKeyfilePathSize

          .IF eax == ERROR_SUCCESS
            mov bOK, TRUE
          .ENDIF

          INVOKE RegCloseKey, hkKey
        .ENDIF
; ------------------------------------------------------------------------------

; FindApp - Method 2 : let the user to select manually the program directory
; ------------------------------------------------------------------------------
        .IF !bOK
          mov ofn.lStructSize, SIZEOF ofn
          push hwnd
          pop ofn.hwndOwner
          mov ofn.lpstrFilter, OFFSET mszFilterString
          INVOKE lstrcpy, ADDR szAppPath, ADDR szAppFilename
          mov ofn.lpstrFile  , OFFSET szAppPath
          mov ofn.nMaxFile   , SIZEOF szAppPath
          mov ofn.lpstrTitle , OFFSET szOfnTitle
          mov ofn.Flags      , OFN_FILEMUSTEXIST or OFN_HIDEREADONLY

          INVOKE GetOpenFileName, ADDR ofn

          .IF eax
            movzx eax, ofn.nFileOffset
            INVOKE lstrcpyn, ADDR szKeyfilePath, ADDR szAppPath, eax
            mov bOK, TRUE
          .ENDIF

        .ENDIF
; ------------------------------------------------------------------------------

; ------------------------------------------------------------------------------

; Create the keyfile
; ------------------------------------------------------------------------------
        .IF bOK
          INVOKE lstrcat, ADDR szKeyfilePath, ADDR szKeyfileName

          INVOKE CreateFile, ADDR szKeyfilePath, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL

          .IF eax != INVALID_HANDLE_VALUE
            mov hKeyfile,eax

            ; Load the keyfile template
            INVOKE FindResource, hInstance, IDR_KEYFILE, RT_RCDATA
            push eax
            INVOKE SizeofResource, hInstance, eax
            mov dwKeyfileSize, eax
            pop eax
            INVOKE LoadResource, hInstance, eax
            INVOKE LockResource, eax
            mov pKeyfile, eax

            ; Copy the keyfile to the app directory
            INVOKE WriteFile, hKeyfile, pKeyfile, dwKeyfileSize, ADDR dwBytesWritten, NULL

            INVOKE SetFilePointer, hKeyfile, 14h, NULL, FILE_BEGIN
            xor ebx, ebx

            ; Write the registration information
            register:
            INVOKE WriteFile, hKeyfile, ADDR szName, SIZEOF szName, ADDR dwBytesWritten, NULL
            inc ebx
            cmp ebx, 20h
            je endregister
            INVOKE SetFilePointer, hKeyfile, 2, NULL, FILE_CURRENT
            jmp register

            endregister:
            INVOKE CloseHandle, hKeyfile

            ; Display the success message
            INVOKE MessageBox, hwnd, ADDR szRegSuccess, ADDR szInfoTitle, MB_ICONINFORMATION

            ; Permut the buttons state
            INVOKE GetDlgItem, hwnd, IDC_REGISTER
            INVOKE EnableWindow, eax, FALSE
            INVOKE GetDlgItem, hwnd, IDC_RESTORE
            INVOKE EnableWindow, eax, TRUE

            ; Add an entry into the registry to remember that the file has already been created
            INVOKE RegCreateKeyEx, HKEY_LOCAL_MACHINE, ADDR szRegInfo, 0, ADDR szRegInfoType, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE, NULL, ADDR hkKey, ADDR dwDisp

            .IF eax == ERROR_SUCCESS
              INVOKE lstrlen, ADDR szKeyfilePath
              inc eax
              INVOKE RegSetValueEx, hkKey, NULL, 0, REG_SZ, ADDR szKeyfilePath, eax

              INVOKE RegCloseKey, hkKey
            .ENDIF

          .ELSE
            INVOKE MessageBox, hwnd, ADDR szError, ADDR szErrorTitle, MB_ICONERROR
          .ENDIF

        .ENDIF
; ------------------------------------------------------------------------------

      .ELSE
        INVOKE MessageBox, hwnd, ADDR szLengthError, ADDR szErrorTitle, MB_ICONERROR
      .ENDIF

    .ELSEIF wParam == IDC_RESTORE
      mov bOK, FALSE

      INVOKE RegOpenKeyEx, HKEY_LOCAL_MACHINE, ADDR szRegInfo, 0, KEY_QUERY_VALUE, ADDR hkKey

      .IF eax == ERROR_SUCCESS
        mov dwKeyfilePathSize, SIZEOF szKeyfilePath
        INVOKE RegQueryValueEx, hkKey, NULL, NULL, ADDR dwValueType, ADDR szKeyfilePath, ADDR dwKeyfilePathSize

        .IF eax == ERROR_SUCCESS
          INVOKE DeleteFile, ADDR szKeyfilePath

          .IF eax
            mov bOK, TRUE
          .ENDIF

        .ENDIF

        INVOKE RegCloseKey, hkKey
      .ENDIF

      .IF bOK
        INVOKE MessageBox, hwnd, ADDR szRestoreSuccess, ADDR szInfoTitle, MB_ICONINFORMATION

        INVOKE RegDeleteKey, HKEY_LOCAL_MACHINE, ADDR szRegInfo

        ; Permut the buttons state
        INVOKE GetDlgItem, hwnd, IDC_REGISTER
        INVOKE EnableWindow, eax, TRUE
        INVOKE GetDlgItem, hwnd, IDC_RESTORE
        INVOKE EnableWindow, eax, FALSE

      .ELSE
        INVOKE MessageBox, hwnd, ADDR szError, ADDR szErrorTitle, MB_ICONERROR
      .ENDIF

    .ELSEIF wParam == IDC_EXIT
      INVOKE SendMessage, hwnd, WM_CLOSE, 0, 0
    .ENDIF

  .ELSEIF uMsg == WM_CLOSE
    INVOKE EndDialog, hwnd, 0
  .ENDIF

  xor eax, eax
  ret
DialogProc ENDP
; ------------------------------------------------------------------------------

END start