; Keygen template
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://kickme.to/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v2.2.1 [16.01.2004]

.486
.model flat, stdcall
option casemap: none

; Lib functions
; ------------------------------------------------------------------------------
include \masm32\include\windows.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\gdi32.inc
include mfmplayer.inc                ; XM player (thanks to Lise_Grim)

includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\gdi32.lib
includelib mfmplayer.lib

; Additional libs

; ------------------------------------------------------------------------------

; Functions
; ------------------------------------------------------------------------------
DialogProc PROTO : HWND, : UINT, : WPARAM, : LPARAM
IdProc     PROTO : HWND, : UINT, : WPARAM, : LPARAM
InfoProc   PROTO : HWND, : UINT, : WPARAM, : LPARAM
DrawItem   PROTO : HWND, : LPARAM
KeygenProc PROTO : HWND
random     PROTO : DWORD
; ------------------------------------------------------------------------------

.const

; Resource ids
; ------------------------------------------------------------------------------
IDD_KEYGEN   equ 100
IDD_INFO     equ 101

IDI_KEYGEN   equ 200

IDC_TITLE    equ 400
IDC_ID       equ 401
IDC_GENERATE equ 402
IDC_COPY     equ 403
IDC_EXIT     equ 404
IDC_SERIAL   equ 406
IDC_INFO     equ 407
IDC_CLOSE    equ 408

IDM_KEYGEN   equ 500
; ------------------------------------------------------------------------------

; Colors
; ------------------------------------------------------------------------------
CR_BACKGROUND equ 00333366h
CR_FOREGROUND equ 00333399h
CR_HIGHLIGHT  equ 00CCCCFFh
CR_INPUT      equ 003300CCh
CR_INPUT2     equ 003300FFh
CR_TEXT       equ 009999FFh
; ------------------------------------------------------------------------------

.data

; Keygen parameters
; ------------------------------------------------------------------------------

; Required data
sId    TCHAR "#?", 0
sTitle TCHAR "NGEN CrackME 2oo3 keygen", 0
sInfo  TCHAR "NGEN CrackME 2oo3 keygen", 10, 13
       TCHAR "Protection: Logic, Coding tricks", 10, 13
       TCHAR 10, 13
       TCHAR "Author: Canterwood", 10, 13
       TCHAR "WWW: http://kickme.to/canterwood", 10, 13
       TCHAR 10, 13
       TCHAR "Thanks to: +Analyst, Iczelion, ShmeitCorp, Lise_Grim, +Christal", 10, 13
       TCHAR "Greetings: NGEN, FFF, RIF, e!", 10, 13
       TCHAR 10, 13
       TCHAR "Music: Remember - Unknown", 10, 13
       TCHAR "Image: Tarantula Nebula - Hubble Heritage", 0

; Keygen definided-variables
bTable CHAR "0123456789abcdefghijklmnopqrstuvwxyz"
b4Val  CHAR "4dt"
b1Val  CHAR "1aq"
b6Val  CHAR "6fv"
bAVal  CHAR "jz"
b47Res CHAR "0w1v2u3t4s5r6q7pp7q6r5s4t3u2v1w0"
b4ERes CHAR "4z6x7y8v9wv8w9x6y7z4"
b45Res CHAR "0u1t2w3v4q5p6s7rp5q4r7s6t1u0v3w2"

.data?

; Required data
sSerial CHAR 60h dup(?)

; Keygen undefinided-variables
rseed DWORD ?

c1 CHAR ?
c2 CHAR ?
c4 CHAR ?

; ------------------------------------------------------------------------------

hInstance  HINSTANCE ?

hIcon      HICON     ?
hIdCursor  HCURSOR   ?

; Brushes & pens
hBgColor   HBRUSH    ?
hFgColor   HBRUSH    ?
hInColor   HBRUSH    ?
hIn2Color  HBRUSH    ?
hEdge      HPEN      ?

; Font & text
BoldFont   LOGFONT   <?>
sBtnText   TCHAR     16 dup(?)

; Music
nMusicSize DWORD     ?
pMusic     LPVOID    ?

DefIdProc  WNDPROC   ?

.code

start:

INVOKE GetTickCount
mov rseed, eax

INVOKE GetModuleHandle, NULL
mov hInstance, eax

; Load icon & cursor
INVOKE LoadIcon, eax, IDI_KEYGEN
mov hIcon, eax
INVOKE LoadCursor, NULL, IDC_HAND
mov hIdCursor, eax

; Create brushes for custom colors
INVOKE CreateSolidBrush, CR_BACKGROUND
mov hBgColor, eax
INVOKE CreateSolidBrush, CR_FOREGROUND
mov hFgColor, eax
INVOKE CreateSolidBrush, CR_INPUT
mov hInColor, eax
INVOKE CreateSolidBrush, CR_INPUT2
mov hIn2Color, eax
INVOKE CreatePen, PS_INSIDEFRAME, 1, CR_FOREGROUND
mov hEdge, eax

; Load the music
push esi
INVOKE FindResource, hInstance, IDM_KEYGEN, RT_RCDATA
push eax
INVOKE SizeofResource, hInstance, eax
mov nMusicSize, eax
pop eax
INVOKE LoadResource, hInstance, eax
INVOKE LockResource, eax
mov esi, eax
mov eax, nMusicSize
add eax, SIZEOF nMusicSize
INVOKE GlobalAlloc, GPTR, eax
mov pMusic, eax
mov ecx, nMusicSize
mov dword ptr [eax], ecx
add eax, SIZEOF nMusicSize
mov edi, eax
rep movsb
pop esi

; Show the dialog box
INVOKE DialogBoxParam, hInstance, IDD_KEYGEN, NULL, ADDR DialogProc, 0

; Restore the memory used for the music
INVOKE GlobalFree, pMusic

; Restore the memory used for graphic objects
INVOKE DeleteObject, hEdge
INVOKE DeleteObject, hInColor
INVOKE DeleteObject, hIn2Color
INVOKE DeleteObject, hFgColor
INVOKE DeleteObject, hBgColor

; Exit the program
INVOKE ExitProcess, 0

; Dialog procedure
; ------------------------------------------------------------------------------
DialogProc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_CTLCOLORDLG
    mov eax, hBgColor
    ret
  .ELSEIF uMsg == WM_CTLCOLORSTATIC
    INVOKE GetDlgCtrlID, lParam

    .IF eax == IDC_TITLE
      INVOKE SendMessage, hWnd, WM_GETFONT, 0, 0
      INVOKE GetObject, eax, SIZEOF LOGFONT, ADDR BoldFont
      mov BoldFont.lfWeight, FW_BOLD
      mov BoldFont.lfItalic, TRUE
      INVOKE CreateFontIndirect, ADDR BoldFont
      INVOKE SelectObject, wParam, eax

      INVOKE SetBkMode, wParam, TRANSPARENT
      INVOKE SetTextColor, wParam, CR_HIGHLIGHT
      mov eax, hFgColor
      ret
    .ELSE
      INVOKE SetBkMode, wParam, TRANSPARENT

      .IF eax == IDC_SERIAL
        INVOKE SetTextColor, wParam, CR_HIGHLIGHT
      .ELSE
        INVOKE SetTextColor, wParam, CR_TEXT
      .ENDIF

      mov eax, hBgColor
      ret
    .ENDIF

  .ELSEIF uMsg == WM_CTLCOLOREDIT
    INVOKE SetBkMode, wParam, TRANSPARENT
    INVOKE SetTextColor, wParam, CR_HIGHLIGHT
    mov eax, hInColor
    ret
  .ELSEIF uMsg == WM_DRAWITEM
    INVOKE DrawItem, hWnd, lParam
  .ELSEIF uMsg == WM_LBUTTONDOWN
    INVOKE SendMessage, hWnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam
  .ELSEIF uMsg == WM_COMMAND
    mov eax,wParam
    mov edx,wParam
    shr edx,16

    .IF wParam == IDC_ID
      INVOKE DialogBoxParam, hInstance, IDD_INFO, hWnd, ADDR InfoProc, 0
    .ELSEIF wParam == IDC_GENERATE
      INVOKE KeygenProc, hWnd
    .ELSEIF wParam == IDC_COPY
      INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

      .IF eax != 0
        INVOKE OpenClipboard, hWnd

        .IF eax
          INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

          .IF eax != NULL
            push eax
            push eax

            INVOKE GlobalLock, eax
            mov edi, eax
            mov esi, OFFSET sSerial
            mov ecx, SIZEOF sSerial
            rep movsb
            pop eax
            INVOKE GlobalUnlock, eax

            INVOKE EmptyClipboard
            pop eax
            INVOKE SetClipboardData, CF_TEXT, eax
          .ENDIF

          INVOKE CloseClipboard
        .ENDIF

      .ENDIF

    .ELSEIF wParam == IDC_EXIT
      INVOKE SendMessage, hWnd, WM_CLOSE, 0, 0
    .ENDIF

  .ELSEIF uMsg == WM_INITDIALOG

    ; Subclass the id control
    INVOKE GetDlgItem, hWnd, IDC_ID
    INVOKE SetWindowLong, eax, GWL_WNDPROC, ADDR IdProc
    mov DefIdProc, eax

    INVOKE SendMessage, hWnd, WM_SETICON, ICON_BIG, hIcon

    INVOKE SetWindowText, hWnd, ADDR sTitle
    INVOKE SetDlgItemText, hWnd, IDC_TITLE, ADDR sTitle
    INVOKE SetDlgItemText, hWnd, IDC_ID, ADDR sId

    INVOKE mfmPlay, pMusic

    INVOKE KeygenProc, hWnd
  .ELSEIF uMsg == WM_CLOSE
    INVOKE mfmPlay, 0

    INVOKE EndDialog, hWnd, 0
  .ENDIF

  xor eax, eax
  ret
DialogProc ENDP
; ------------------------------------------------------------------------------

; Id procedure
; ------------------------------------------------------------------------------
IdProc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_SETCURSOR
    INVOKE SetCursor, hIdCursor
  .ELSE
    INVOKE CallWindowProc, DefIdProc, hWnd, uMsg, wParam, lParam
    ret
  .ENDIF

  xor eax, eax
  ret
IdProc ENDP
; ------------------------------------------------------------------------------

InfoProc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_CTLCOLORDLG
    mov eax, hFgColor
    ret
  .ELSEIF uMsg == WM_CTLCOLORSTATIC
    INVOKE SetBkMode, wParam, TRANSPARENT
    INVOKE SetTextColor, wParam, CR_TEXT
    mov eax, hBgColor
    ret
  .ELSEIF uMsg == WM_DRAWITEM
    INVOKE DrawItem, hWnd, lParam
  .ELSEIF uMsg == WM_INITDIALOG
    INVOKE SetDlgItemText, hWnd, IDC_INFO, ADDR sInfo
  .ELSEIF uMsg == WM_COMMAND

    .IF wParam == IDC_CLOSE
      INVOKE SendMessage, hWnd, WM_CLOSE, 0, 0
    .ENDIF

  .ELSEIF uMsg == WM_CLOSE
    INVOKE EndDialog, hWnd, 0
  .ENDIF

  xor eax, eax
  ret
InfoProc ENDP

DrawItem PROC hWnd: HWND, lParam: LPARAM
  push esi
  mov esi, lParam
  assume esi: ptr DRAWITEMSTRUCT

  .IF [esi].itemState & ODS_SELECTED
    INVOKE SelectObject, [esi].hdc, hIn2Color
  .ELSE
    INVOKE SelectObject, [esi].hdc, hInColor
  .ENDIF

  INVOKE SelectObject, [esi].hdc, hEdge

  INVOKE FillRect, [esi].hdc, ADDR [esi].rcItem, hFgColor
  INVOKE RoundRect, [esi].hdc, [esi].rcItem.left, [esi].rcItem.top, [esi].rcItem.right, [esi].rcItem.bottom, 6, 6

  .IF [esi].itemState & ODS_SELECTED
    INVOKE OffsetRect, ADDR [esi].rcItem, 1, 1
  .ENDIF

  ; Write the text
  INVOKE GetDlgItemText, hWnd, [esi].CtlID, ADDR sBtnText, SIZEOF sBtnText
  INVOKE SetBkMode, [esi].hdc, TRANSPARENT
  INVOKE SetTextColor, [esi].hdc, CR_HIGHLIGHT
  INVOKE DrawText, [esi].hdc, ADDR sBtnText, -1, ADDR [esi].rcItem, DT_CENTER or DT_VCENTER or DT_SINGLELINE

  .IF [esi].itemState & ODS_SELECTED
    INVOKE OffsetRect, ADDR [esi].rcItem, -1, -1
  .ENDIF

  ; Draw the focus rectangle
  .IF [esi].itemState & ODS_FOCUS
    INVOKE InflateRect, ADDR [esi].rcItem, -3, -3
    ;INVOKE DrawFocusRect, [esi].hdc, ADDR [esi].rcItem
  .ENDIF

  assume esi:nothing
  pop esi
  mov eax, TRUE
  ret
DrawItem ENDP

; Keygen procedure
; ------------------------------------------------------------------------------
KeygenProc PROC hWnd: HWND
  push edi
  push esi
  push ebx

  c1c2:
  INVOKE random, SIZEOF bTable
  mov al, byte ptr[OFFSET bTable+eax]
  mov c1, al
  INVOKE random, SIZEOF bTable
  mov al, byte ptr[OFFSET bTable+eax]
  mov c2, al
  mov bl, c1
  mov al, c2
  xor bl, al
  cmp bl, 0Fh
  jle c1c2ok
  jmp c1c2

  c1c2ok:
  INVOKE random, SIZEOF bTable

  compc4:
  cmp eax, SIZEOF bTable
  jl nomod
  sub eax, SIZEOF bTable

  nomod:
  mov cl, byte ptr[OFFSET bTable+eax]
  mov c4, cl
  and cl, 00001111b
  cmp cl, bl
  je c4ok
  inc eax
  jmp compc4

  c4ok:
  ; C1
  lea edi, sSerial
  mov al, c1
  mov byte ptr[edi], al

  ; C2
  mov al, c2
  mov byte ptr[edi+1], al

  ; C4
  mov al, c4
  mov byte ptr[edi+3], al

  ; C3
  INVOKE random, SIZEOF b4Val
  mov al, byte ptr[OFFSET b4Val+eax]
  mov byte ptr[edi+2], al

  mov byte ptr[edi+4], '-'

  ; C4-C8
  mov dword ptr[edi+5], '2003'

  mov byte ptr[edi+9], '-'

  ; C9, C13
  INVOKE random, SIZEOF b47Res / 2
  mov ax, word ptr[OFFSET b47Res+eax*2]
  mov byte ptr[edi+10], ah
  mov byte ptr[edi+15], al

  ; C10, C14
  INVOKE random, SIZEOF b4ERes / 2
  mov ax, word ptr[OFFSET b4ERes+eax*2]
  mov byte ptr[edi+11], ah
  mov byte ptr[edi+16], al

  ; C11
  INVOKE random, SIZEOF b1Val
  mov al, byte ptr[OFFSET b1Val+eax]
  mov byte ptr[edi+12], al

  ; C12
  mov byte ptr[edi+13], 'c'

  mov byte ptr[edi+14], '-'

  ; C15
  INVOKE random, SIZEOF b6Val
  mov al, byte ptr[OFFSET b6Val+eax]
  mov byte ptr[edi+17], al

  ; C16
  mov byte ptr[edi+18], 'a'

  mov byte ptr[edi+19], '-'

  ; C17, C21
  INVOKE random, SIZEOF b4ERes / 2
  mov ax, word ptr[OFFSET b4ERes+eax*2]
  mov byte ptr[edi+20], ah
  mov byte ptr[edi+25], al

  ; C18, C22
  INVOKE random, SIZEOF b45Res / 2
  mov ax, word ptr[OFFSET b45Res+eax*2]
  mov byte ptr[edi+21], ah
  mov byte ptr[edi+26], al

  ; C19
  INVOKE random, SIZEOF b1Val
  mov al, byte ptr[OFFSET b1Val+eax]
  mov byte ptr[edi+22], al

  ; C12
  mov byte ptr[edi+23], 'n'

  mov byte ptr[edi+24], '-'

  ; C15
  INVOKE random, SIZEOF bAVal
  mov al, byte ptr[OFFSET bAVal+eax]
  mov byte ptr[edi+27], al

  ; C16
  mov byte ptr[edi+28], 't'

  mov byte ptr[edi+29], 0

  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial

  EndGen:
  pop ebx
  pop esi
  pop edi
  ret
KeygenProc ENDP

random PROC range: DWORD
  mov eax, rseed
  mov ecx, 41c64e6dh
  mul ecx
  add eax, 3039h
  and eax, 7ffffffh
  mov rseed, eax
  mov ecx, range
  sub edx, edx
  div ecx
  xchg eax, edx
  ret
random ENDP
; ------------------------------------------------------------------------------

END start