/* Canter Keygen 5 - Core */

/* additional libraries and sources used are referenced just below */

/* configuration */

#define ID             "5"        /* keygen identifier, generally a number              */
#define TARGET         "PhytActa" /* target's (short) name                              */
#define TYPE           "keymaker" /* type of release, ie. keygen, keymaker, etc.        */

/* a quick notice, description... */
#define NOTE "Une fois vos coordonnes insres dans les deux premiers champs, cliquez sur Gnrer (autant de fois que dsir) pour obtenir des informations de license valides, puis appuyez sur Enregistrer et votre logiciel sera automatiquement dbloqu.\r\n\r\nEnjoy!"

#define AUTO_UPDATE   FALSE /* update registration information without pushing any button (recommended) */
#define MULTI_SERIALS TRUE  /* allow various serials for the same input value (depends on target)       */

/* field values (serial/name-serial/name-company-serial in most cases) */
CHAR  sInfield1 [0x100];
CHAR  sInfield2 [0x100];
CHAR  sOutfield1[0x100];
CHAR  sOutfield2[0x100];
CHAR  sOutfield3[0x100];
CHAR  sOutfield4[0x100];

/* generator's initialization: initial computations, objects creation, etc. */
BOOL Init(HWND hWnd) {
  DWORD nInfield1Size = sizeof sInfield1;

  /* initializes the PRNG */
  srand(GetTickCount());

  /* limits the size of input data */
  SendDlgItemMessage(hWnd, IDC_INFIELD1, EM_SETLIMITTEXT, sizeof sInfield1 - 1, 0);
  SendDlgItemMessage(hWnd, IDC_INFIELD2, EM_SETLIMITTEXT, sizeof sInfield2 - 1, 0);

  /* retrieves the computer user's name */
  GetUserName(sInfield1, &nInfield1Size);

  SetDlgItemText(hWnd, IDC_INFIELD1, sInfield1);

  SetStatusText(hWnd, TEXT("Initialisation du keymaker effectue..."));
  return TRUE;
}

/* generation */
BOOL Gen(HWND hWnd) {
  CHAR sSignature[] = "CANTER", sAlphabet[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  DWORD nInstallCode, nFidelityCode, nKey;
  int i;

  /* checks if a name has been entered */
  if(GetDlgItemText(hWnd, IDC_INFIELD1, sInfield1, sizeof sInfield1)) {

    /* generates a random (signed) license */

    for(i = 0; i < sizeof sSignature - 1; i++) {
      sOutfield1[2 * i] = sSignature[i];
      sOutfield1[2 * i + 1] = sAlphabet[rand() % (sizeof sAlphabet - 1)];
    }

    SetDlgItemText(hWnd, IDC_OUTFIELD1, sOutfield1);

    /* generates an installation code; ie a integer different from 0 */

    nInstallCode = rand() * 0x10000 + rand() % 0xFFFF + 1;
    wsprintf(sOutfield2, "%u", nInstallCode);

    SetDlgItemText(hWnd, IDC_OUTFIELD2, sOutfield2);

    /* generates a fidelity code */

    for(i = 0; i < 2; i++)
      sOutfield3[i] = sAlphabet[rand() % (sizeof sAlphabet - 1)];

    do {
      nFidelityCode = 99900000 + (rand() * 0x10000 + rand()) % 100000;
      nKey = nFidelityCode * 0x20B;
    } while(nKey == 0);

    wsprintf(&sOutfield3[2], "%u", nFidelityCode);

    SetDlgItemText(hWnd, IDC_OUTFIELD3, sOutfield3);

    /* generates the key */

    nKey = (nKey + nInstallCode) / 5;
    wsprintf(sOutfield4, "%08X", nKey);

    SetDlgItemText(hWnd, IDC_OUTFIELD4, sOutfield4);

    SetStatusText(hWnd, TEXT("Informations gnres avec succs !"));
    return TRUE;
  }
  else {
    SetStatusText(hWnd, TEXT("Veuillez entrez votre nom..."));
    return FALSE;
  }

}

/* copying: in the clipboard, the registry, or directly into a license file... */
BOOL Copy(HWND hWnd) {
  BOOL bCopied = FALSE;
  SYSTEMTIME SystemTime;
  HKEY hRegkey;
  DWORD nRegKey;
  TCHAR sRegKey[0x100];
  int i;

  GetSystemTime(&SystemTime);

  if(SystemTime.wYear >= 2003) {
    GetDlgItemText(hWnd, IDC_INFIELD1, sInfield1, sizeof sInfield1);
    GetDlgItemText(hWnd, IDC_INFIELD2, sInfield2, sizeof sInfield2);
    GetDlgItemText(hWnd, IDC_OUTFIELD1, sOutfield1, sizeof sOutfield1);
    GetDlgItemText(hWnd, IDC_OUTFIELD2, sOutfield2, sizeof sOutfield2);
    GetDlgItemText(hWnd, IDC_OUTFIELD3, sOutfield3, sizeof sOutfield3);
    GetDlgItemText(hWnd, IDC_OUTFIELD4, sOutfield4, sizeof sOutfield4);

    lstrcpy(sRegKey, TEXT("SOFTWARE\\code\\Phytacta "));

    if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, TEXT("SOFTWARE\\code\\System"), 0, TEXT("REG_SZ"), REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hRegkey, &nRegKey) == ERROR_SUCCESS)

      if(RegSetValueEx(hRegkey, TEXT("nom"), 0, REG_SZ, sInfield1, lstrlen(sInfield1) + 1) == ERROR_SUCCESS
         && RegSetValueEx(hRegkey, TEXT("Organisme"), 0, REG_SZ, sInfield2, lstrlen(sInfield2) + 1) == ERROR_SUCCESS
         && RegSetValueEx(hRegkey, TEXT("dc"), 0, REG_SZ, sOutfield2, lstrlen(sOutfield2) + 1) == ERROR_SUCCESS
         && RegSetValueEx(hRegkey, TEXT("code fidlit P"), 0, REG_SZ, sOutfield3, lstrlen(sOutfield3) + 1) == ERROR_SUCCESS)

        if(RegCloseKey(hRegkey) == ERROR_SUCCESS)

          for(i = 2003; i <= SystemTime.wYear + 2; i++) {
            wsprintf(&sRegKey[23], "%u", i);

            if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, sRegKey, 0, TEXT("REG_SZ"), REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &hRegkey, &nRegKey) == ERROR_SUCCESS)

              if(RegSetValueEx(hRegkey, TEXT("Licence"), 0, REG_SZ, sOutfield1, lstrlen(sOutfield1) + 1) == ERROR_SUCCESS
                 && RegSetValueEx(hRegkey, TEXT("autorisation"), 0, REG_SZ, sOutfield4, lstrlen(sOutfield4) + 1) == ERROR_SUCCESS)

                if(RegCloseKey(hRegkey) == ERROR_SUCCESS)
                  bCopied = TRUE;

          }

    if(bCopied)
      SetStatusText(hWnd, TEXT("Le logiciel est maintenant enregistr !"));
    else
      SetStatusText(hWnd, TEXT("Erreur d'criture dans le registre systme."));

    return bCopied;
  }
  else {
    SetStatusText(hWnd, TEXT("La date systme doit tre 2003 au minimum."));
    return FALSE;
  }

}

/* termination: may be used to give a message to the user, to delete objects, etc. */
BOOL Exit(HWND hWnd) {
  SetStatusText(hWnd, TEXT("Au revoir..."));
  return TRUE;
}
