; Keygen - Nero
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0

; libraries used

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation
Copy       PROTO :HWND ; copying into the clipboard or the registry, a keyfile...

; configuration
AUTO_UPDATE   = TRUE
MULTI_SERIALS = TRUE

.DATA

; parameters
; ------------------------------------------------------------------------------

; required data
sTeam        TCHAR "NGEN", 0
sSoftware    TCHAR "Nero", 0
sType        TCHAR "keygen", 0
sInformation TCHAR "Protection: Standard {checksum}", 0
sSignature   TCHAR "Canterwood", 0

; defined variables
aSerialTpl  DWORD 001h, 00Ah, 002h, 003h ; 0FFh means undefined
            DWORD 000h, 000h, 000h, 0FFh
            DWORD 0FFh, 0FFh, 003h, 000h
            DWORD 0FFh, 0FFh, 0FFh, 0FFh
            DWORD 0FFh, 0FFh, 0FFh, 0FFh
            DWORD 0FFh, 0FFh, 0FFh, 0FFh

aTable1 WORD 00000h, 01021h, 02042h, 03063h, 04084h, 050A5h, 060C6h, 070E7h
        WORD 08108h, 09129h, 0A14Ah, 0B16Bh, 0C18Ch, 0D1ADh, 0E1CEh, 0F1EFh
        WORD 01231h, 00210h, 03273h, 02252h, 052B5h, 04294h, 072F7h, 062D6h
        WORD 09339h, 08318h, 0B37Bh, 0A35Ah, 0D3BDh, 0C39Ch, 0F3FFh, 0E3DEh
        WORD 02462h, 03443h, 00420h, 01401h, 064E6h, 074C7h, 044A4h, 05485h
        WORD 0A56Ah, 0B54Bh, 08528h, 09509h, 0E5EEh, 0F5CFh, 0C5ACh, 0D58Dh
        WORD 03653h, 02672h, 01611h, 00630h, 076D7h, 066F6h, 05695h, 046B4h
        WORD 0B75Bh, 0A77Ah, 09719h, 08738h, 0F7DFh, 0E7FEh, 0D79Dh, 0C7BCh
        WORD 048C4h, 058E5h, 06886h, 078A7h, 00840h, 01861h, 02802h, 03823h
        WORD 0C9CCh, 0D9EDh, 0E98Eh, 0F9AFh, 08948h, 09969h, 0A90Ah, 0B92Bh
        WORD 05AF5h, 04AD4h, 07AB7h, 06A96h, 01A71h, 00A50h, 03A33h, 02A12h
        WORD 0DBFDh, 0CBDCh, 0FBBFh, 0EB9Eh, 09B79h, 08B58h, 0BB3Bh, 0AB1Ah
        WORD 06CA6h, 07C87h, 04CE4h, 05CC5h, 02C22h, 03C03h, 00C60h, 01C41h
        WORD 0EDAEh, 0FD8Fh, 0CDECh, 0DDCDh, 0AD2Ah, 0BD0Bh, 08D68h, 09D49h
        WORD 07E97h, 06EB6h, 05ED5h, 04EF4h, 03E13h, 02E32h, 01E51h, 00E70h
        WORD 0FF9Fh, 0EFBEh, 0DFDDh, 0CFFCh, 0BF1Bh, 0AF3Ah, 09F59h, 08F78h
        WORD 09188h, 081A9h, 0B1CAh, 0A1EBh, 0D10Ch, 0C12Dh, 0F14Eh, 0E16Fh
        WORD 01080h, 000A1h, 030C2h, 020E3h, 05004h, 04025h, 07046h, 06067h
        WORD 083B9h, 09398h, 0A3FBh, 0B3DAh, 0C33Dh, 0D31Ch, 0E37Fh, 0F35Eh
        WORD 002B1h, 01290h, 022F3h, 032D2h, 04235h, 05214h, 06277h, 07256h
        WORD 0B5EAh, 0A5CBh, 095A8h, 08589h, 0F56Eh, 0E54Fh, 0D52Ch, 0C50Dh
        WORD 034E2h, 024C3h, 014A0h, 00481h, 07466h, 06447h, 05424h, 04405h
        WORD 0A7DBh, 0B7FAh, 08799h, 097B8h, 0E75Fh, 0F77Eh, 0C71Dh, 0D73Ch
        WORD 026D3h, 036F2h, 00691h, 016B0h, 06657h, 07676h, 04615h, 05634h
        WORD 0D94Ch, 0C96Dh, 0F90Eh, 0E92Fh, 099C8h, 089E9h, 0B98Ah, 0A9ABh
        WORD 05844h, 04865h, 07806h, 06827h, 018C0h, 008E1h, 03882h, 028A3h
        WORD 0CB7Dh, 0DB5Ch, 0EB3Fh, 0FB1Eh, 08BF9h, 09BD8h, 0ABBBh, 0BB9Ah
        WORD 04A75h, 05A54h, 06A37h, 07A16h, 00AF1h, 01AD0h, 02AB3h, 03A92h
        WORD 0FD2Eh, 0ED0Fh, 0DD6Ch, 0CD4Dh, 0BDAAh, 0AD8Bh, 09DE8h, 08DC9h
        WORD 07C26h, 06C07h, 05C64h, 04C45h, 03CA2h, 02C83h, 01CE0h, 00CC1h
        WORD 0EF1Fh, 0FF3Eh, 0CF5Dh, 0DF7Ch, 0AF9Bh, 0BFBAh, 08FD9h, 09FF8h
        WORD 06E17h, 07E36h, 04E55h, 05E74h, 02E93h, 03EB2h, 00ED1h, 01EF0h
aTable2 BYTE 000h, 080h, 040h, 0C0h, 020h, 0A0h, 060h, 0E0h, 010h, 090h, 050h, 0D0h, 030h, 0B0h, 070h, 0F0h
        BYTE 008h, 088h, 048h, 0C8h, 028h, 0A8h, 068h, 0E8h, 018h, 098h, 058h, 0D8h, 038h, 0B8h, 078h, 0F8h
        BYTE 004h, 084h, 044h, 0C4h, 024h, 0A4h, 064h, 0E4h, 014h, 094h, 054h, 0D4h, 034h, 0B4h, 074h, 0F4h
        BYTE 00Ch, 08Ch, 04Ch, 0CCh, 02Ch, 0ACh, 06Ch, 0ECh, 01Ch, 09Ch, 05Ch, 0DCh, 03Ch, 0BCh, 07Ch, 0FCh
        BYTE 002h, 082h, 042h, 0C2h, 022h, 0A2h, 062h, 0E2h, 012h, 092h, 052h, 0D2h, 032h, 0B2h, 072h, 0F2h
        BYTE 00Ah, 08Ah, 04Ah, 0CAh, 02Ah, 0AAh, 06Ah, 0EAh, 01Ah, 09Ah, 05Ah, 0DAh, 03Ah, 0BAh, 07Ah, 0FAh
        BYTE 006h, 086h, 046h, 0C6h, 026h, 0A6h, 066h, 0E6h, 016h, 096h, 056h, 0D6h, 036h, 0B6h, 076h, 0F6h
        BYTE 00Eh, 08Eh, 04Eh, 0CEh, 02Eh, 0AEh, 06Eh, 0EEh, 01Eh, 09Eh, 05Eh, 0DEh, 03Eh, 0BEh, 07Eh, 0FEh
        BYTE 001h, 081h, 041h, 0C1h, 021h, 0A1h, 061h, 0E1h, 011h, 091h, 051h, 0D1h, 031h, 0B1h, 071h, 0F1h
        BYTE 009h, 089h, 049h, 0C9h, 029h, 0A9h, 069h, 0E9h, 019h, 099h, 059h, 0D9h, 039h, 0B9h, 079h, 0F9h
        BYTE 005h, 085h, 045h, 0C5h, 025h, 0A5h, 065h, 0E5h, 015h, 095h, 055h, 0D5h, 035h, 0B5h, 075h, 0F5h
        BYTE 00Dh, 08Dh, 04Dh, 0CDh, 02Dh, 0ADh, 06Dh, 0EDh, 01Dh, 09Dh, 05Dh, 0DDh, 03Dh, 0BDh, 07Dh, 0FDh
        BYTE 003h, 083h, 043h, 0C3h, 023h, 0A3h, 063h, 0E3h, 013h, 093h, 053h, 0D3h, 033h, 0B3h, 073h, 0F3h
        BYTE 00Bh, 08Bh, 04Bh, 0CBh, 02Bh, 0ABh, 06Bh, 0EBh, 01Bh, 09Bh, 05Bh, 0DBh, 03Bh, 0BBh, 07Bh, 0FBh
        BYTE 007h, 087h, 047h, 0C7h, 027h, 0A7h, 067h, 0E7h, 017h, 097h, 057h, 0D7h, 037h, 0B7h, 077h, 0F7h
        BYTE 00Fh, 08Fh, 04Fh, 0CFh, 02Fh, 0AFh, 06Fh, 0EFh, 01Fh, 09Fh, 05Fh, 0DFh, 03Fh, 0BFh, 07Fh, 0FFh

sRandFormat TCHAR "%04u", 0
sSumFormat  TCHAR "%05d", 0

aPrintTable CHAR  "01234567B9ACFRNX"

.DATA?

; required data

pTargetVersion LPCTSTR         ?
sTitle         CHAR    40h dup(?)

sName   CHAR 20h dup(?)
sSerial CHAR 60h dup(?)

; undefined variables

aSerial  DWORD 20h dup(?)

sRand    CHAR  10h dup(?)
n1620    DWORD         ?

sHexStr1 CHAR  20h dup(?)
sHexStr2 CHAR  20h dup(?)
nSum1    DWORD         ?
nSum2    DWORD         ?
sSum     CHAR  10h dup(?)

; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC hWnd: HWND

  ; make the release title
  INVOKE FindResource, hInstance, SADD("TARGETVERSION"), RT_RCDATA
  INVOKE LoadResource, hInstance, eax
  INVOKE LockResource, eax
  mov pTargetVersion, eax
  INVOKE wsprintf, ADDR sTitle, SADD("%s - %s %s %s"), ADDR sTeam, ADDR sSoftware, pTargetVersion, ADDR sType

  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_INFORMATION, ADDR sInformation
  INVOKE SetDlgItemText, hWnd, IDC_SIGNATURE, ADDR sSignature

  INVOKE SetDlgItemText, hWnd, IDC_NAME, SADD("<not required>")
  INVOKE EnableDlgItem, hWnd, IDC_NAME, FALSE

  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------
Random PROC nRange: DWORD
  INVOKE GetTickCount
  mov ecx, 41C64E6Dh
  mul ecx
  add eax, 3039h
  and eax, 7FFFFFFh
  mov ecx, nRange
  sub edx, edx
  div ecx
  xchg eax, edx
  ret
Random ENDP

; ripped from IDA
RawToHex PROC NEAR
arg_0 = dword ptr  4
arg_4 = byte ptr  8

  cmp     [esp+arg_4], 0
  push    esi
  mov     esi, [esp+4+arg_0]
  push    edi
  setnz   dl
  xor     eax, eax
  ;lea     edi, [ecx+4]
  mov edi, ecx

  loc_63E335:
  mov     ecx, [edi]
  cmp     ecx, 9
  jge     short loc_63E346
  add     cl, dl
  add     cl, 30h

  loc_63E341:
  mov     [eax+esi], cl
  jmp     short loc_63E3AD

  loc_63E346:
  jnz     short loc_63E35B
  cmp     [esp+8+arg_4], 0
  jz      short loc_63E355
  mov     byte ptr [eax+esi], 41h
  jmp     short loc_63E3AD

  loc_63E355:
  mov     byte ptr [eax+esi], 39h
  jmp     short loc_63E3AD

  loc_63E35B:
  cmp     ecx, 0Ah
  jnz     short loc_63E367
  mov     cl, dl
  add     cl, 41h
  jmp     short loc_63E341

  loc_63E367:
  cmp     ecx, 0Bh
  jnz     short loc_63E373
  mov     cl, dl
  add     cl, 42h
  jmp     short loc_63E341

  loc_63E373:
  cmp     ecx, 0Ch
  jnz     short loc_63E37F
  mov     cl, dl
  add     cl, 43h
  jmp     short loc_63E341

  loc_63E37F:
  cmp     ecx, 0Dh
  jnz     short loc_63E38B
  mov     cl, dl
  add     cl, 44h
  jmp     short loc_63E341

  loc_63E38B:
  cmp     ecx, 0Eh
  jnz     short loc_63E397
  mov     cl, dl
  add     cl, 45h
  jmp     short loc_63E341

  loc_63E397:
  cmp     ecx, 0Fh
  jnz     short loc_63E3C1
  cmp     [esp+8+arg_4], 0
  jz      short loc_63E3A9
  mov     byte ptr [eax+esi], 30h
  jmp     short loc_63E3AD

  loc_63E3A9:
  mov     byte ptr [eax+esi], 46h

  loc_63E3AD:
  inc     eax
  add     edi, 4
  cmp     eax, 13h
  jle     loc_63E335
  mov     al, 1

  loc_63E3BC:
  pop     edi
  pop     esi
  retn    8

  loc_63E3C1:
  xor     al, al
  jmp     short loc_63E3BC
RawToHex ENDP

Generate PROC USES ebx esi edi hWnd: HWND
  lea esi, aSerialTpl
  lea edi, aSerial
  mov ecx, 24
  rep movsd
  sub edi, 24*SIZEOF DWORD

  ; num 8

  INVOKE Random, 4

  .IF eax == 0
    mov eax, 4
  .ELSEIF eax == 1
    mov eax, 6
  .ELSEIF eax == 2
    mov eax, 7
  .ELSE
    mov eax, 9
  .ENDIF

  mov [edi+7*SIZEOF DWORD], eax

  ; num 9

  INVOKE Random, 10h
  mov [edi+8*SIZEOF DWORD], eax

  ; num 10

  INVOKE Random, 2
  mov [edi+9*SIZEOF DWORD], eax

  ; nums 13-20 (random value)

  INVOKE Random, 1200
  add eax, 1300
  lea esi, sRand
  INVOKE wsprintf, esi, ADDR sRandFormat, eax
  add esi, 4
  INVOKE Random, 10000
  mov n1620, eax
  INVOKE wsprintf, esi, ADDR sRandFormat, eax
  sub esi, 4
  xor ecx, ecx
  add edi, 12*SIZEOF DWORD

  nums1320:
  movzx eax, byte ptr[esi+ecx]
  test eax, eax
  je endNums1320
  sub eax, 30h
  mov dword ptr[edi+ecx*SIZEOF DWORD], eax
  inc ecx
  jmp nums1320

  endNums1320:
  sub edi, 12*SIZEOF DWORD

  ; nums 21-24 (checksum)

  mov ecx, edi
  push 0
  push OFFSET sHexStr1
  call RawToHex

  mov ecx, edi
  push 1
  push OFFSET sHexStr2
  call RawToHex

  lea esi, sHexStr2
  movzx ecx, byte ptr[esi+2]
  movzx edx, byte ptr[esi+3]
  imul ecx, edx
  xor esi, esi
  lea edi, sHexStr2

  checksum1:
  movzx eax, si
  mov al, [eax+edi]
  xor edx, edx
  mov dl, ch
  movzx edx, dl
  movzx eax, al
  xor edx, eax
  xor eax, eax
  mov ah, cl
  mov dx, aTable1[edx*2]
  xor dx, ax
  inc esi
  movzx eax, si
  cmp eax, 20
  mov ecx, edx
  jb checksum1

  mov nSum1, ecx

  mov ecx, n1620
  xor eax, eax
  xor edx, edx
  mov al, ch
  movzx eax, al
  mov dl, aTable2[eax]
  movzx eax, cl
  mov dh, aTable2[eax]
  mov ecx, edx
  xor esi, esi
  lea edi, sHexStr1

  checksum2:
  movzx eax, si
  movzx eax, byte ptr [eax+edi]
  mov al, aTable2[eax]
  xor edx, edx
  mov dl, ch
  movzx edx, dl
  movzx eax, al
  xor edx, eax
  xor eax, eax
  mov ah, cl
  mov dx, aTable1[edx*2]
  xor dx, ax
  inc esi
  movzx eax, si
  cmp eax, 20
  mov ecx, edx
  jb checksum2

  xor eax, eax
  xor edx, edx
  mov al, ch
  movzx eax, al
  mov dl, aTable2[eax]
  movzx eax, cl
  mov dh, aTable2[eax]
  mov nSum2, edx

  lea esi, sSum
  lea edi, aSerial

  INVOKE wsprintf, esi, ADDR sSumFormat, nSum1
  movzx eax, byte ptr[esi+3]
  sub eax, 30h
  mov [edi+20*SIZEOF DWORD], eax

  INVOKE wsprintf, esi, ADDR sSumFormat, nSum2
  movzx eax, byte ptr[esi+3]
  sub eax, 30h
  mov [edi+21*SIZEOF DWORD], eax
  movzx eax, byte ptr[esi+2]
  sub eax, 30h
  mov [edi+22*SIZEOF DWORD], eax
  movzx eax, byte ptr[esi+1]
  sub eax, 30h
  mov [edi+23*SIZEOF DWORD], eax

  ; print the serial
  lea esi, aSerial
  lea edi, sSerial
  xor ecx, ecx
  xor ebx, ebx

  printSerial:
  mov eax, dword ptr[esi+ecx*SIZEOF DWORD]
  movzx eax, byte ptr aPrintTable[eax]
  mov byte ptr[edi+ebx], al
  push ecx
  mov eax, ecx
  mov ecx, 4
  cdq
  div ecx
  cmp edx, 3
  jnz noDelimiter
  inc ebx
  mov byte ptr[edi+ebx], '-'

  noDelimiter:
  pop ecx
  inc ecx
  inc ebx
  cmp ecx, 24
  jb printSerial

  endPrintSerial:
  dec ebx
  mov byte ptr[edi+ebx], 0
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  mov eax, TRUE
  ret
Generate ENDP
; ------------------------------------------------------------------------------

; Copying
; ------------------------------------------------------------------------------
Copy PROC USES ebx esi edi hWnd:HWND
  mov ebx, FALSE ; success flag

  INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

  .IF eax
    INVOKE OpenClipboard, hWnd

    .IF eax
      INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

      .IF eax != NULL
        push eax
        push eax

        ; Copy the serial into the clipboard
        INVOKE GlobalLock, eax
        mov edi, eax
        mov esi, OFFSET sSerial
        mov ecx, SIZEOF sSerial
        rep movsb
        pop eax
        INVOKE GlobalUnlock, eax

        INVOKE EmptyClipboard
        pop eax
        INVOKE SetClipboardData, CF_TEXT, eax
        mov ebx, TRUE
      .ENDIF

      INVOKE CloseClipboard
    .ENDIF

  .ENDIF

  .IF ebx
    INVOKE MessageBox, hWnd, SADD("The serial has been copied into the clipboard."), SADD("Information"), MB_ICONINFORMATION OR MB_OK
  .ELSE
    INVOKE MessageBox, hWnd, SADD("An error occured, please copy the serial by hand."), SADD("Error"), MB_ICONERROR OR MB_OK
  .ENDIF

  mov eax, TRUE
  ret
Copy ENDP
; ------------------------------------------------------------------------------