/* Canter Keygen 5 - Interface */

#define  WIN32_LEAN_AND_MEAN
#include <windows.h>

#include "identifiers.h"

/* colors used in Edit fields */
#define CR_FIELD    RGB(240, 230, 200) /* field (background) */
#define CR_INFIELD  RGB(0  , 0  , 0  ) /* infield            */
#define CR_OUTFIELD RGB(215, 65 , 75 ) /* outfield           */

/* functions defined in core.c */
BOOL Init(HWND);
BOOL Gen (HWND);
BOOL Copy(HWND);
BOOL Exit(HWND);

/* functions defined here */
BOOL CALLBACK DlgProc      (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK InfoDlgProc  (HWND, UINT, WPARAM, LPARAM);
BOOL          EnableDlgItem(HWND, DWORD, BOOL)         ;

/* information, code, etc. about the current release */
#include "core.c"

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow) {
  return DialogBox(hInstance, MAKEINTRESOURCE(IDD_KEYGEN), NULL, DlgProc);
}

BOOL CALLBACK DlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
  static HINSTANCE hInstance;
  HICON hIcon;
  static HBRUSH hFieldColor;
  LOGFONT BoldFont;
  static HFONT hBoldFont;
  int nFieldId;

  /* text displayed if auto-update is disabled */
  #if !AUTO_UPDATE
    TCHAR sGen[] = TEXT("Hit generate, please...");
  #endif

  switch (uMsg) {

    case WM_COMMAND:

      switch(LOWORD(wParam)) {

        /* shows the information dialog */
        case IDC_INFO:
          DialogBox(hInstance, MAKEINTRESOURCE(IDD_INFO), hWnd, InfoDlgProc);
          break;

        /* generates registration information and switch the status of buttons if necessary */
        case IDC_GEN:

          #if !AUTO_UPDATE && !MULTI_SERIALS
            EnableDlgItem(hWnd, IDC_GEN, FALSE);
          #endif

          if(Gen(hWnd))
            EnableDlgItem(hWnd, IDC_COPY, TRUE);
          else
            EnableDlgItem(hWnd, IDC_COPY, FALSE);

          break;

        /* copy the current registration information */
        case IDC_COPY:

          if(Copy(hWnd))
            EnableDlgItem(hWnd, IDC_COPY, FALSE);

          break;

        /* ask the program to quit */
        case IDC_EXIT:
          SendMessage(hWnd, WM_CLOSE, 0, 0);
          break;

        /* auto-update */
        default:

          if(LOWORD(wParam) >= INFIELD_BEGIN && LOWORD(wParam) <= INFIELD_END && HIWORD(wParam) == EN_UPDATE) {

            #if AUTO_UPDATE

              if(Gen(hWnd))
                EnableDlgItem(hWnd, IDC_COPY, TRUE);
              else
                EnableDlgItem(hWnd, IDC_COPY, FALSE);

            #else
              EnableDlgItem(hWnd, IDC_GEN, TRUE);
              EnableDlgItem(hWnd, IDC_COPY, FALSE);
              SetDlgItemText(hWnd, IDC_OUTFIELD1, sGen);
            #endif

          }
          else
            return FALSE;

      }

      break;

    case WM_INITDIALOG:
     hInstance = GetModuleHandle(NULL);
     hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_KEYGEN));

      /* gives the dialog an icon */
      SendMessage(hWnd, WM_SETICON, ICON_BIG, (LPARAM) hIcon);
      SendMessage(hWnd, WM_SETICON, ICON_SMALL,(LPARAM) hIcon);

      /* set the font used in fields */

      hFieldColor = CreateSolidBrush(CR_FIELD);
      GetObject((HFONT) SendMessage(hWnd, WM_GETFONT, 0, 0), sizeof(LOGFONT), &BoldFont);
      BoldFont.lfWeight = FW_BOLD;
      hBoldFont = CreateFontIndirect(&BoldFont);

      for(nFieldId = OUTFIELD_BEGIN; nFieldId <= OUTFIELD_END; nFieldId++)

        if(GetDlgItem(hWnd, nFieldId) != NULL)
          SendDlgItemMessage(hWnd, nFieldId, WM_SETFONT, (WPARAM) hBoldFont, TRUE);
        else
          break;

      for(nFieldId = INFIELD_BEGIN; nFieldId <= INFIELD_END; nFieldId++)

        if(GetDlgItem(hWnd, nFieldId) != NULL)
          SendDlgItemMessage(hWnd, nFieldId, WM_SETFONT, (WPARAM) hBoldFont, TRUE);
        else
          break;

      /* set the keygen title */
      SetWindowText(hWnd, TEXT(TARGET " " TYPE));

      /* initializes the generator */
      if(!Init(hWnd)) {
        SendMessage(hWnd, WM_CLOSE, 0, 0);
        break;
      }

      /* generates the initial registration information if the auto-update option is activated */
      #if AUTO_UPDATE

        #if !MULTI_SERIALS
          EnableDlgItem(hWnd, IDC_GEN, FALSE);
        #endif

        if(!Gen(hWnd))
          EnableDlgItem(hWnd, IDC_COPY, FALSE);

      #else
        EnableDlgItem(hWnd, IDC_COPY, FALSE);
        SetDlgItemText(hWnd, IDC_SERIAL, sGen);
      #endif

      break;

    case WM_CLOSE:

      /* terminates the generator */
      Exit(hWnd);

      /* releases memory */
      DeleteObject(hBoldFont);
      DeleteObject(hFieldColor);

      EndDialog(hWnd, TRUE);
      break;

    /* change the font and colors of read-only Edit controls, considered as Static controls (outfields) */
    case WM_CTLCOLORSTATIC:
      nFieldId = GetDlgCtrlID((HWND) lParam);

      if(nFieldId >= OUTFIELD_BEGIN && nFieldId <= OUTFIELD_END) {
        SetBkColor((HDC) wParam, CR_FIELD);
        SetTextColor((HDC) wParam, CR_OUTFIELD);
        return (LRESULT) hFieldColor;
      }
      else
        return FALSE;

    /* change the color of input fields */
    case WM_CTLCOLOREDIT:
      SetBkColor((HDC) wParam, CR_FIELD);
      SetTextColor((HDC) wParam, CR_INFIELD);
      return (LRESULT) hFieldColor;

    default:
      return FALSE;

  }

  return TRUE;
}

/* information dialog box's procedure */
BOOL CALLBACK InfoDlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {

  switch(uMsg) {

    case WM_COMMAND:

      switch(LOWORD(wParam)) {

        case IDOK:
          EndDialog(hWnd, 0);

        default:
          return FALSE;

      }

      break;

    case WM_INITDIALOG:

      #ifdef TARGET_VERSION
        SetDlgItemText(hWnd, IDC_TITLE, TEXT("S2 #" ID " - " TARGET " " TARGET_VERSION));
      #else
        SetDlgItemText(hWnd, IDC_TITLE, TEXT("S2 #" ID " - " TARGET));
      #endif

      SetDlgItemText(hWnd, IDC_NOTE, TEXT(NOTE));
      SetDlgItemText(hWnd, IDC_DATE, TEXT("C code compiled on " __DATE__ " @ " __TIME__));
      break;

    default:
      return FALSE;

  }

  return TRUE;
}

/* the equivalent of EnableWindow, for controls */
BOOL EnableDlgItem(HWND hWnd, DWORD nDlgItem, BOOL bEnable) {
  return EnableWindow(GetDlgItem(hWnd, nDlgItem), bEnable);
}
