/* Canter Keygen 5 - Core */

/* additional libraries and sources used are referenced below */
#include "DES.h"

/* configuration */

#define ID             "2"                                /* keygen identifier, generally a number                                    */
#define TARGET         "Multiquence"                      /* target's (short) name                                                    */
#define TARGET_VERSION "2.53"                             /* target version, optional (the line may be deleted)                       */
#define TYPE           "keymaker"                         /* type of release, ie. keygen, keymaker etc.                               */
#define NOTE           "Once you've generated your reginfo, press Copy to write it in Multique.ini.\r\n\r\nHave fun recording videos!\r\n\r\nCanter" /* a quick notice/description/...                                           */

#define AUTO_UPDATE    TRUE                               /* update registration information without pushing any button (recommended) */
#define MULTI_SERIALS  TRUE                               /* allow various serials for the same input value (target-related)          */

/* field values (serial/name-serial/name-company-serial in most cases) */
CHAR sOutfield1[14];
CHAR sOutfield2[10];
CHAR sOutfield3[10];

/* generator's initialization: initial computations, object creation, etc. */
BOOL Init(HWND hWnd) {
  sOutfield1[sizeof sOutfield1 - 1] = '\0';
  sOutfield2[sizeof sOutfield2 - 1] = '\0';
  sOutfield3[sizeof sOutfield3 - 1] = '\0';

  return TRUE;
}

/* generation */
BOOL Gen(HWND hWnd) {
CHAR sAlphabet [] = "ABCDEFGHJKLMNPQRSTUVWXYZ23456789";
CHAR sAlphabet2[] = "UERTFJK8LMYNC9AQHSVBX2D3G4Z56W7P";
CHAR pXorTable [] = {0x07, 0x0B, 0x19, 0x1E, 0x1B, 0x0E, 0x05, 0x1F, 0x09};
CHAR sMagic    [] = "\0\0\0";
BYTE pBinOutfield3[70];
LPVOID pArg1 = &sOutfield2, pArg2 = &sMagic, pArg3 = &pBinOutfield3;
int nOutfield3Char;
int i, j;

  srand(GetTickCount());

  /* LO: a totally random string of length 13 (due to a bug in generation algorithm?) */

  for(i = 0; i < 13; i++)
    sOutfield1[i] = sAlphabet[rand() % (sizeof sAlphabet - 1)];

  SetDlgItemText(hWnd, IDC_OUTFIELD1, sOutfield1);

  /* L1: it corresponds to the User ID; it's a (nearly) random string of length 9 */

  for(i = 0; i < 9; i++)

    if(i == 6)
      sOutfield2[6] = sAlphabet[16 + rand() % 8];
    else
      sOutfield2[i] = sAlphabet[rand() % (sizeof sAlphabet - 1)];

  SetDlgItemText(hWnd, IDC_OUTFIELD2, sOutfield2);

  /* L2: the things get more complicated: it deals with DES encryption */

  sMagic[0] = sOutfield2[sizeof sOutfield2 - 2];
  sMagic[1] = sOutfield2[0];

  /* a call to our ASM rip, it works only with MSVC */
  _asm {
    push pArg3
    push pArg2
    push pArg1
  }
  DES();

  for(i = 0; i < sizeof sOutfield3 - 1; i++) {
    nOutfield3Char = 0;

    for(j = 0; j < 5; j++) {
      nOutfield3Char <<= 1;
      nOutfield3Char |= pBinOutfield3[i * 5 + j];
    }

    sOutfield3[i] = sAlphabet2[nOutfield3Char];
  }

  for(i = 0; i < sizeof sOutfield3 - 1; i++)
    sOutfield3[i] = sAlphabet[pXorTable[i] ^ (strchr(sAlphabet, sOutfield2[i]) - sAlphabet) ^ (strchr(sAlphabet, sOutfield3[i]) - sAlphabet)];

  SetDlgItemText(hWnd, IDC_OUTFIELD3, sOutfield3);

  return TRUE;
}

/* copy: in the clipboard, the registry, or directly into a license file... */
BOOL Copy(HWND hWnd) {
TCHAR sKeyfile[] = TEXT("Multique.ini"), sSection[] = TEXT("Registry");
TCHAR sEmpty[] = TEXT("");
BOOL bCopied;

  bCopied =  WritePrivateProfileString(sSection, TEXT("L0"), sOutfield1, sKeyfile)
          && WritePrivateProfileString(sSection, TEXT("L1"), sOutfield2, sKeyfile)
          && WritePrivateProfileString(sSection, TEXT("L2"), sOutfield3, sKeyfile);

  if(bCopied) {
    SetDlgItemText(hWnd, IDC_OUTFIELD1, sEmpty);
    SetDlgItemText(hWnd, IDC_OUTFIELD2, TEXT("Reginfo copied successfully!"));
    SetDlgItemText(hWnd, IDC_OUTFIELD3, sEmpty);
  }
  else {
    SetDlgItemText(hWnd, IDC_OUTFIELD1, TEXT("An error occured."));
    SetDlgItemText(hWnd, IDC_OUTFIELD2, sEmpty);
    SetDlgItemText(hWnd, IDC_OUTFIELD3, TEXT("Edit by hand multique.ini, please."));
  }

  return bCopied;
}

/* termination: may be used to give a message to the user, to delete objects, etc. */
BOOL Exit(HWND hWnd) {
  return TRUE;
}
