; Keygen - Montagne 3D 3.1.5
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0

; libraries used
INCLUDE    \masm32\INCLUDE\advapi32.inc
INCLUDELIB \masm32\LIB\advapi32.lib

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation
Copy       PROTO :HWND ; copying into the clipboard or the registry, a keyfile...

; configuration
AUTO_UPDATE   = TRUE
MULTI_SERIALS = FALSE

.DATA

; parameters
; ------------------------------------------------------------------------------

; required data
% sTitle TCHAR "NGEN - Montagne 3D &TARGETVERSION keygen", 0 ; target version defined in the batch file for quick update
  sAbout TCHAR "Team NGEN 2004 - gfx: dax`", 0
            
  sNameError   TCHAR "You should enter a name.", 0
  sCopySuccess TCHAR "The serial has been copied into the clipboard.", 0
  sCopyError   TCHAR "An error occured, please copy the serial by hand.", 0

; defined variables
dbl_54A034  dq 2.3283064365386961920E-10
flt_5238C0  dd 1.0e6

sFormat     TCHAR "%d", 0

sPrefix     CHAR "M3D001", 0
sProductKey CHAR "112915", 0
sSuffix     CHAR "F", 0

.DATA?

; required data
sName   CHAR 20h dup(?)
sSerial CHAR 60h dup(?)

; undefined variables
dword_54F044 dd ?

sUserId      CHAR 10h dup(?)

; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC hWnd: HWND
  LOCAL nNameSize:DWORD

  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_ABOUT, ADDR sAbout

  ; Set the limit for the name text field
  INVOKE SendDlgItemMessage, hWnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF sName - 1, 0

  mov nNameSize, SIZEOF sName

  ; Retrieve the default username
  INVOKE GetUserName, ADDR sName, ADDR nNameSize

  .IF eax
    INVOKE SetDlgItemText, hWnd, IDC_NAME, ADDR sName
  .ENDIF

  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------
Generate PROC USES ebx esi edi hWnd: HWND
  INVOKE GetDlgItemText, hWnd, IDC_NAME, ADDR sName, SIZEOF sName
  cmp eax, 0
  je ValidityError

  push eax

  INVOKE CharUpper, ADDR sName

  pop eax
  mov ecx, 1
  xor edi, edi

  sum:
  movzx edx, byte ptr[OFFSET sName+ecx-1]
  imul edx, ecx
  add edi, edx
  inc ecx
  dec eax
  jnz sum

  imul eax, edi, 10
  add eax, 112915
  mov dword_54F044, eax
  call sub_402D34
  fmul flt_5238C0
  call sub_402B48
  INVOKE wsprintf, ADDR sUserId, ADDR sFormat, eax

  INVOKE lstrcpy, ADDR sSerial, ADDR sPrefix
  INVOKE lstrcat, ADDR sSerial, ADDR sProductKey
  INVOKE lstrcat, ADDR sSerial, ADDR sUserId
  INVOKE lstrcat, ADDR sSerial, ADDR sSuffix

  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  jmp EndGenerate

  ValidityError:
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sNameError

  EndGenerate:
  ret
Generate ENDP

sub_402D34      proc near               ; CODE XREF: sub_4A77D0+26EF p
                                        ; sub_4A77D0+270D p ...

var_8           = qword ptr -8

                imul    edx, ds:dword_54F044, 8088405h
                inc     edx
                mov     ds:dword_54F044, edx
                fld     ds:dbl_54A034
                push    0
                push    edx
                fild    [esp+8+var_8]
                add     esp, 8
                fmulp   st(1), st
                retn
sub_402D34      endp

sub_402B48      proc near               ; CODE XREF: sub_4358D8+5E p
                                        ; sub_4358D8+69 p ...

var_8           = qword ptr -8

                sub     esp, 8
                fistp   [esp+8+var_8]
                wait
                pop     eax
                pop     edx
                retn
sub_402B48      endp
; ------------------------------------------------------------------------------

; Copying
; ------------------------------------------------------------------------------
Copy PROC USES ebx hWnd:HWND
  mov ebx, FALSE ; success flag

  INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

  .IF eax
    INVOKE OpenClipboard, hWnd

    .IF eax
      INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

      .IF eax != NULL
        push eax
        push eax

        ; Copy the serial into the clipboard
        INVOKE GlobalLock, eax
        mov edi, eax
        mov esi, OFFSET sSerial
        mov ecx, SIZEOF sSerial
        rep movsb
        pop eax
        INVOKE GlobalUnlock, eax

        INVOKE EmptyClipboard
        pop eax
        INVOKE SetClipboardData, CF_TEXT, eax
        mov ebx, TRUE
      .ENDIF

      INVOKE CloseClipboard
    .ENDIF

  .ENDIF

  .IF ebx
    INVOKE MessageBox, hWnd, ADDR sCopySuccess, SADD("Information"), MB_ICONINFORMATION OR MB_OK
  .ELSE
    INVOKE MessageBox, hWnd, ADDR sCopyError, SADD("Error"), MB_ICONERROR OR MB_OK
  .ENDIF

  ret
Copy ENDP
; ------------------------------------------------------------------------------