; Keygen - Mimas Primier
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0

; libraries used

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation
Copy       PROTO :HWND ; copying into the clipboard or the registry, a keyfile...

; configuration
AUTO_UPDATE = TRUE

.DATA

; parameters
; ------------------------------------------------------------------------------

; required data
% sTitle TCHAR "NGEN - Mimas Primier keygen", 0 ; target version defined in the batch file for quick update
  sAbout TCHAR "by Canterwood // NGEN Team 2004 - gfx: dax`", 0
            
  sNameError   TCHAR "Your name is invalid.", 0
  sCopySuccess TCHAR "The serial has been copied into the clipboard.", 0
  sCopyError   TCHAR "An error occured, please copy the serial by hand.", 0

; defined variables

.DATA?

; required data
sName   CHAR 21  dup(?)
sSerial CHAR 60h dup(?)

; undefined variables
nNumber DWORD ?

; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC hWnd: HWND
  LOCAL nNameSize:DWORD

  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_ABOUT, ADDR sAbout

  ; Set the limit for the name text field
  INVOKE SendDlgItemMessage, hWnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF sName - 1, 0

  mov nNameSize, SIZEOF sName

  ; Retrieve the default username
  INVOKE GetUserName, ADDR sName, ADDR nNameSize

  .IF eax
    INVOKE SetDlgItemText, hWnd, IDC_NAME, ADDR sName
  .ENDIF

  INVOKE Generate, hWnd
  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------
Generate PROC USES ebx esi edi hWnd: HWND
  INVOKE GetDlgItemText, hWnd, IDC_NAME, ADDR sName, SIZEOF sName

  lea esi, sName
  xor ecx, ecx
  xor edx, edx

  quickSum:
  movzx eax, byte ptr[esi+ecx]
  cmp eax, 0
  je endQuickSum
  imul eax, 10
  add edx, eax
  inc ecx
  jmp quickSum

  endQuickSum:
  cmp edx, 500
  jl ValidityError

  mov edi, edx
  xor ebx, ebx

  getprime:
  mov eax, edi
  add eax, ebx

  push eax
  push ebx
  push esi

  mov esi, eax                 ; esi = number to check
  mov ebx, 2                   ; counter = 2 (init)
  jmp sqrt

  checkprime:
  mov eax, esi
  cdq
  idiv ebx                     ; divide by all numbers between 2 and nNumber^(1/2)
  test edx, edx
  jnz divok                    ; if the reminder does not equal to 0, ok
  xor eax, eax
  jmp notprime                 ; else bad boy

  divok:
  inc ebx

  sqrt:
  mov dword ptr [nNumber], esi
  fild qword ptr nNumber       ; load the number into ST
  fsqrt                        ; compute the square root
  
  fistp qword ptr nNumber
  cmp ebx, dword ptr [nNumber] ; test if counter == result
  jle checkprime               ; if lower, loop
  mov eax, 1                   ; ok, it's a prime

  notprime:

  pop esi
  pop ebx

  test eax, eax
  jnz primefound
  pop eax

  inc ebx
  cmp ebx, esi
  jbe noreset
  mov ebx, 1

  noreset:
  jmp getprime

  primefound:
  pop eax
  INVOKE wsprintf, ADDR sSerial, SADD("MPZ-%u"), eax
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  jmp EndGenerate

  ValidityError:
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sNameError

  EndGenerate:
  ret
Generate ENDP
; ------------------------------------------------------------------------------

; Copying
; ------------------------------------------------------------------------------
Copy PROC USES ebx hWnd:HWND
  mov ebx, FALSE ; success flag

  INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

  .IF eax
    INVOKE OpenClipboard, hWnd

    .IF eax
      INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

      .IF eax != NULL
        push eax
        push eax

        ; Copy the serial into the clipboard
        INVOKE GlobalLock, eax
        mov edi, eax
        mov esi, OFFSET sSerial
        mov ecx, SIZEOF sSerial
        rep movsb
        pop eax
        INVOKE GlobalUnlock, eax

        INVOKE EmptyClipboard
        pop eax
        INVOKE SetClipboardData, CF_TEXT, eax
        mov ebx, TRUE
      .ENDIF

      INVOKE CloseClipboard
    .ENDIF

  .ENDIF

  .IF ebx
    INVOKE MessageBox, hWnd, ADDR sCopySuccess, SADD("Information"), MB_ICONINFORMATION OR MB_OK
  .ELSE
    INVOKE MessageBox, hWnd, ADDR sCopyError, SADD("Error"), MB_ICONERROR OR MB_OK
  .ENDIF

  ret
Copy ENDP
; ------------------------------------------------------------------------------