; Keygen - MathType
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0

; libraries used

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation
Copy       PROTO :HWND ; copying into the clipboard or the registry, a keyfile...

; configuration
AUTO_UPDATE   = TRUE
MULTI_SERIALS = TRUE

.DATA

; Parameters
; ------------------------------------------------------------------------------

; required data
sTeam        TCHAR "NGEN", 0
sSoftware    TCHAR "MathType", 0
sType        TCHAR "keygen", 0
sSignature   TCHAR "Canterwood // Team NGEN", 0

; defined variables
sBase36Table CHAR  "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"
sBase34Table CHAR  "0123456789ABCDEFGHYJKLMNZPQRSTUVWX"
sPrefix      TCHAR "WF52", 0
sSerialTpl   TCHAR "MT%s-%s-%s", 0

nConst  DWORD 44099087
nConst2 DWORD 1336337

.DATA?

; required data

pTargetVersion LPCTSTR         ?
sTitle         CHAR    40h dup(?)

sName   CHAR 20h dup(?)
sSerial CHAR 60h dup(?)

; undefined variables

nN1 DWORD ?
nN2 DWORD ?
nN3 DWORD ?

sP1 TCHAR 10h dup(?)
sP2 TCHAR 10h dup(?)
sP3 TCHAR 10h dup(?)

nGarbage DWORD ?

; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC USES ebx esi edi hWnd:HWND

  ; make the release title
  INVOKE FindResource, hInstance, SADD("TARGETVERSION"), RT_RCDATA
  INVOKE LoadResource, hInstance, eax
  INVOKE LockResource, eax
  mov pTargetVersion, eax
  INVOKE wsprintf, ADDR sTitle, SADD("%s - %s %s %s"), ADDR sTeam, ADDR sSoftware, pTargetVersion, ADDR sType

  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_TITLE, ADDR sTitle

  ; set up the name text field
  INVOKE SetDlgItemText, hWnd, IDC_NAME, SADD("<not required>")
  INVOKE EnableDlgItem, hWnd, IDC_NAME, FALSE

  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------

; Random
; generate a random number between 0 and nRange-1
Random PROC USES edx ecx nRange: DWORD
  INVOKE GetTickCount
  mov ecx, 41C64E6Dh
  mul ecx
  add eax, 3039h
  and eax, 7FFFFFFh
  mov ecx, nRange
  sub edx, edx
  div ecx
  xchg eax, edx
  ret
Random ENDP

; Base36
Base36 PROC USES ebx esi edi nIn:DWORD, pOut:LPVOID, nLength:DWORD
  mov esi, nIn
  mov edi, pOut
  add edi, nLength
  dec edi
  mov ecx, 36

  base36:
  xor edx, edx
  mov eax, esi
  div ecx
  mov esi, eax
  movzx edx, byte ptr[OFFSET sBase36Table+edx]
  mov [edi], dl
  dec edi
  cmp edi, pOut
  jae base36

  mov eax, pOut
  ret
Base36 ENDP

; Base36 to raw
Base36ToRaw PROC USES ebx esi edi pIn:LPVOID
  mov esi, pIn
  xor edi, edi
  mov ecx, 36
  xor edx, edx

  base36toRaw:
  movzx eax, byte ptr[esi+edx]
  test eax, eax
  je endBase36ToRaw
  cmp eax, '9'
  jbe num
  sub eax, 37h
  jmp endConvert

  num:
  sub eax, 30h

  endConvert:
  imul edi, ecx
  add edi, eax
  inc edx
  jae base36toRaw

  endBase36ToRaw:
  mov eax, edi
  ret
Base36ToRaw ENDP

; Base34
Base34 PROC USES ebx esi edi nIn:DWORD, pOut:LPVOID, nLength:DWORD
  mov esi, nIn
  mov edi, pOut
  add edi, nLength
  dec edi
  mov ecx, 34

  base34:
  xor edx, edx
  mov eax, esi
  div ecx
  mov esi, eax
  movzx edx, byte ptr[OFFSET sBase34Table+edx]
  mov [edi], dl
  dec edi
  cmp edi, pOut
  jae base34

  mov eax, pOut
  ret
Base34 ENDP

Generate PROC USES ebx esi edi hWnd:HWND

  ; p1
  INVOKE Random, 34
  shr eax, 2
  shl eax, 2
  mov ebx, eax
  INVOKE Base36ToRaw, ADDR sPrefix
  mov ecx, 36
  imul eax, ecx
  add eax, ebx
  mov nN1, eax
  INVOKE Base36, eax, ADDR sP1, 5

  ; p2
  INVOKE Random, 999999
  inc eax
  INVOKE wsprintf, ADDR sP2, SADD("%06d"), eax
  INVOKE Base36ToRaw, ADDR sP2
  mov nN2, eax

  ; p3
  fild nConst
  fild nN2
  fild nN1
  fmulp st(1), st
  fprem
  fiadd nConst2
  fistp nN3
  fistp nGarbage
  INVOKE Base34, nN3, ADDR sP3, 5

  INVOKE wsprintf, ADDR sSerial, ADDR sSerialTpl, ADDR sP1, ADDR sP2, ADDR sP3
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  ret
Generate ENDP
; ------------------------------------------------------------------------------

; Copying
; ------------------------------------------------------------------------------
Copy PROC USES ebx esi edi hWnd:HWND
  mov ebx, FALSE ; success flag

  INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

  .IF eax
    INVOKE OpenClipboard, hWnd

    .IF eax
      INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

      .IF eax != NULL
        push eax
        push eax

        ; Copy the serial into the clipboard
        INVOKE GlobalLock, eax
        mov edi, eax
        mov esi, OFFSET sSerial
        mov ecx, SIZEOF sSerial
        rep movsb
        pop eax
        INVOKE GlobalUnlock, eax

        INVOKE EmptyClipboard
        pop eax
        INVOKE SetClipboardData, CF_TEXT, eax
        mov ebx, TRUE
      .ENDIF

      INVOKE CloseClipboard
    .ENDIF

  .ENDIF

  .IF ebx
    INVOKE MessageBox, hWnd, SADD("The serial has been copied into the clipboard."), SADD("Information"), MB_ICONINFORMATION OR MB_OK
  .ELSE
    INVOKE MessageBox, hWnd, SADD("An error occured, please copy the serial by hand."), SADD("Error"), MB_ICONERROR OR MB_OK
  .ENDIF

  mov eax, TRUE
  ret
Copy ENDP
; ------------------------------------------------------------------------------