/* Canter Keygen 5 - Core */

/* additional libraries used */


/* configuration */
#define ID             "1"
#define TARGET         "SmartCompress"
#define TARGET_VERSION "2.1.05.03"
#define TYPE           "keygen"
#define NAME           "Canter"
#define NOTE           "A keygen for this great JPEG 2000 encoder based on LuraWave JP2 technology.\r\nEnjoy!\r\n\r\nCanter"
#define AUTO_UPDATE    TRUE
#define MULTI_SERIALS  TRUE
#define SERIAL_ONLY    TRUE

/* global variables name and serial */
CHAR sName[0x20];
CHAR sSerial[0x100];

/* generation and display */
BOOL Gen(HWND hWnd) {
  unsigned int magic1 = 0xC6EF3720, magic2 = 0x61C88647;
  unsigned int id1 = 0, id2 = 0, id3 = 0x18773, id4 = 0x1E;
  unsigned int n1, n2, n;
  int i;

  if(GetDlgItemText(hWnd, IDC_NAME, sName, sizeof sName)) {

    /* random letters for the beginning of the serial (optional) */
    if(GetTickCount() % 2 == 0) {
      sSerial[0] = 'S';
      sSerial[1] = 'A' + GetTickCount() % 26;
    }
    else {
      sSerial[0] = 'A' + GetTickCount() % 26;
      sSerial[1] = 'C';
    }

    n1 = GetTickCount();           /* take a number at random */
    n2 = 0;                        /* the expected result */
    magic1 = magic1 + 31 * magic2; /* We start from the end... */

    /* reversed algorithm */
    for(i = 0; i < 32; i++) {
      n2 += (((n1 >> 5) + id4) ^ ((n1 << 4) + id3)) ^ (magic1 + n1);
      magic1 -= magic2;
      n = (((n2 >> 5) + id2) ^ ((n2 << 4) + id1)) ^ (magic1 + n2);
      n1 += n;
    }

    n1 -= n; /* to recover the previous value */

    wsprintf(sSerial + 2, TEXT("%u-%u"), n1, n2);

    SetDlgItemText(hWnd, IDC_SERIAL, sSerial);
    return TRUE;
  }
  else {
    SetDlgItemText(hWnd, IDC_SERIAL, TEXT("Enter a name, please."));
    return FALSE;
  }

}

/* copying */
BOOL Copy(HWND hWnd) {
  HGLOBAL hSerial;

  GetDlgItemText(hWnd, IDC_SERIAL, sSerial, sizeof sSerial);

  hSerial = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, sizeof sSerial);
  lstrcpy (GlobalLock(hSerial), sSerial);
  GlobalUnlock(hSerial);

  OpenClipboard(hWnd);
  EmptyClipboard();
  SetClipboardData(CF_TEXT, hSerial);
  CloseClipboard();

  MessageBox(hWnd, TEXT("The serial has been copied into the clipboard."), TEXT("Information"), MB_ICONINFORMATION | MB_OK);
  return TRUE;
}