/* Canter Keygen 5 - Interface */

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include "keygen.h"

/* colors used in name and serial fields */
#define CR_FIELD  RGB(240, 230, 200)
#define CR_NAME   RGB(0, 0, 0)
#define CR_SERIAL RGB(215, 65, 75)

/* keygen core, functions defined in release.c */
BOOL Gen(HWND);
BOOL Copy(HWND);

BOOL CALLBACK DlgProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK InfoDlgProc(HWND, UINT, WPARAM, LPARAM);
BOOL          EnableDlgItem(HWND, DWORD, BOOL);

/* information, code, etc. about the current release are stored there; not in keygen.c! */
#include "release.c"

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow) {
  return DialogBox(hInstance, MAKEINTRESOURCE(IDD_KEYGEN), NULL, DlgProc);
}

BOOL CALLBACK DlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
  HICON hIcon = LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_KEYGEN));
  HBRUSH hFieldColor = CreateSolidBrush(CR_FIELD);
  LOGFONT BoldFont;
  HFONT hBoldFont;
  DWORD nNameSize = sizeof sName;

  /* text displayed when the application starts */
  #if !AUTO_UPDATE
    CHAR sGen[] = "Hit generate, please...";
  #endif

  switch (uMsg) {

    case WM_COMMAND:

      switch(LOWORD(wParam)) {

        case IDC_NAME:

          if(HIWORD(wParam) == EN_UPDATE) {

            #if AUTO_UPDATE

              if(Gen(hWnd))
                EnableDlgItem(hWnd, IDC_COPY, TRUE);
              else
                EnableDlgItem(hWnd, IDC_COPY, FALSE);

            #else
              EnableDlgItem(hWnd, IDC_GEN, TRUE);
              EnableDlgItem(hWnd, IDC_COPY, FALSE);
              SetDlgItemText(hWnd, IDC_SERIAL, sGen);
            #endif

          }

          break;

        case IDC_INFO:
          DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_INFO), hWnd, InfoDlgProc);
          break;

        case IDC_GEN:

          #if !AUTO_UPDATE && !MULTI_SERIALS
            EnableDlgItem(hWnd, IDC_GEN, FALSE);
          #endif

          if(Gen(hWnd))
            EnableDlgItem(hWnd, IDC_COPY, TRUE);
          else
            EnableDlgItem(hWnd, IDC_COPY, FALSE);

          break;

        case IDC_COPY:

          if(Copy(hWnd))
            EnableDlgItem(hWnd, IDC_COPY, FALSE);

          break;

        case IDC_EXIT:
          SendMessage(hWnd, WM_CLOSE, 0, 0);

      }

      break;

    case WM_CTLCOLORSTATIC:

      if(GetDlgCtrlID((HWND) lParam) != IDC_SERIAL)
        return FALSE;

    case WM_CTLCOLOREDIT:
      SetTextColor((HDC) wParam, GetDlgCtrlID((HWND) lParam) == IDC_NAME ? CR_NAME : CR_SERIAL);
      SetBkColor((HDC) wParam, CR_FIELD);
      return (LRESULT) hFieldColor;

    case WM_INITDIALOG:
      SendMessage(hWnd, WM_SETICON, ICON_BIG, (LPARAM) hIcon);
      SendMessage(hWnd, WM_SETICON, ICON_SMALL,(LPARAM) hIcon);

      GetObject((HFONT) SendMessage(hWnd, WM_GETFONT, 0, 0), sizeof(LOGFONT), &BoldFont);
      BoldFont.lfWeight = FW_BOLD;
      hBoldFont = CreateFontIndirect(&BoldFont);
      SendDlgItemMessage(hWnd, IDC_NAME, WM_SETFONT, (WPARAM) hBoldFont, TRUE);
      SendDlgItemMessage(hWnd, IDC_SERIAL, WM_SETFONT, (WPARAM) hBoldFont, TRUE);

      SetWindowText(hWnd, TEXT(TARGET " " TYPE));

      SendDlgItemMessage(hWnd, IDC_NAME, EM_SETLIMITTEXT, sizeof sName - 1, 0);

      GetUserName(sName, &nNameSize);
      SetDlgItemText(hWnd, IDC_NAME, sName);

      #if AUTO_UPDATE

        #if !MULTI_SERIALS
          EnableDlgItem(hWnd, IDC_GEN, FALSE);
        #endif

        if(!Gen(hWnd))
          EnableDlgItem(hWnd, IDC_COPY, FALSE);

      #else
        EnableDlgItem(hWnd, IDC_COPY, FALSE);
        SetDlgItemText(hWnd, IDC_SERIAL, sGen);
      #endif

      #if SERIAL_ONLY
        SetDlgItemText(hWnd, IDC_NAME, TEXT("<not required>"));
        EnableDlgItem(hWnd, IDC_NAME, FALSE);
      #endif

      break;

    case WM_CLOSE:
      DeleteObject(hBoldFont);
      DeleteObject(hFieldColor);
      EndDialog(hWnd, TRUE);
      break;

    default:
      return FALSE;

  }

  return TRUE;
}

BOOL CALLBACK InfoDlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {

  switch(uMsg) {

    case WM_INITDIALOG:

      #ifdef TARGET_VERSION
        SetDlgItemText(hWnd, IDC_TITLE, TEXT("S2 #" ID " - " TARGET " " TARGET_VERSION));
      #else
        SetDlgItemText(hWnd, IDC_TITLE, TEXT("S2 #" ID " - " TARGET));
      #endif

      SetDlgItemText(hWnd, IDC_NOTE, TEXT(NOTE));
      SetDlgItemText(hWnd, IDC_DATE, TEXT("C code compiled on " __DATE__ " @ " __TIME__));
      break;

    case WM_COMMAND:

      switch(LOWORD(wParam)) {

        case IDOK:
          EndDialog(hWnd, 0);

      }

    break;

    default:
      return FALSE;

  }

  return TRUE;
}

BOOL EnableDlgItem(HWND hWnd, DWORD nDlgItem, BOOL bEnable) {
  return EnableWindow(GetDlgItem(hWnd, nDlgItem), bEnable);
}
