; Hex Workshop 4.x keygen
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v2.2.1.1 [24.01.2004]

.486
.model flat, stdcall
option casemap: none

; Lib functions
; ------------------------------------------------------------------------------
include \masm32\include\windows.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\gdi32.inc
include mfmplayer.inc                ; XM player (thanks to Lise_Grim)

includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\gdi32.lib
includelib mfmplayer.lib

; Additional libs

; ------------------------------------------------------------------------------

; Functions
; ------------------------------------------------------------------------------
DialogProc PROTO : HWND, : UINT, : WPARAM, : LPARAM
IdProc     PROTO : HWND, : UINT, : WPARAM, : LPARAM
InfoProc   PROTO : HWND, : UINT, : WPARAM, : LPARAM
DrawItem   PROTO : HWND, : LPARAM
KeygenProc PROTO : HWND
random     PROTO : DWORD
; ------------------------------------------------------------------------------

.const

; Resource ids
; ------------------------------------------------------------------------------
IDD_KEYGEN   equ 100
IDD_INFO     equ 101

IDI_KEYGEN   equ 200

IDC_TITLE    equ 400
IDC_ID       equ 401
IDC_GENERATE equ 402
IDC_COPY     equ 403
IDC_EXIT     equ 404
IDC_SERIAL   equ 406
IDC_INFO     equ 407
IDC_CLOSE    equ 408

IDM_KEYGEN   equ 500
; ------------------------------------------------------------------------------

; Colors
; ------------------------------------------------------------------------------
CR_BACKGROUND equ 00333366h
CR_FOREGROUND equ 00333399h
CR_HIGHLIGHT  equ 00CCCCFFh
CR_INPUT      equ 003300CCh
CR_INPUT2     equ 003300FFh
CR_TEXT       equ 009999FFh
; ------------------------------------------------------------------------------

.data

; Keygen parameters
; ------------------------------------------------------------------------------

; Required data
sId          TCHAR "#?", 0
sTitle       TCHAR "Hex Workshop 4.x keygen", 0
sInfo        TCHAR "Hex Workshop 4.x keygen", 10, 13
             TCHAR "Protection: Serial", 10, 13
             TCHAR 10, 13
             TCHAR "Author: Canterwood", 10, 13
             TCHAR "WWW: http://zor.org/canterwood", 10, 13
             TCHAR 10, 13
             TCHAR "Thanks to: +Analyst, Iczelion, ShmeitCorp, Lise_Grim, +Christal, Gbillou", 10, 13
             TCHAR "Greetings: NGEN, FFF, RIF, e!", 10, 13
             TCHAR 10, 13
             TCHAR "Music: Class Cracktro #15", 10, 13
             TCHAR "Image: Tarantula Nebula - Hubble Heritage", 0

; Keygen definided-variables
sFormat TCHAR "*04%02X-%06u-%04X", 0

.data?

; Required data
sSerial CHAR 60h dup(?)

; Keygen undefinided-variables
rseed DWORD ?

p2  DWORD ?
nb2 DWORD ?

; ------------------------------------------------------------------------------

hInstance  HINSTANCE ?

hIcon      HICON     ?
hIdCursor  HCURSOR   ?

; Brushes & pens
hBgColor   HBRUSH    ?
hFgColor   HBRUSH    ?
hInColor   HBRUSH    ?
hIn2Color  HBRUSH    ?
hEdge      HPEN      ?

; Font & text
BoldFont   LOGFONT   <?>
sBtnText   TCHAR     16 dup(?)

; Music
nMusicSize DWORD     ?
pMusic     LPVOID    ?

DefIdProc  WNDPROC   ?

.code

start:

INVOKE GetTickCount
mov rseed, eax

INVOKE GetModuleHandle, NULL
mov hInstance, eax

; Load icon & cursor
INVOKE LoadIcon, eax, IDI_KEYGEN
mov hIcon, eax
INVOKE LoadCursor, NULL, IDC_HAND
mov hIdCursor, eax

; Create brushes for custom colors
INVOKE CreateSolidBrush, CR_BACKGROUND
mov hBgColor, eax
INVOKE CreateSolidBrush, CR_FOREGROUND
mov hFgColor, eax
INVOKE CreateSolidBrush, CR_INPUT
mov hInColor, eax
INVOKE CreateSolidBrush, CR_INPUT2
mov hIn2Color, eax
INVOKE CreatePen, PS_INSIDEFRAME, 1, CR_FOREGROUND
mov hEdge, eax

; Load the music
push esi
INVOKE FindResource, hInstance, IDM_KEYGEN, RT_RCDATA
push eax
INVOKE SizeofResource, hInstance, eax
mov nMusicSize, eax
pop eax
INVOKE LoadResource, hInstance, eax
INVOKE LockResource, eax
mov esi, eax
mov eax, nMusicSize
add eax, SIZEOF nMusicSize
INVOKE GlobalAlloc, GPTR, eax
mov pMusic, eax
mov ecx, nMusicSize
mov dword ptr [eax], ecx
add eax, SIZEOF nMusicSize
mov edi, eax
rep movsb
pop esi

; Show the dialog box
INVOKE DialogBoxParam, hInstance, IDD_KEYGEN, NULL, ADDR DialogProc, 0

; Restore the memory used for the music
INVOKE GlobalFree, pMusic

; Restore the memory used for graphic objects
INVOKE DeleteObject, hEdge
INVOKE DeleteObject, hInColor
INVOKE DeleteObject, hIn2Color
INVOKE DeleteObject, hFgColor
INVOKE DeleteObject, hBgColor

; Exit the program
INVOKE ExitProcess, 0

; Dialog procedure
; ------------------------------------------------------------------------------
DialogProc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_CTLCOLORDLG
    mov eax, hBgColor
    ret
  .ELSEIF uMsg == WM_CTLCOLORSTATIC
    INVOKE GetDlgCtrlID, lParam

    .IF eax == IDC_TITLE
      INVOKE SendMessage, hWnd, WM_GETFONT, 0, 0
      INVOKE GetObject, eax, SIZEOF LOGFONT, ADDR BoldFont
      mov BoldFont.lfWeight, FW_BOLD
      mov BoldFont.lfItalic, TRUE
      INVOKE CreateFontIndirect, ADDR BoldFont
      INVOKE SelectObject, wParam, eax

      INVOKE SetBkMode, wParam, TRANSPARENT
      INVOKE SetTextColor, wParam, CR_HIGHLIGHT
      mov eax, hFgColor
      ret
    .ELSE
      INVOKE SetBkMode, wParam, TRANSPARENT

      .IF eax == IDC_SERIAL
        INVOKE SetTextColor, wParam, CR_HIGHLIGHT
      .ELSE
        INVOKE SetTextColor, wParam, CR_TEXT
      .ENDIF

      mov eax, hBgColor
      ret
    .ENDIF

  .ELSEIF uMsg == WM_CTLCOLOREDIT
    INVOKE SetBkMode, wParam, TRANSPARENT
    INVOKE SetTextColor, wParam, CR_HIGHLIGHT
    mov eax, hInColor
    ret
  .ELSEIF uMsg == WM_DRAWITEM
    INVOKE DrawItem, hWnd, lParam
  .ELSEIF uMsg == WM_LBUTTONDOWN
    INVOKE SendMessage, hWnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam
  .ELSEIF uMsg == WM_COMMAND
    mov eax,wParam
    mov edx,wParam
    shr edx,16

    .IF wParam == IDC_ID
      INVOKE DialogBoxParam, hInstance, IDD_INFO, hWnd, ADDR InfoProc, 0
    .ELSEIF wParam == IDC_GENERATE
      INVOKE KeygenProc, hWnd
    .ELSEIF wParam == IDC_COPY
      INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

      .IF eax != 0
        INVOKE OpenClipboard, hWnd

        .IF eax
          INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

          .IF eax != NULL
            push eax
            push eax

            INVOKE GlobalLock, eax
            mov edi, eax
            mov esi, OFFSET sSerial
            mov ecx, SIZEOF sSerial
            rep movsb
            pop eax
            INVOKE GlobalUnlock, eax

            INVOKE EmptyClipboard
            pop eax
            INVOKE SetClipboardData, CF_TEXT, eax
          .ENDIF

          INVOKE CloseClipboard
        .ENDIF

      .ENDIF

    .ELSEIF wParam == IDC_EXIT
      INVOKE SendMessage, hWnd, WM_CLOSE, 0, 0
    .ENDIF

  .ELSEIF uMsg == WM_INITDIALOG

    ; Subclass the id control
    INVOKE GetDlgItem, hWnd, IDC_ID
    INVOKE SetWindowLong, eax, GWL_WNDPROC, ADDR IdProc
    mov DefIdProc, eax

    INVOKE SendMessage, hWnd, WM_SETICON, ICON_BIG, hIcon

    INVOKE SetWindowText, hWnd, ADDR sTitle
    INVOKE SetDlgItemText, hWnd, IDC_TITLE, ADDR sTitle
    INVOKE SetDlgItemText, hWnd, IDC_ID, ADDR sId

    INVOKE mfmPlay, pMusic

    INVOKE KeygenProc, hWnd
  .ELSEIF uMsg == WM_CLOSE
    INVOKE mfmPlay, 0

    INVOKE EndDialog, hWnd, 0
  .ENDIF

  xor eax, eax
  ret
DialogProc ENDP
; ------------------------------------------------------------------------------

; Id procedure
; ------------------------------------------------------------------------------
IdProc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_SETCURSOR
    INVOKE SetCursor, hIdCursor
  .ELSE
    INVOKE CallWindowProc, DefIdProc, hWnd, uMsg, wParam, lParam
    ret
  .ENDIF

  xor eax, eax
  ret
IdProc ENDP
; ------------------------------------------------------------------------------

InfoProc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_CTLCOLORDLG
    mov eax, hFgColor
    ret
  .ELSEIF uMsg == WM_CTLCOLORSTATIC
    INVOKE SetBkMode, wParam, TRANSPARENT
    INVOKE SetTextColor, wParam, CR_TEXT
    mov eax, hBgColor
    ret
  .ELSEIF uMsg == WM_DRAWITEM
    INVOKE DrawItem, hWnd, lParam
  .ELSEIF uMsg == WM_INITDIALOG
    INVOKE SetDlgItemText, hWnd, IDC_INFO, ADDR sInfo
  .ELSEIF uMsg == WM_COMMAND

    .IF wParam == IDC_CLOSE
      INVOKE SendMessage, hWnd, WM_CLOSE, 0, 0
    .ENDIF

  .ELSEIF uMsg == WM_CLOSE
    INVOKE EndDialog, hWnd, 0
  .ENDIF

  xor eax, eax
  ret
InfoProc ENDP

DrawItem PROC hWnd: HWND, lParam: LPARAM
  push esi
  mov esi, lParam
  assume esi: ptr DRAWITEMSTRUCT

  .IF [esi].itemState & ODS_SELECTED
    INVOKE SelectObject, [esi].hdc, hIn2Color
  .ELSE
    INVOKE SelectObject, [esi].hdc, hInColor
  .ENDIF

  INVOKE SelectObject, [esi].hdc, hEdge

  INVOKE FillRect, [esi].hdc, ADDR [esi].rcItem, hFgColor
  INVOKE RoundRect, [esi].hdc, [esi].rcItem.left, [esi].rcItem.top, [esi].rcItem.right, [esi].rcItem.bottom, 6, 6

  .IF [esi].itemState & ODS_SELECTED
    INVOKE OffsetRect, ADDR [esi].rcItem, 1, 1
  .ENDIF

  ; Write the text
  INVOKE GetDlgItemText, hWnd, [esi].CtlID, ADDR sBtnText, SIZEOF sBtnText
  INVOKE SetBkMode, [esi].hdc, TRANSPARENT
  INVOKE SetTextColor, [esi].hdc, CR_HIGHLIGHT
  INVOKE DrawText, [esi].hdc, ADDR sBtnText, -1, ADDR [esi].rcItem, DT_CENTER or DT_VCENTER or DT_SINGLELINE

  .IF [esi].itemState & ODS_SELECTED
    INVOKE OffsetRect, ADDR [esi].rcItem, -1, -1
  .ENDIF

  ; Draw the focus rectangle
  .IF [esi].itemState & ODS_FOCUS
    INVOKE InflateRect, ADDR [esi].rcItem, -3, -3
    ;INVOKE DrawFocusRect, [esi].hdc, ADDR [esi].rcItem
  .ENDIF

  assume esi:nothing
  pop esi
  mov eax, TRUE
  ret
DrawItem ENDP

; Keygen procedure
; ------------------------------------------------------------------------------
KeygenProc PROC hWnd: HWND
  push edi
  push esi
  push ebx

  INVOKE random, 22h
  mov ecx, eax
  and ecx, 11111b
  cmp ecx, 111b
  jae p2ok
  or eax, 111b

  p2ok:
  mov p2, eax
  INVOKE random, 999999
  inc eax
  mov nb2, eax

  mov ecx, p2

  mov eax, ecx
  and eax, 80h
  cmp eax, 80h
  sete al
  movzx eax, al
  push eax      ; ebp + 24

  mov eax, ecx
  and eax, 40h
  cmp eax, 40h
  sete al
  movzx eax, al
  push eax      ; ebx

  mov eax, ecx
  and eax, 20h
  cmp eax, 20h
  sete al
  movzx eax, al
  push eax      ; edi

  mov eax, ecx
  and eax, 1Fh
  push eax      ; esi

  push 4
  push 0FFFFFFFFh

  push nb2
  call sub_100031D6

  and eax, 0000FFFFh

  INVOKE wsprintf, ADDR sSerial, ADDR sFormat, p2, nb2, eax

  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial

  pop ebx
  pop esi
  pop edi
  ret
KeygenProc ENDP

random PROC range: DWORD
  mov eax, rseed
  mov ecx, 41c64e6dh
  mul ecx
  add eax, 3039h
  and eax, 7ffffffh
  mov rseed, eax
  mov ecx, range
  sub edx, edx
  div ecx
  xchg eax, edx
  ret
random ENDP

sub_100031D6    proc near               ; CODE XREF: sub_100032BE+197 p

var_24          = dword ptr -24h
var_20          = dword ptr -20h
var_1C          = dword ptr -1Ch
var_18          = dword ptr -18h
var_14          = dword ptr -14h
var_10          = dword ptr -10h
var_C           = dword ptr -0Ch
var_8           = dword ptr -8
var_4           = dword ptr -4
arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch
arg_8           = dword ptr  10h
arg_C           = dword ptr  14h
arg_10          = dword ptr  18h
arg_14          = dword ptr  1Ch
arg_18          = dword ptr  20h

                push    ebp
                mov     ebp, esp
                sub     esp, 24h
                push    24h
                lea     eax, [ebp+var_24]
                push    0
                push    eax
                call    sub_10004F00
                mov     eax, [ebp+arg_0]
                mov     [ebp+var_24], eax
                not     eax
                mov     [ebp+var_20], eax
                mov     eax, [ebp+arg_4]
                mov     [ebp+var_1C], eax
                not     eax
                mov     [ebp+var_18], eax
                mov   eax, [ebp+arg_8]
                mov     [ebp+var_14], eax
                mov     eax, [ebp+arg_C]
                mov     [ebp+var_10], eax
                mov   eax, [ebp+arg_10]
                mov     [ebp+var_C], eax
                mov   eax, [ebp+arg_14]
                mov     [ebp+var_8], eax
                mov   eax, [ebp+arg_18]
                mov     [ebp+var_4], eax
                lea     eax, [ebp+var_24]
                push    24h
                push    eax
                call    sub_1000312C
                mov     ecx, eax
                shr     eax, 10h
                add     esp, 14h
                xor     eax, ecx
                leave
                ret 1ch
sub_100031D6    endp

sub_10004F00    proc near               ; CODE XREF: sub_10001DD8+1B p
                                        ; sub_100020F1+45 p ...

arg_0           = dword ptr  4
arg_4           = byte ptr  8
arg_8           = dword ptr  0Ch

                mov     edx, [esp+arg_8]
                mov     ecx, [esp+arg_0]
                test    edx, edx
                jz      short loc_10004F5B
                xor     eax, eax
                mov     al, [esp+arg_4]
                push    edi
                mov     edi, ecx
                cmp     edx, 4
                jb      short loc_10004F4B
                neg     ecx
                and     ecx, 3
                jz      short loc_10004F2D
                sub     edx, ecx

loc_10004F23:                           ; CODE XREF: sub_10004F00+2B j
                mov     [edi], al
                add     edi, 1
                sub     ecx, 1
                jnz     short loc_10004F23

loc_10004F2D:                           ; CODE XREF: sub_10004F00+1F j
                mov     ecx, eax
                shl     eax, 8
                add     eax, ecx
                mov     ecx, eax
                shl     eax, 10h
                add     eax, ecx
                mov     ecx, edx
                and     edx, 3
                shr     ecx, 2
                jz      short loc_10004F4B
                REP STOS DWORD PTR [EDI]
                test    edx, edx
                jz      short loc_10004F55

loc_10004F4B:                           ; CODE XREF: sub_10004F00+18 j
                                        ; sub_10004F00+43 j ...
                mov     [edi], al
                add     edi, 1
                sub     edx, 1
                jnz     short loc_10004F4B

loc_10004F55:                           ; CODE XREF: sub_10004F00+49 j
                mov     eax, [esp+4+arg_0]
                pop     edi
                retn
; ---------------------------------------------------------------------------

loc_10004F5B:                           ; CODE XREF: sub_10004F00+A j
                mov     eax, [esp+arg_0]
                retn
sub_10004F00    endp

sub_1000312C    proc near               ; CODE XREF: sub_10001A7F+98 p
                                        ; sub_10001A7F+C5 p ...

arg_0           = dword ptr  4
arg_4           = dword ptr  8

                xor     ecx, ecx
                cmp     [esp+arg_4], ecx
                mov     eax, 0B0BAB0BAh
                jbe     short locret_10003162

loc_10003139:                           ; CODE XREF: sub_1000312C+34 j
                mov     edx, [esp+arg_0]
                movsx   edx, byte ptr [ecx+edx]
                shl     edx, 8
                push    7
                xor     eax, edx
                pop     edx

loc_10003149:                           ; CODE XREF: sub_1000312C+2D j
                test    eax, eax
                jge     short loc_10003156
                add     eax, eax
                xor     eax, 1021h
                jmp     short loc_10003158
; ---------------------------------------------------------------------------

loc_10003156:                           ; CODE XREF: sub_1000312C+1F j
                shl     eax, 1

loc_10003158:                           ; CODE XREF: sub_1000312C+28 j
                dec     edx
                jnz     short loc_10003149
                inc     ecx
                cmp     ecx, [esp+arg_4]
                jb      short loc_10003139

locret_10003162:                        ; CODE XREF: sub_1000312C+B j
                retn
sub_1000312C    endp
; ------------------------------------------------------------------------------

END start