; Keymaker - Common functions set
; ==============================================================================
; Author : Canter <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v0.1

; Prototypes
GetRandomString PROTO : LPVOID, : LPVOID
GetString       PROTO : DWORD , : LPVOID, : LPVOID
Random          PROTO : DWORD

.code

; Take a random string from a list
; ------------------------------------------------------------------------------
GetRandomString PROC pListStart: LPVOID, pListEnd: LPVOID

  ; Compute the size of the table
  mov eax, pListEnd
  sub eax, pListStart
  xor edx, edx
  mov ecx, SIZEOF LPTSTR
  div ecx
  dec eax

  ; get a random index
  INVOKE Random, eax
  inc eax

  ; choose the corresponding string
  INVOKE GetString, eax, pListStart, pListEnd

  ret
GetRandomString ENDP
; ------------------------------------------------------------------------------

; Get a string from an array (thanks to f0dder & the Win32ASM Community Board)
; ------------------------------------------------------------------------------
GetString PROC nIndex: DWORD, pListStart: LPVOID, pListEnd: LPVOID
  mov	eax, nIndex
  mov	ecx, pListEnd
  mov edx, pListStart

  ; bounds checking
  sub ecx, edx
  cmp eax, ecx
  jl @@inbounds

  ; string entry 0 = out-of-bounds value to return
  xor eax, eax

  @@inbounds:
  ; return string from table
  mov eax, [edx+eax*4]
  ret
GetString ENDP
; ------------------------------------------------------------------------------

; Quick random value
; ------------------------------------------------------------------------------
Random PROC nRange: DWORD
  INVOKE GetTickCount
  mov ecx, 41C64E6Dh
  mul ecx
  add eax, 3039h
  and eax, 7FFFFFFh
  mov ecx, nRange
  sub edx, edx
  div ecx
  xchg eax, edx
  ret
Random ENDP
; ------------------------------------------------------------------------------