; Keygen - CloneCD
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0

; libraries used

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation
Copy       PROTO :HWND ; copying into the clipboard or the registry, a keyfile...

; configuration
AUTO_UPDATE = TRUE

.DATA

; parameters
; ------------------------------------------------------------------------------

; required data
% sTitle TCHAR "NGEN - CloneCD &TARGETVERSION keygen", 0 ; target version defined in the batch file for quick update
  sAbout TCHAR "by Canterwood // NGEN Team 2004 - gfx: dax`", 0
            
  sNameError   TCHAR "You should enter a name.", 0
  sCopySuccess TCHAR "The serial has been successfully written in the registry!", 0
  sCopyError   TCHAR "Unable to copy the serial in the registry, try by hand...", 0

; defined variables
nMaxPath  DWORD MAX_PATH
nSysFlags DWORD 00150000h

byte_10001157 db 29h
              dd 0A2C9432Eh, 3D017CD8h, 0ECA15436h, 621306F0h, 0C0F305A7h
              dd 988C73C7h, 0BCD92B93h, 1ECA824Ch, 0FD3C579Bh, 6716E0D4h
              dd 8A186F42h, 0BE12E517h, 0DAD6C44Eh, 0A049DE9Eh, 0BB8EF5FBh
              dd 0A97AEE2Fh, 15917968h, 943F07B2h, 0B8910C2h, 80215F22h
              dd 5A9A5D7Fh, 35273290h, 0BFE7CC3Eh, 0FF0397F7h, 48B33019h
              dd 0D7D1B5A5h, 0AC2A925Eh, 4FC6AA56h, 96D238B8h, 76B67DA4h
              dd 9CE26BFCh, 45F10474h, 6459709Dh, 86208771h, 0E665CF5Bh
              dd 1B02A82Dh, 0AEAD2560h, 1CF6B9B0h, 34696146h, 550F7E40h
              dd 0DD23A347h, 0C33AAF51h, 0BACEF95Ch, 2C26EAC5h, 856E0D53h
              dd 0D3098428h, 41F4CDDFh, 6A524D81h, 6CC837DCh, 24FAABC1h
              dd 0C087BE1h, 784AB1BDh, 0E38B9588h, 0E96DE863h, 3BFED5CBh
              dd 0F2391D00h, 660EB7EFh, 0A6E4D058h, 0EBF87277h, 310A4B75h
              dd 8FB45044h, 0DB1A1FEDh, 9F338D99h
              db 11h, 83h, 14h

.DATA?

; required data
sName   CHAR 20h dup(?)
sSerial CHAR 60h dup(?)

; undefined variables
sSysDir  TCHAR MAX_PATH dup(?)
sRoot    TCHAR 10h      dup(?)
nMVolNum DWORD          ?

nSerial        DWORD 3   dup(?)
sMP1           TCHAR 10h dup(?)
sXTEAKey       TCHAR 10h dup(?)
internal_key   dd    4   dup(?)
dword_10003000 dd        ?
dword_10003004 dd        ?
dword_10003008 dd        ?
dword_1000300C dd        ?
dword_10003010 dd        ?
dword_10003014 dd        ?
dword_10003018 dd        ?
dword_1000301C dd        ?
dword_10003020 dd        ?
dword_10003024 dd        ?
dword_10003028 dd        ?
dword_1000302C dd        ?
byte_10003030  db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
byte_1000303F  db        ?
byte_10003040  db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
               db        ?
dword_10003050 dd        ?
byte_10003054  db        ?

hKey  HKEY  ?
nDisp DWORD ?
; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC hWnd: HWND
  LOCAL nNameSize:DWORD

  ; Get disk serial number
  INVOKE GetSystemDirectory, ADDR sSysDir, SIZEOF sSysDir
  INVOKE lstrcpyn, ADDR sRoot, ADDR sSysDir, 4
  INVOKE GetVolumeInformation, ADDR sRoot, NULL, 0, ADDR nMVolNum, ADDR nMaxPath, ADDR nSysFlags, NULL, 0
  xor nMVolNum, 17032801h

  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_ABOUT, ADDR sAbout

  ; Set the limit for the name text field
  INVOKE SendDlgItemMessage, hWnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF sName - 1, 0

  mov nNameSize, SIZEOF sName

  ; Retrieve the default username
  INVOKE GetUserName, ADDR sName, ADDR nNameSize

  .IF eax
    INVOKE SetDlgItemText, hWnd, IDC_NAME, ADDR sName
  .ENDIF

  INVOKE Generate, hWnd
  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------
Generate PROC USES ebx esi edi hWnd: HWND
  INVOKE GetDlgItemText, hWnd, IDC_NAME, ADDR sName, SIZEOF sName
  cmp eax, 0
  je ValidityError

  push -1
  call Random
  mov [nSerial], eax
  xor eax, 17031997h
  INVOKE wsprintf, ADDR sMP1, SADD("%u"), eax
  push eax

  mov [nSerial+4], -1
  push OFFSET [nSerial+4]
  push OFFSET sMP1
  call littleHash

  pop eax
  push OFFSET sMP1
  push eax
  push OFFSET sXTEAKey
  call MD2

  mov [nSerial+8], "NGEN"
  push OFFSET sXTEAKey
  push OFFSET [nSerial+4]
  call ExTEA_encode

  INVOKE wsprintf, ADDR sSerial, SADD("%u+%u+%u"), [nSerial], [nSerial+4], [nSerial+8]
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  jmp EndGenerate

  ValidityError:
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sNameError

  EndGenerate:
  ret
Generate ENDP

; Random(nRange)
Random PROC nRange: DWORD
  INVOKE GetTickCount
  mov ecx, 41C64E6Dh
  mul ecx
  add eax, 3039h
  and eax, 7FFFFFFh
  mov ecx, nRange
  sub edx, edx
  div ecx
  xchg eax, edx
  ret
Random ENDP

; littleHash(psInput, pnOutput) by SlySoft
littleHash      proc near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp
                push    ebx
                push    esi
                mov     esi, [ebp+arg_4]
                mov     ebx, [ebp+arg_0]
                jmp     short loc_42DBFE

loc_42DBF1:
                push    esi
                mov     al, [ebx]
                inc     ebx
                push    eax
                call    littleHashSub
                add     esp, 8

loc_42DBFE:
                mov     dl, [ebx]
                test    dl, dl
                jnz     short loc_42DBF1
                push    esi
                push    0
                call    littleHashSub
                add     esp, 8
                pop     esi
                pop     ebx
                pop     ebp
                retn    8
littleHash      endp

littleHashSub   proc near

arg_0           = byte ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp
                push    esi
                mov     eax, [ebp+arg_4]
                mov     dl, [ebp+arg_0]
                test    eax, eax
                jz      short loc_42DBDE
                xor     esi, esi

loc_42DBC4:
                mov     cl, [eax]
                shr     dword ptr [eax], 1
                xor     cl, dl
                test    cl, 1
                jz      short loc_42DBD5
                xor     dword ptr [eax], 0C050A963h

loc_42DBD5:
                shr     dl, 1
                inc     esi
                cmp     si, 8
                jl      short loc_42DBC4

loc_42DBDE:
                pop     esi
                pop     ebp
                retn
littleHashSub   endp

; MD2(pBuffer, pSize, pData) by WiteG
MD2             proc near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch
arg_8           = dword ptr  10h

                push    ebp
                mov     ebp, esp
                pusha
                xor     eax, eax
                mov     dword_10003000, eax
                mov     dword_10003004, eax
                mov     dword_10003008, eax
                mov     dword_1000300C, eax
                mov     byte_10003054, 2
                mov     ecx, [ebp+arg_4]
                mov     esi, [ebp+arg_8]
                shr     ecx, 4
                jz      loc_100010F5
                mov     dword_10003050, ecx
                xor     eax, eax
                mov     esi, [ebp+arg_8]

loc_1000104B:

                mov     eax, [esi]
                mov     edx, [esi+4]
                mov     dword_10003010, eax
                mov     dword_10003014, edx
                xor     eax, dword_10003000
                xor     edx, dword_10003004
                mov     dword_10003020, eax
                mov     dword_10003024, edx
                mov     eax, [esi+8]
                mov     edx, [esi+0Ch]
                mov     dword_10003018, eax
                mov     dword_1000301C, edx
                xor     eax, dword_10003008
                xor     edx, dword_1000300C
                mov     dword_10003028, eax
                mov     dword_1000302C, edx
                xor     ebx, ebx
                xor     edx, edx

loc_1000109E:
                mov     ecx, 0FFFFFFD0h

loc_100010A3:
                mov     bl, ds:byte_10001157[ebx]
                xor     bl, byte_10003030[ecx]
                mov     byte_10003030[ecx], bl
                inc     ecx
                jnz     short loc_100010A3
                add     bl, dl
                inc     dl
                cmp     dl, 12h
                jnz     short loc_1000109E
                mov     ecx, 0FFFFFFF0h
                movzx   eax, byte_1000303F

loc_100010CD:
                xor     al, [ecx+esi+10h]
                mov     al, ds:byte_10001157[eax]
                xor     al, byte_10003040[ecx]
                mov     byte_10003040[ecx], al
                inc     ecx
                jnz     short loc_100010CD
                add     esi, 10h
                dec     dword_10003050
                jnz     loc_1000104B

loc_100010F5:
                inc     dword_10003050
                dec     byte_10003054
                jz      short loc_1000112E
                js      short loc_10001138
                mov     ecx, [ebp+arg_4]
                mov     edx, 10h
                and     ecx, 0Fh
                sub     edx, ecx
                test    ecx, ecx
                mov     al, dl
                cld
                mov     edi, offset byte_10003040
                jz      short loc_10001120
                rep movsb

loc_10001120:
                mov     ecx, edx
                rep stosb
                mov     esi, offset byte_10003040
                jmp     loc_1000104B

loc_1000112E:
                mov     esi, offset byte_10003030
                jmp     loc_1000104B

loc_10001138:
                mov     edi, [ebp+arg_0]
                mov     esi, offset dword_10003000
                push    esi
                mov     ecx, 4
                rep movsd
                pop     edi
                mov     ecx, 16h
                xor     eax, eax
                rep stosd
                popa
                leave
                retn    0Ch
MD2             endp

; ExTEA_encode(pData, pKey) by WiteG
ExTEA_encode	PROC	ptrData:DWORD, ptrKey:DWORD
	pushad

	mov	esi, ptrKey	
	mov	eax, dword ptr [esi]
	mov	ebx, dword ptr [esi+4]
	mov	ecx, dword ptr [esi+8]
	mov	edx, dword ptr [esi+12]	
	mov	dword ptr [internal_key], eax
	mov	dword ptr [internal_key+4], ebx
	mov	dword ptr [internal_key+8], ecx
	mov	dword ptr [internal_key+12], edx

	push	ebp
	mov	ebx, ptrData
	xor	edx, edx				;suma
	mov	esi, dword ptr [ebx]
	mov	edi, dword ptr [ebx+4]
	mov	ebp, 32

_loop:
	mov	eax, edi
	mov	ebx, edi

	shl	eax, 4					;z << 4
	shr	ebx, 5					;z >> 5
	mov	ecx, edx
	xor	eax, ebx				;(z << 4 ^ z >> 5)
	and	ecx, 3					;sum&3
	add	eax, edi				;[(z << 4 ^ z >> 5) + z]
	mov	ebx, dword ptr [internal_key+4*ecx]
	add	ebx, edx
	xor	eax, ebx				;[(z << 4 ^ z >> 5) + z] ^ [sum + k[sum&3]]
	
	add	edx, 9E3779B9h				;sum += DELTA
	add	esi, eax				;y += [(z << 4 ^ z >> 5) + z] ^ [sum + k[sum&3]]

	mov	ecx, edx
	mov	eax, esi
	mov	ebx, esi
	shl	eax, 4					;z << 4
	shr	ebx, 5					;z >> 5
	shr	ecx, 11
	xor	eax, ebx				;(y << 4 ^ y >> 5)
	and	ecx, 3					;[sum>>11 & 3]
	mov	ebx, edx
	add	eax, esi				;[(y << 4 ^ y >> 5) + y]
	add	ebx, dword ptr [internal_key+4*ecx]	;k[sum>>11 & 3]
	xor	eax, ebx				;[(y << 4 ^ y >> 5) + y] ^ [sum + k[sum>>11 & 3]]

	add	edi, eax				;z += [(y << 4 ^ y >> 5) + y] ^ [sum + k[sum>>11 & 3]]
	dec	ebp
	jnz	_loop

	mov	dword ptr [internal_key], ebp
	mov	dword ptr [internal_key+4], ebp
	mov	dword ptr [internal_key+8], ebp
	mov	dword ptr [internal_key+12], ebp
	
	pop	ebp
	mov	ebx, ptrData
	mov	dword ptr [ebx], esi
	mov	dword ptr [ebx+4], edi
	popad
	ret
ExTEA_encode	ENDP
; ------------------------------------------------------------------------------

; Copying
; ------------------------------------------------------------------------------
Copy PROC USES ebx hWnd:HWND
  LOCAL nSerialLen:DWORD

  mov ebx, FALSE ; success flag

  INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial
  mov nSerialLen, eax

  ; crypt the serial using the volume number
  push eax
  push OFFSET sSerial
  call xorCrypt

  INVOKE RegCreateKeyEx, HKEY_LOCAL_MACHINE, SADD("SOFTWARE\Elaborate Bytes\CloneCD\CDKey"), 0, SADD("REG_SZ"), REG_OPTION_NON_VOLATILE, KEY_SET_VALUE, NULL, ADDR hKey, ADDR nDisp

  .IF eax == ERROR_SUCCESS

    ; write the data in the registry
    INVOKE lstrlen, ADDR sName
    inc eax
    INVOKE RegSetValueEx, hKey, SADD("Name"), 0, REG_SZ, ADDR sName, eax
    INVOKE RegSetValueEx, hKey, SADD("Serial"), 0, REG_BINARY, ADDR sSerial, nSerialLen
    INVOKE RegCloseKey, hKey

    mov ebx, TRUE
  .ENDIF

  .IF ebx
    INVOKE MessageBox, hWnd, ADDR sCopySuccess, SADD("Information"), MB_ICONINFORMATION OR MB_OK
  .ELSE
    INVOKE MessageBox, hWnd, ADDR sCopyError, SADD("Error"), MB_ICONERROR OR MB_OK
  .ENDIF

  ret
Copy ENDP

; xorCrypt(pBuf, nSize) by SlySoft
xorCrypt        proc near

arg_0           = dword ptr  8
arg_4           = dword ptr  0Ch

                push    ebp
                mov     ebp, esp
                push    ebx
                push    esi
                push    edi
                mov     edi, [ebp+arg_4]
                xor     esi, esi
                cmp     edi, esi
                mov     ebx, [ebp+arg_0]
                mov     eax, nMVolNum
                jle     short loc_4159B9

loc_4159A5:
                mov     edx, eax
                and     dl, 0FFh
                xor     [ebx], dl
                push    eax
                call    xorCryptSub
                pop     ecx
                inc     ebx
                inc     esi
                cmp     edi, esi
                jg      short loc_4159A5

loc_4159B9:
                mov     byte ptr [ebx], 0
                pop     edi
                pop     esi
                pop     ebx
                pop     ebp
                retn    8
xorCrypt        endp

xorCryptSub     proc near

arg_0           = dword ptr  8

                push    ebp
                mov     ebp, esp
                mov     edx, [ebp+arg_0]
                mov     eax, edx
                shl     edx, 1Fh
                shr     eax, 1
                or      eax, edx
                pop     ebp
                retn
xorCryptSub     endp
; ------------------------------------------------------------------------------