; Keygen
; ==============================================================================
; Author : Canterwood <charloweb@hotmail.com>
; Website: http://kickme.to/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v2.0 [10.12.2003]

.486
.model flat, stdcall
option casemap: none

; Lib functions
; ------------------------------------------------------------------------------
include \masm32\include\windows.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\gdi32.inc
include mfmplayer.inc                ; XM player (thanks to Lise_Grim)

includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\gdi32.lib
includelib mfmplayer.lib
; ------------------------------------------------------------------------------

; Functions
; ------------------------------------------------------------------------------
DialogProc PROTO : HWND, : UINT, : WPARAM, : LPARAM
IdProc     PROTO : HWND, : UINT, : WPARAM, : LPARAM
InfoProc   PROTO : HWND, : UINT, : WPARAM, : LPARAM
DrawItem   PROTO : HWND, : LPARAM
KeygenProc PROTO : HWND
; ------------------------------------------------------------------------------

.const

; Resource ids
; ------------------------------------------------------------------------------
IDD_KEYGEN   equ 100
IDD_INFO     equ 101

IDI_KEYGEN   equ 200

IDB_KEYGEN   equ 300

IDC_TITLE    equ 400
IDC_ID       equ 401
IDC_GENERATE equ 402
IDC_COPY     equ 403
IDC_EXIT     equ 404
IDC_NAME     equ 405
IDC_SERIAL   equ 406
IDC_INFO     equ 407
IDC_CLOSE    equ 408

IDM_KEYGEN   equ 500
; ------------------------------------------------------------------------------

; Colors
; ------------------------------------------------------------------------------
CR_BACKGROUND equ 00333300h
CR_FOREGROUND equ 00666633h
CR_HIGHLIGHT  equ 00FFFFCCh
CR_INPUT      equ 00999966h
CR_TEXT       equ 00CCCC99h
; ------------------------------------------------------------------------------

MD5RESULT		STRUCT
	dtA		dd	?
	dtB		dd	?
	dtC		dd	?
	dtD		dd	?
MD5RESULT		ENDS

MD5hash			proto	:dword,:dword,:dword

FF			MACRO	dta,dtb,dtc,dtd,x,s,t				; a = b + ((a + F(b,c,d) + x + t) << s )

			mov	eax,dtb
			mov	ebx,dtc
			mov	ecx,dtd

			; F(x,y,z) = (x and y) or ((not x) and z)
			and	ebx,eax
			not	eax
			and	eax,ecx
			or	eax,ebx

			add	eax,dta
			add	eax,x
			add	eax,t

			mov	cl,s
			rol	eax,cl

			add	eax,dtb

			mov	dta,eax

ENDM

GG			MACRO	dta,dtb,dtc,dtd,x,s,t				; a = b + ((a + G(b,c,d) + x + t) << s)

			mov	eax,dtb
			mov	ebx,dtc
			mov	ecx,dtd

			; G(x,y,z) = (x and z) or (y and (not z))
			and	eax,ecx
			not	ecx
			and	ecx,ebx
			or	eax,ecx

			add	eax,dta
			add	eax,x
			add	eax,t

			mov	cl,s
			rol	eax,cl

			add	eax,dtb

			mov	dta,eax

ENDM

HH			MACRO	dta,dtb,dtc,dtd,x,s,t				; a = b + ((a + H(b,c,d) + x + t) << s)

			mov	eax,dtb
			mov	ebx,dtc
			mov	ecx,dtd

			; H(x,y,z) = x xor y xor z
			xor	eax,ebx
			xor	eax,ecx

			add	eax,dta
			add	eax,x
			add	eax,t

			mov	cl,s
			rol	eax,cl

			add	eax,dtb

			mov	dta,eax

ENDM

II			MACRO	dta,dtb,dtc,dtd,x,s,t				; a = b + ((a + I(b,c,d) + x + t) << s)

			mov	eax,dtb
			mov	ebx,dtc
			mov	ecx,dtd

			; I(x,y,z) = y xor (x or (not z))
			not	ecx
			or	eax,ecx
			xor	eax,ebx

			add	eax,dta
			add	eax,x
			add	eax,t

			mov	cl,s
			rol	eax,cl

			add	eax,dtb

			mov	dta,eax

ENDM

; Keygen parameters
; ------------------------------------------------------------------------------

; Required data
sId          TCHAR "#35", 0
sTitle       TCHAR "CD2HTML 5.1.2.0~ keygen by Canterwood", 0
sDefaultName TCHAR "Canterwood", 0
sInfo        TCHAR "* Author: Canterwood", 10, 13
             TCHAR "Email: canterwood@altern.org", 10, 13
             TCHAR "Website: http://kickme.to/canterwood", 10, 13
             TCHAR "* Group: ICI", 10, 13
             TCHAR "Website: http://www.iciteam.vze.com", 10, 13
             TCHAR 10, 13
             TCHAR "Thanks to: Iczelion, Lise_Grim, ShmeitCorp, The +Analyst, Roy", 10, 13
             TCHAR "Greetings: FFF, TSRh, TMG, ECL", 0

; Keygen definided-variables
sLengthError TCHAR "You must enter a name.", 0
sFormat      TCHAR "%.8X%.8X%.8X%.8X", 0
sSeparator   TCHAR "-", 0
sSuffix      TCHAR "DOZENYIUA", 0

.data?

; Required data
sName        TCHAR 32h dup(?)
sCheckedName TCHAR 80h dup(?)
sSerial      TCHAR 32h dup(?)

; Keygen undefinided-variables
hashedName  MD5RESULT     <?>
sHashedName TCHAR     32h dup(?)
sTempBuf    TCHAR     6   dup (?)

; ------------------------------------------------------------------------------

hInstance  HINSTANCE ?

hIcon      HICON     ?
hIdCursor  HCURSOR   ?
hBgColor   HBRUSH    ?
hFgColor   HBRUSH    ?
hInColor   HBRUSH    ?
hEdge      HPEN      ?
BoldFont   LOGFONT   <?>
sBtnText   TCHAR     16 dup(?)

pMusic     LPVOID    ?
nMusicSize DWORD     ?

DefIdProc  WNDPROC   ?
DefBtnProc WNDPROC   ?

.code

start:

INVOKE GetModuleHandle, NULL
mov hInstance, eax

INVOKE LoadIcon, eax, IDI_KEYGEN
mov hIcon, eax
INVOKE LoadCursor, NULL, IDC_HAND
mov hIdCursor, eax

; Create brushes for custom colors
INVOKE CreateSolidBrush, CR_BACKGROUND
mov hBgColor, eax
INVOKE CreateSolidBrush, CR_FOREGROUND
mov hFgColor, eax
INVOKE CreateSolidBrush, CR_INPUT
mov hInColor, eax
INVOKE CreatePen, PS_INSIDEFRAME, 1, CR_FOREGROUND
mov hEdge, eax

; Load the music
push esi
INVOKE FindResource, hInstance, IDM_KEYGEN, RT_RCDATA
push eax
INVOKE SizeofResource, hInstance, eax
mov nMusicSize, eax
pop eax
INVOKE LoadResource, hInstance, eax
INVOKE LockResource, eax
mov esi, eax
mov eax, nMusicSize
add eax, SIZEOF nMusicSize
INVOKE GlobalAlloc, GPTR, eax
mov pMusic, eax
mov ecx, nMusicSize
mov dword ptr [eax], ecx
add eax, SIZEOF nMusicSize
mov edi, eax
rep movsb
pop esi

; Show the dialog box
INVOKE DialogBoxParam, hInstance, IDD_KEYGEN, NULL, ADDR DialogProc, 0

; Restore the memory used for the music
INVOKE GlobalFree, pMusic

; Restore the memory used for graphic objects
INVOKE DeleteObject, hEdge
INVOKE DeleteObject, hInColor
INVOKE DeleteObject, hFgColor
INVOKE DeleteObject, hBgColor

; Exit the program
INVOKE ExitProcess, 0

; Dialog procedure
; ------------------------------------------------------------------------------
DialogProc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_CTLCOLORDLG
    mov eax, hBgColor
    ret
  .ELSEIF uMsg == WM_CTLCOLORSTATIC
    INVOKE GetDlgCtrlID, lParam

    .IF eax == IDC_TITLE
      INVOKE SendMessage, hWnd, WM_GETFONT, 0, 0
      INVOKE GetObject, eax, SIZEOF LOGFONT, ADDR BoldFont
      mov BoldFont.lfWeight, FW_BOLD
      INVOKE CreateFontIndirect, ADDR BoldFont
      INVOKE SelectObject, wParam, eax

      INVOKE SetBkMode, wParam, TRANSPARENT
      INVOKE SetTextColor, wParam, CR_HIGHLIGHT
      mov eax, hFgColor
      ret
    .ELSE
      INVOKE SetBkMode, wParam, TRANSPARENT

      .IF eax == IDC_SERIAL
        INVOKE SetTextColor, wParam, CR_HIGHLIGHT
      .ELSE
        INVOKE SetTextColor, wParam, CR_TEXT
      .ENDIF

      mov eax, hBgColor
      ret
    .ENDIF

  .ELSEIF uMsg == WM_CTLCOLOREDIT
    INVOKE SetBkMode, wParam, TRANSPARENT
    INVOKE SetTextColor, wParam, CR_HIGHLIGHT
    mov eax, hInColor
    ret
  .ELSEIF uMsg == WM_DRAWITEM
    INVOKE DrawItem, hWnd, lParam
  .ELSEIF uMsg == WM_INITDIALOG

    ; Subclass the id control
    INVOKE GetDlgItem, hWnd, IDC_ID
    INVOKE SetWindowLong, eax, GWL_WNDPROC, ADDR IdProc
    mov DefIdProc, eax

    INVOKE SendMessage, hWnd, WM_SETICON, ICON_BIG, hIcon

    INVOKE SendDlgItemMessage, hWnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF sName - 1, 0

    INVOKE SetDlgItemText, hWnd, IDC_TITLE, ADDR sTitle
    INVOKE SetDlgItemText, hWnd, IDC_ID, ADDR sId
    INVOKE SetDlgItemText, hWnd, IDC_NAME, ADDR sDefaultName

    INVOKE mfmPlay, pMusic

    INVOKE KeygenProc, hWnd
  .ELSEIF uMsg == WM_LBUTTONDOWN
    INVOKE SendMessage, hWnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam
  .ELSEIF uMsg == WM_COMMAND
    mov eax,wParam
    mov edx,wParam
    shr edx,16

    .IF wParam == IDC_ID
      INVOKE DialogBoxParam, hInstance, IDD_INFO, hWnd, ADDR InfoProc, 0
    .ELSEIF ax == IDC_NAME || wParam == IDC_GENERATE
      INVOKE KeygenProc, hWnd
    .ELSEIF wParam == IDC_COPY
      INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

      .IF eax != 0
        INVOKE OpenClipboard, hWnd

        .IF eax
          INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

          .IF eax != NULL
            push eax
            push eax

            INVOKE GlobalLock, eax
            mov edi, eax
            mov esi, OFFSET sSerial
            mov ecx, SIZEOF sSerial
            rep movsb
            pop eax
            INVOKE GlobalUnlock, eax

            INVOKE EmptyClipboard
            pop eax
            INVOKE SetClipboardData, CF_TEXT, eax
          .ENDIF

          INVOKE CloseClipboard
        .ENDIF

      .ENDIF

    .ELSEIF wParam == IDC_EXIT
      INVOKE SendMessage, hWnd, WM_CLOSE, 0, 0
    .ENDIF

  .ELSEIF uMsg == WM_CLOSE
    INVOKE mfmPlay, 0

    INVOKE EndDialog, hWnd, 0
  .ENDIF

  xor eax, eax
  ret
DialogProc ENDP
; ------------------------------------------------------------------------------

; Id procedure
; ------------------------------------------------------------------------------
IdProc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_SETCURSOR
    INVOKE SetCursor, hIdCursor
  .ELSE
    INVOKE CallWindowProc, DefIdProc, hWnd, uMsg, wParam, lParam
    ret
  .ENDIF

  xor eax, eax
  ret
IdProc ENDP
; ------------------------------------------------------------------------------

InfoProc PROC hWnd: HWND, uMsg: UINT, wParam: WPARAM, lParam: LPARAM

  .IF uMsg == WM_CTLCOLORDLG
    mov eax, hBgColor
    ret
  .ELSEIF uMsg == WM_CTLCOLORSTATIC
    INVOKE SetBkMode, wParam, TRANSPARENT
    INVOKE SetTextColor, wParam, CR_TEXT
    mov eax, hBgColor
    ret
  .ELSEIF uMsg == WM_DRAWITEM
    INVOKE DrawItem, hWnd, lParam
  .ELSEIF uMsg == WM_INITDIALOG
    INVOKE SetDlgItemText, hWnd, IDC_INFO, ADDR sInfo
  .ELSEIF uMsg == WM_COMMAND

    .IF wParam == IDC_CLOSE
      INVOKE SendMessage, hWnd, WM_CLOSE, 0, 0
    .ENDIF

  .ELSEIF uMsg == WM_CLOSE
    INVOKE EndDialog, hWnd, 0
  .ENDIF

  xor eax, eax
  ret
InfoProc ENDP

DrawItem PROC hWnd: HWND, lParam: LPARAM
  push esi
  mov esi, lParam
  assume esi: ptr DRAWITEMSTRUCT

  INVOKE SelectObject, [esi].hdc, hInColor
  INVOKE SelectObject, [esi].hdc, hEdge

  INVOKE FillRect, [esi].hdc, ADDR [esi].rcItem, hFgColor
  INVOKE RoundRect, [esi].hdc, [esi].rcItem.left, [esi].rcItem.top, [esi].rcItem.right, [esi].rcItem.bottom, 6, 6

  .IF [esi].itemState & ODS_SELECTED
    INVOKE OffsetRect, ADDR [esi].rcItem, 1, 1
  .ENDIF

  ; Write the text
  INVOKE GetDlgItemText, hWnd, [esi].CtlID, ADDR sBtnText, SIZEOF sBtnText
  INVOKE SetBkMode, [esi].hdc, TRANSPARENT
  INVOKE SetTextColor, [esi].hdc, CR_HIGHLIGHT
  INVOKE DrawText, [esi].hdc, ADDR sBtnText, -1, ADDR [esi].rcItem, DT_CENTER or DT_VCENTER or DT_SINGLELINE

  .IF [esi].itemState & ODS_SELECTED
    INVOKE OffsetRect, ADDR [esi].rcItem, -1, -1
  .ENDIF

  ; Draw the focus rectangle
  .IF [esi].itemState & ODS_FOCUS
    INVOKE InflateRect, ADDR [esi].rcItem, -3, -3
    INVOKE DrawFocusRect, [esi].hdc, ADDR [esi].rcItem
  .ENDIF

  assume esi:nothing
  pop esi

  mov eax, TRUE
  ret
DrawItem ENDP

MD5hash			proc	uses ebx ecx edx edi esi,ptBuffer:dword,dtBufferLength:dword,ptMD5Result:dword
			local	dta:dword,dtb:dword,dtc:dword,dtd:dword

			; phase I  padding
			mov	edi,ptBuffer
			mov	eax,dtBufferLength

			inc	eax
			add	edi,eax
			mov	byte ptr [edi-1],080h

			xor	edx,edx

			mov	ebx,64
			div	ebx

			neg	edx
			add	edx,64

			cmp	edx,8
			jae	@f

			add	edx,64

@@:			mov	ecx,edx
			xor	al,al
			rep	stosb

			mov	eax,dtBufferLength

			inc	edx
			add	dtBufferLength,edx

			xor	edx,edx

			mov	ebx,8
			mul	ebx

			mov	dword ptr [edi-8],eax
			mov	dword ptr [edi-4],edx

			mov	edx,dtBufferLength

			mov	edi,ptBuffer

			; phase II  chaining variables initialization
			mov	esi,ptMD5Result
			assume	esi:ptr MD5RESULT

			mov	[esi].dtA,067452301h
			mov	[esi].dtB,0efcdab89h
			mov	[esi].dtC,098badcfeh
			mov	[esi].dtD,010325476h

			; phase III  hashing
hashloop:		mov	eax,[esi].dtA
			mov	dta,eax
			mov	eax,[esi].dtB
			mov	dtb,eax
			mov	eax,[esi].dtC
			mov	dtc,eax
			mov	eax,[esi].dtD
			mov	dtd,eax

			; round 1
			FF	dta,dtb,dtc,dtd,dword ptr [edi+00*4],07,0d76aa478h
			FF	dtd,dta,dtb,dtc,dword ptr [edi+01*4],12,0e8c7b756h
			FF	dtc,dtd,dta,dtb,dword ptr [edi+02*4],17,0242070dbh
			FF	dtb,dtc,dtd,dta,dword ptr [edi+03*4],22,0c1bdceeeh
			FF	dta,dtb,dtc,dtd,dword ptr [edi+04*4],07,0f57c0fafh
			FF	dtd,dta,dtb,dtc,dword ptr [edi+05*4],12,04787c62ah
			FF	dtc,dtd,dta,dtb,dword ptr [edi+06*4],17,0a8304613h
			FF	dtb,dtc,dtd,dta,dword ptr [edi+07*4],22,0fd469501h
			FF	dta,dtb,dtc,dtd,dword ptr [edi+08*4],07,0698098d8h
			FF	dtd,dta,dtb,dtc,dword ptr [edi+09*4],12,08b44f7afh
			FF	dtc,dtd,dta,dtb,dword ptr [edi+10*4],17,0ffff5bb1h
			FF	dtb,dtc,dtd,dta,dword ptr [edi+11*4],22,0895cd7beh
			FF	dta,dtb,dtc,dtd,dword ptr [edi+12*4],07,06b901122h
			FF	dtd,dta,dtb,dtc,dword ptr [edi+13*4],12,0fd987193h
			FF	dtc,dtd,dta,dtb,dword ptr [edi+14*4],17,0a679438eh
			FF	dtb,dtc,dtd,dta,dword ptr [edi+15*4],22,049b40821h

			; round 2
			GG	dta,dtb,dtc,dtd,dword ptr [edi+01*4],05,0f61e2562h
			GG	dtd,dta,dtb,dtc,dword ptr [edi+06*4],09,0c040b340h
			GG	dtc,dtd,dta,dtb,dword ptr [edi+11*4],14,0265e5a51h
			GG	dtb,dtc,dtd,dta,dword ptr [edi+00*4],20,0e9b6c7aah
			GG	dta,dtb,dtc,dtd,dword ptr [edi+05*4],05,0d62f105dh
			GG	dtd,dta,dtb,dtc,dword ptr [edi+10*4],09,002441453h
			GG	dtc,dtd,dta,dtb,dword ptr [edi+15*4],14,0d8a1e681h
			GG	dtb,dtc,dtd,dta,dword ptr [edi+04*4],20,0e7d3fbc8h
			GG	dta,dtb,dtc,dtd,dword ptr [edi+09*4],05,021e1cde6h
			GG	dtd,dta,dtb,dtc,dword ptr [edi+14*4],09,0c33707d6h
			GG	dtc,dtd,dta,dtb,dword ptr [edi+03*4],14,0f4d50d87h
			GG	dtb,dtc,dtd,dta,dword ptr [edi+08*4],20,0455a14edh
			GG	dta,dtb,dtc,dtd,dword ptr [edi+13*4],05,0a9e3e905h
			GG	dtd,dta,dtb,dtc,dword ptr [edi+02*4],09,0fcefa3f8h
			GG	dtc,dtd,dta,dtb,dword ptr [edi+07*4],14,0676f02d9h
			GG	dtb,dtc,dtd,dta,dword ptr [edi+12*4],20,08d2a4c8ah

			; round 3
			HH	dta,dtb,dtc,dtd,dword ptr [edi+05*4],04,0fffa3942h
			HH	dtd,dta,dtb,dtc,dword ptr [edi+08*4],11,08771f681h
			HH	dtc,dtd,dta,dtb,dword ptr [edi+11*4],16,06d9d6122h
			HH	dtb,dtc,dtd,dta,dword ptr [edi+14*4],23,0fde5380ch
			HH	dta,dtb,dtc,dtd,dword ptr [edi+01*4],04,0a4beea44h
			HH	dtd,dta,dtb,dtc,dword ptr [edi+04*4],11,04bdecfa9h
			HH	dtc,dtd,dta,dtb,dword ptr [edi+07*4],16,0f6bb4b60h
			HH	dtb,dtc,dtd,dta,dword ptr [edi+10*4],23,0bebfbc70h
			HH	dta,dtb,dtc,dtd,dword ptr [edi+13*4],04,0289b7ec6h
			HH	dtd,dta,dtb,dtc,dword ptr [edi+00*4],11,0eaa127fah
			HH	dtc,dtd,dta,dtb,dword ptr [edi+03*4],16,0d4ef3085h
			HH	dtb,dtc,dtd,dta,dword ptr [edi+06*4],23,004881d05h
			HH	dta,dtb,dtc,dtd,dword ptr [edi+09*4],04,0d9d4d039h
			HH	dtd,dta,dtb,dtc,dword ptr [edi+12*4],11,0e6db99e5h
			HH	dtc,dtd,dta,dtb,dword ptr [edi+15*4],16,01fa27cf8h
			HH	dtb,dtc,dtd,dta,dword ptr [edi+02*4],23,0c4ac5665h

			; round 4
			II	dta,dtb,dtc,dtd,dword ptr [edi+00*4],06,0f4292244h
			II	dtd,dta,dtb,dtc,dword ptr [edi+07*4],10,0432aff97h
			II	dtc,dtd,dta,dtb,dword ptr [edi+14*4],15,0ab9423a7h
			II	dtb,dtc,dtd,dta,dword ptr [edi+05*4],21,0fc93a039h
			II	dta,dtb,dtc,dtd,dword ptr [edi+12*4],06,0655b59c3h
			II	dtd,dta,dtb,dtc,dword ptr [edi+03*4],10,08f0ccc92h
			II	dtc,dtd,dta,dtb,dword ptr [edi+10*4],15,0ffeff47dh
			II	dtb,dtc,dtd,dta,dword ptr [edi+01*4],21,085845dd1h
			II	dta,dtb,dtc,dtd,dword ptr [edi+08*4],06,06fa87e4fh
			II	dtd,dta,dtb,dtc,dword ptr [edi+15*4],10,0fe2ce6e0h
			II	dtc,dtd,dta,dtb,dword ptr [edi+06*4],15,0a3014314h
			II	dtb,dtc,dtd,dta,dword ptr [edi+13*4],21,04e0811a1h
			II	dta,dtb,dtc,dtd,dword ptr [edi+04*4],06,0f7537e82h
			II	dtd,dta,dtb,dtc,dword ptr [edi+11*4],10,0bd3af235h
			II	dtc,dtd,dta,dtb,dword ptr [edi+02*4],15,02ad7d2bbh
			II	dtb,dtc,dtd,dta,dword ptr [edi+09*4],21,0eb86d391h

			mov	eax,dta
			add	[esi].dtA,eax
			mov	eax,dtb
			add	[esi].dtB,eax
			mov	eax,dtc
			add	[esi].dtC,eax
			mov	eax,dtd
			add	[esi].dtD,eax

			add	edi,64

			sub	edx,64
			jnz	hashloop

			; phase IV  results

			mov	ecx,4

@@:			mov	eax,dword ptr [esi]
			xchg	al,ah
			rol	eax,16
			xchg	al,ah
			mov	dword ptr [esi],eax

			add	esi,4

			loop	@b

                  mov esi, ptMD5Result
                  INVOKE wsprintf, ADDR sHashedName, ADDR sFormat, [esi].dtA, [esi].dtB, [esi].dtC, [esi].dtD
                  lea eax, sHashedName

			ret

MD5hash			endp

; Keygen procedure
; ------------------------------------------------------------------------------
KeygenProc PROC hWnd: HWND
  push edi
  push esi
  push ebx

  push SIZEOF sName
  push OFFSET sName
  push IDC_NAME
  push hWnd
  call GetDlgItemText

  ; Keygen routine here
  test eax, eax
  je LengthError

  push OFFSET sName
  push OFFSET sCheckedName
  call CheckString

  push OFFSET sCheckedName
  call lstrlen

  push OFFSET hashedName
  push eax
  push OFFSET sCheckedName
  call MD5hash

  lea ebx, sTempBuf
  lea esi, [eax+4]
  lea edi, sSerial
  INVOKE lstrcpyn, ebx, esi, 6
  add esi, 5
  INVOKE lstrcpy, edi, ebx
  INVOKE lstrcat, edi, OFFSET sSeparator
  INVOKE lstrcpyn, ebx, esi, 6
  add esi, 5
  INVOKE lstrcat, edi, ebx
  INVOKE lstrcat, edi, OFFSET sSeparator
  INVOKE lstrcpyn, ebx, esi, 6
  add esi, 5
  INVOKE lstrcat, edi, ebx
  INVOKE lstrcat, edi, OFFSET sSeparator
  INVOKE lstrcpyn, ebx, esi, 6
  INVOKE lstrcat, edi, ebx
  INVOKE lstrcat, edi, OFFSET sSuffix

  push OFFSET sSerial
  push IDC_SERIAL
  push hWnd
  call SetDlgItemText
  jmp EndProc

  LengthError:
  push OFFSET sLengthError
  push IDC_SERIAL
  push hWnd
  call SetDlgItemText

  EndProc:

  pop ebx
  pop esi
  pop edi

  ret
KeygenProc ENDP
; ------------------------------------------------------------------------------

; Trim + CharUpper/CharLower function - Ripped from WinImage
; ------------------------------------------------------------------------------
CheckString PROC NEAR

lpsz  = dword ptr 4
arg_4 = dword ptr 8

mov eax, [esp+arg_4]
jmp short loc_441F97

loc_441F96:
inc eax

loc_441F97:
cmp byte ptr [eax], 20h
jz short loc_441F96
push eax
push [esp+4+lpsz]
call ds:lstrcpyA
; push [esp+lpsz]    ; Remove this lines
; call ds:CharUpperA ; if you want only to trim the string
push [esp+lpsz]
call sub_415B9C

pop ecx

retn
CheckString ENDP

sub_415B9C PROC NEAR

lpString = dword ptr 8

push esi
mov esi, [esp+lpString]
push esi
call ds:lstrlenA
jmp short loc_415BB5

loc_415BAA:
dec eax
cmp byte ptr [eax+esi], 20h
jnz short loc_415BB9
and byte ptr [eax+esi], 0

loc_415BB5:
test eax, eax
ja short loc_415BAA

loc_415BB9:
pop esi

retn
sub_415B9C endp
; ------------------------------------------------------------------------------

END start