; Keygen
; ==============================================================================
; Author     : Canterwood <canterwood@altern.org>
; Website    : http://zor.org/canterwood
; IDE        : MASM32 8
; Compilation:
; - RC /l0 keygen.rc
; - ML /c /Cp /coff /Gz keygen.asm
; - LINK /RELEASE /SUBSYSTEM:WINDOWS keygen.obj keygen.res
; ==============================================================================
; v2.5

.486P       ; 486 instruction set, including privilegied ones
.MODEL FLAT

INCLUDE    \masm32\INCLUDE\windows.inc
INCLUDE    \masm32\INCLUDE\user32.inc
INCLUDELIB \masm32\LIB\user32.lib
INCLUDE    \masm32\INCLUDE\kernel32.inc
INCLUDELIB \masm32\LIB\kernel32.lib
INCLUDE    \masm32\INCLUDE\gdi32.inc
INCLUDELIB \masm32\LIB\gdi32.lib

INCLUDE    mfmplayer\mfmplayer.inc
INCLUDELIB mfmplayer\mfmplayer.lib

DialogProc    PROTO :HWND, :UINT , :WPARAM, :LPARAM
EnableDlgItem PROTO :HWND, :DWORD, :BOOL

; functions defined in release.asm
Initialize PROTO :HWND
Generate   PROTO :HWND
Copy       PROTO :HWND

; MASM32 useful macros
INCLUDE \masm32\MACROS\MACROS.ASM

; resource identifiers

IDI_KEYGEN     = 100

IDD_KEYGEN     = 200

IDC_TITLEBAR   = 400
IDC_TITLE      = 401
IDC_CLOSE      = 402
IDC_CLIENTAREA = 403
IDC_NAME       = 404
IDC_SERIAL     = 405
IDC_GENERATE   = 406
IDC_COPY       = 407
IDC_EXIT       = 408

IDM_KEYGEN     = 500

; colors
CR_BG     = 0444444h
CR_TEXT   = 0CCCCCCh
CR_MIDDLE = 0666666h
CR_INBG   = 0888888h
CR_INTEXT = 0EEEEEEh

.DATA

sGenerate TCHAR "Please hit Generate...", 0

.DATA?

hInstance      HINSTANCE  ?

hBgColor       HBRUSH     ?
hMiddleColor   HBRUSH     ?
hInbgColor     HBRUSH     ?
hEdge          HPEN       ?

TitleFont      LOGFONT   <?>
hTitleFont     HFONT      ?

WndRect        RECT      <?>
TitlebarRect   RECT      <?>
ClientareaRect RECT      <?>
hWndRgn        HRGN       ?

nMusicSize     DWORD      ?
pMusic         LPVOID     ?

.CODE

; all information about the current release
INCLUDE release.asm

keygen:

INVOKE GetModuleHandle, NULL
mov hInstance, eax
INVOKE DialogBoxParam, eax, IDD_KEYGEN, NULL, ADDR DialogProc, 0
INVOKE ExitProcess, 0

DialogProc PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
  LOCAL sBtnText[10h]:TCHAR

  .IF uMsg == WM_DRAWITEM
    push esi
    mov esi, lParam
    assume esi:ptr DRAWITEMSTRUCT

    ; change the control background color if pushed
    .IF [esi].itemState & ODS_SELECTED
      INVOKE SelectObject, [esi].hdc, hBgColor
      INVOKE SetTextColor, [esi].hdc, CR_TEXT
    .ELSEIF [esi].itemState & ODS_DISABLED
      INVOKE SelectObject, [esi].hdc, hMiddleColor
      INVOKE SetTextColor, [esi].hdc, CR_TEXT
    .ELSE
      INVOKE SelectObject, [esi].hdc, hInbgColor
      INVOKE SetTextColor, [esi].hdc, CR_INTEXT
    .ENDIF
    
    INVOKE SelectObject, [esi].hdc, hEdge
    INVOKE FillRect, [esi].hdc, ADDR [esi].rcItem, hBgColor
    INVOKE Rectangle, [esi].hdc, [esi].rcItem.left, [esi].rcItem.top, [esi].rcItem.right, [esi].rcItem.bottom

    .IF [esi].itemState & ODS_SELECTED
      INVOKE OffsetRect, ADDR [esi].rcItem, 1, 1
    .ENDIF

    ; write the text
    INVOKE GetDlgItemText, hWnd, [esi].CtlID, ADDR sBtnText, SIZEOF sBtnText
    INVOKE SetBkMode, [esi].hdc, TRANSPARENT
    INVOKE DrawText, [esi].hdc, ADDR sBtnText, -1, ADDR [esi].rcItem, DT_CENTER or DT_VCENTER or DT_SINGLELINE

    .IF [esi].itemState & ODS_SELECTED
      INVOKE OffsetRect, ADDR [esi].rcItem, -1, -1
    .ENDIF

    ; change the position of the text
    .IF [esi].itemState & ODS_FOCUS
      INVOKE InflateRect, ADDR [esi].rcItem, -4, -4
      INVOKE DrawFocusRect, [esi].hdc, ADDR [esi].rcItem
    .ENDIF

    assume esi:nothing
    pop esi
  .ELSEIF uMsg == WM_CTLCOLORDLG
    mov eax, hBgColor
    ret
  .ELSEIF uMsg == WM_CTLCOLORSTATIC
    INVOKE GetDlgCtrlID, lParam
    push eax

    .IF eax == IDC_TITLE
      INVOKE SelectObject, wParam, hTitleFont
      INVOKE SetTextColor, wParam, CR_INTEXT
    .ELSE
      INVOKE SetTextColor, wParam, CR_TEXT
    .ENDIF

    INVOKE SetBkMode, wParam, TRANSPARENT
    pop eax

    .IF eax == IDC_SERIAL
      INVOKE SetBkColor, wParam, CR_MIDDLE
      mov eax, hMiddleColor
    .ELSE
      INVOKE SetBkColor, wParam, CR_BG
      mov eax, hBgColor
    .ENDIF

    ret
  .ELSEIF uMsg == WM_CTLCOLOREDIT
    INVOKE SetTextColor, wParam, CR_INTEXT
    INVOKE SetBkMode, wParam, TRANSPARENT
    INVOKE SetBkColor, wParam, CR_INBG
    mov eax, hBgColor
    ret
  .ELSEIF uMsg == WM_LBUTTONDOWN
    INVOKE SendMessage, hWnd, WM_NCLBUTTONDOWN, HTCAPTION, 0
  .ELSEIF uMsg == WM_COMMAND
    mov eax, wParam ; item, control, or accelerator identifier
    mov edx, eax    ; notification code
    and eax, 0FFFFh
    shr edx, 16

    .IF (eax == IDC_NAME && edx == EN_UPDATE)

      IF AUTO_UPDATE
        INVOKE Generate, hWnd

        .IF eax

          IF MULTI_SERIALS
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, TRUE
          ENDIF

          INVOKE EnableDlgItem, hWnd, IDC_COPY, TRUE
        .ELSE

          IF MULTI_SERIALS
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
          ENDIF

          INVOKE EnableDlgItem, hWnd, IDC_COPY, FALSE
        .ENDIF

      ELSE
        INVOKE EnableDlgItem, hWnd, IDC_GENERATE, TRUE
        INVOKE EnableDlgItem, hWnd, IDC_COPY, FALSE
        INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sGenerate
      ENDIF

    .ELSEIF eax == IDC_GENERATE

      INVOKE Generate, hWnd

      .IF eax

        IFE AUTO_UPDATE

          IF MULTI_SERIALS
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, TRUE
          ELSE
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
          ENDIF

        ENDIF

        INVOKE EnableDlgItem, hWnd, IDC_COPY, TRUE
      .ELSE

        IFE AUTO_UPDATE
          INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
        ENDIF

        INVOKE EnableDlgItem, hWnd, IDC_COPY, FALSE
      .ENDIF

    .ELSEIF eax == IDC_COPY
      INVOKE Copy, hWnd

      .IF eax
        INVOKE EnableDlgItem, hWnd, IDC_COPY, FALSE
      .ENDIF
    .ELSEIF eax == IDC_EXIT || eax == IDC_CLOSE
      INVOKE SendMessage, hWnd, WM_CLOSE, 0, 0
    .ENDIF

  .ELSEIF uMsg == WM_INITDIALOG
    INVOKE LoadIcon, hInstance, IDI_KEYGEN
    INVOKE SendMessage, hWnd, WM_SETICON, ICON_BIG, eax

    INVOKE CreateSolidBrush, CR_BG
    mov hBgColor, eax
    INVOKE CreateSolidBrush, CR_MIDDLE
    mov hMiddleColor, eax
    INVOKE CreateSolidBrush, CR_INBG
    mov hInbgColor, eax
    INVOKE CreatePen, PS_INSIDEFRAME, 1, CR_TEXT
    mov hEdge, eax

    INVOKE SendMessage, hWnd, WM_GETFONT, 0, 0
    INVOKE GetObject, eax, SIZEOF LOGFONT, ADDR TitleFont
    mov TitleFont.lfWeight, FW_BOLD
    sub TitleFont.lfHeight, 2
    INVOKE CreateFontIndirect, ADDR TitleFont
    mov hTitleFont, eax

    INVOKE GetClientRect, hWnd, ADDR WndRect
    INVOKE GetDlgItem, hWnd, IDC_TITLEBAR
    INVOKE GetClientRect, eax, ADDR TitlebarRect
    INVOKE GetDlgItem, hWnd, IDC_CLIENTAREA
    INVOKE GetClientRect, eax, ADDR ClientareaRect
    mov eax, WndRect.bottom
    sub eax, ClientareaRect.bottom
    mov ClientareaRect.top, eax
    INVOKE CreateRectRgnIndirect, ADDR WndRect
    mov hWndRgn, eax
    INVOKE CreateRectRgn, WndRect.left, TitlebarRect.bottom, WndRect.right, ClientareaRect.top
    push eax
    INVOKE CombineRgn, hWndRgn, hWndRgn, eax, RGN_XOR
    pop eax
    INVOKE DeleteObject, eax
    INVOKE SetWindowRgn, hWnd, hWndRgn, TRUE

    push esi
    INVOKE FindResource, hInstance, IDM_KEYGEN, RT_RCDATA
    push eax
    INVOKE SizeofResource, hInstance, eax
    mov nMusicSize, eax
    pop eax
    INVOKE LoadResource, hInstance, eax
    INVOKE LockResource, eax
    mov esi, eax
    mov eax, nMusicSize
    add eax, SIZEOF nMusicSize
    INVOKE GlobalAlloc, GPTR, eax
    mov pMusic, eax
    mov ecx, nMusicSize
    mov dword ptr [eax], ecx
    add eax, SIZEOF nMusicSize
    mov edi, eax
    rep movsb
    pop esi
    INVOKE mfmPlay, pMusic

    INVOKE Initialize, hWnd

    IF AUTO_UPDATE
      INVOKE Generate, hWnd

      IFE MULTI_SERIALS
        INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
      ENDIF
    ELSE
      INVOKE EnableDlgItem, hWnd, IDC_COPY, FALSE
      INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sGenerate
    ENDIF

  .ELSEIF uMsg == WM_CLOSE
    INVOKE mfmPlay, 0
    INVOKE GlobalFree, pMusic

    INVOKE DeleteObject, hWndRgn

    INVOKE DeleteObject, hTitleFont

    INVOKE DeleteObject, hEdge
    INVOKE DeleteObject, hInbgColor
    INVOKE DeleteObject, hMiddleColor
    INVOKE DeleteObject, hBgColor

    INVOKE EndDialog, hWnd, 0
  .ENDIF

  xor eax, eax
  ret
DialogProc ENDP

EnableDlgItem PROC hWnd:HWND, nDlgItem:DWORD, bEnable:BOOL
  INVOKE GetDlgItem, hWnd, nDlgItem
  INVOKE EnableWindow, eax, bEnable
  ret
EnableDlgItem ENDP

END keygen ; set the entry point of module