; Keygen - BlazeDVD
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0

; libraries used

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation
Copy       PROTO :HWND ; copying into the clipboard or the registry, a keyfile...

; configuration
AUTO_UPDATE   = TRUE
MULTI_SERIALS = TRUE

.DATA

; parameters
; ------------------------------------------------------------------------------

; required data
sTeam        TCHAR "NGEN", 0
sSoftware    TCHAR "BlazeDVD", 0
sType        TCHAR "keygen", 0
sSignature   TCHAR "Canterwood // Team NGEN", 0

; defined variables
nMagic       DWORD 37103
sBase30Table CHAR  "3456789ABCDEFGHJKLMNPQRSTUVWXY"

.DATA?

; required data

pTargetVersion LPCTSTR         ?
sTitle         CHAR    40h dup(?)

sName   CHAR 20h dup(?)
sSerial CHAR 60h dup(?)

; undefined variables
nSerial QWORD         ?
aSerial CHAR  60h dup(?)

; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC USES ebx esi edi hWnd: HWND

  ; make the release title
  INVOKE FindResource, hInstance, SADD("TARGETVERSION"), RT_RCDATA
  INVOKE LoadResource, hInstance, eax
  INVOKE LockResource, eax
  mov pTargetVersion, eax
  INVOKE wsprintf, ADDR sTitle, SADD("%s - %s %s %s"), ADDR sTeam, ADDR sSoftware, pTargetVersion, ADDR sType

  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_TITLE, ADDR sTitle

  INVOKE SetDlgItemText, hWnd, IDC_NAME, SADD("<not required>")
  INVOKE EnableDlgItem, hWnd, IDC_NAME, FALSE

  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------

; Random
; generate a random number between 0 and nRange-1
Random PROC USES edx ecx nRange: DWORD
  INVOKE GetTickCount
  mov ecx, 41C64E6Dh
  mul ecx
  add eax, 3039h
  and eax, 7FFFFFFh
  mov ecx, nRange
  sub edx, edx
  div ecx
  xchg eax, edx
  ret
Random ENDP

; Base30
; output buffer: 14 bytes at least
Base30 PROC USES ebx esi edi nIn:QWORD, pOut:LPVOID
  mov edi, pOut
  add edi, 13
  mov ecx, 30

  mov ebx, dword ptr[nIn+4]
  mov esi, dword ptr[nIn]

  base30:
  mov eax, ebx ; high part
  xor edx, edx
  div ecx
  mov ebx, eax
  mov eax, esi ; low part
  div ecx
  mov esi, eax
  movzx edx, byte ptr[OFFSET sBase30Table+edx]
  mov [edi], dl
  mov edx, ebx
  dec edi
  cmp edi, pOut
  jae base30

  ret
Base30 ENDP

Generate PROC USES ebx esi edi hWnd: HWND
  mov eax, 0FFFFFFFFh
  mov ecx, nMagic
  xor edx, edx
  div ecx
  INVOKE Random, eax ; int((2^32 - 1) / nMagic)
  inc eax
  imul eax, nMagic
  mov ebx, eax

  mov eax, 000FFFFFFh
  mov ecx, nMagic
  xor edx, edx
  div ecx
  INVOKE Random, eax ; int((2^24 - 1) / nMagic)
  inc eax
  imul eax, nMagic
  shl eax, 8

  lea esi, nSerial
  mov [esi+4], ebx
  mov [esi], eax
  mov ecx, 7
  xor edx, edx

  checksum:
  movzx eax, byte ptr[esi+ecx]
  add dl, al
  dec ecx
  jns checksum

  endChecksum:
  not dl
  mov byte ptr[esi], dl
  INVOKE Base30, nSerial, ADDR aSerial

  lea esi, aSerial
  lea edi, sSerial
  mov ecx, 14
  xor ebx, ebx

  reverse:
  mov al, byte ptr[esi+ecx-1]
  mov byte ptr[edi+ebx], al
  inc ebx
  dec ecx
  jnz reverse

  mov byte ptr[edi+ebx], 0
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial
  mov eax, TRUE

  ret
Generate ENDP
; ------------------------------------------------------------------------------

; Copying
; ------------------------------------------------------------------------------
Copy PROC USES ebx esi edi hWnd:HWND
  mov ebx, FALSE ; success flag

  INVOKE GetDlgItemText, hWnd, IDC_SERIAL, ADDR sSerial, SIZEOF sSerial

  .IF eax
    INVOKE OpenClipboard, hWnd

    .IF eax
      INVOKE GlobalAlloc, GMEM_MOVEABLE or GMEM_DDESHARE, SIZEOF sSerial

      .IF eax != NULL
        push eax
        push eax

        ; Copy the serial into the clipboard
        INVOKE GlobalLock, eax
        mov edi, eax
        mov esi, OFFSET sSerial
        mov ecx, SIZEOF sSerial
        rep movsb
        pop eax
        INVOKE GlobalUnlock, eax

        INVOKE EmptyClipboard
        pop eax
        INVOKE SetClipboardData, CF_TEXT, eax
        mov ebx, TRUE
      .ENDIF

      INVOKE CloseClipboard
    .ENDIF

  .ENDIF

  .IF ebx
    INVOKE MessageBox, hWnd, SADD("The serial has been copied into the clipboard."), SADD("Information"), MB_ICONINFORMATION OR MB_OK
  .ELSE
    INVOKE MessageBox, hWnd, SADD("An error occured, please copy the serial by hand."), SADD("Error"), MB_ICONERROR OR MB_OK
  .ENDIF

  mov eax, TRUE
  ret
Copy ENDP
; ------------------------------------------------------------------------------