; Keygen - 3D RPG Editor
; ==============================================================================
; Author : Canterwood <canterwood@altern.org>
; Website: http://zor.org/canterwood
; IDE    : MASM32 8
; ==============================================================================
; v1.0

; libraries used
INCLUDE    \masm32\INCLUDE\advapi32.inc
INCLUDELIB \masm32\LIB\advapi32.lib

; functions
Initialize PROTO :HWND ; keygen initialization at runtime
Generate   PROTO :HWND ; name checking and serial-generation

; configuration
AUTO_UPDATE   = TRUE
MULTI_SERIALS = TRUE
TRANS_FRENCH  = FALSE

.DATA

; parameters
; ------------------------------------------------------------------------------

; required data
% sTitle      TCHAR "NGEN - 3D RPG Editor &TARGETVERSION keygen", 0 ; target version defined in the batch file for quick update

IF TRANS_FRENCH
  sNameItem        TCHAR "Nom:", 0
  sGenerateItem    TCHAR "&Gnrer", 0
  sLicenseKeysItem TCHAR "Cls de license", 0

  sDisclaimer      TCHAR "IMPORTANT: Ce keygen doit seulement tre utilis avec les traductions non-officielles de 3D RPG Editor, avant sa mise en vente hors du Japon. Si vous aimez ce logiciel, ACHETEZ-LE !", 0
  sSignature       TCHAR "Par Canterwood // Team NGEN 2004", 0

  sGenSuccess      TCHAR "Les cls ont t gnres avec succs.", 0
  sNameError       TCHAR "Vous devez entrer au minimum 2 caractres.", 0
  sCharsetError    TCHAR "Seul les caractres US/ASCII sont autoriss.", 0
ELSE
  sNameItem        TCHAR "Name:", 0
  sGenerateItem    TCHAR "&Generate", 0
  sLicenseKeysItem TCHAR "License keys", 0

  sDisclaimer      TCHAR "If you do not run 3D RPG Editor under a japanese version of Windows, you must configure it: go in the Control Panel -> Regional Options, then select 'Japanese' in all list boxes.", 0
  sSignature       TCHAR "By Canterwood // Team NGEN 2004", 0

  sGenSuccess      TCHAR "The keys have been successfully generated.", 0
  sNameError       TCHAR "You must enter 2 characters at least.", 0
  sCharsetError    TCHAR "Only US/ASCII characters are allowed.", 0
ENDIF

; defined variables
sNull    DWORD 0
sFormat  TCHAR "%02u", 0
sFormat2 TCHAR "%03u", 0

.DATA?

; required data
sName   CHAR 20h dup(?)
sSerial CHAR 60h dup(?)
sId     CHAR 10h dup(?)

; undefined variables
sNum  TCHAR 10h dup(?)
nDate DWORD         ?
n4    DWORD         ?
n3    DWORD         ?
nNot0 DWORD         ?
n16   DWORD         ?

; ------------------------------------------------------------------------------

.CODE

; Initialization
; ------------------------------------------------------------------------------
Initialize PROC hWnd: HWND
  LOCAL nNameSize:DWORD

  INVOKE SetDlgItemText, hWnd, IDC_NAMEITEM, ADDR sNameItem
  INVOKE SetDlgItemText, hWnd, IDC_GENERATE, ADDR sGenerateItem
  INVOKE SetDlgItemText, hWnd, IDC_LICENSEKEYSITEM, ADDR sLicenseKeysItem

  INVOKE SetWindowText, hWnd, ADDR sTitle
  INVOKE SetDlgItemText, hWnd, IDC_DISCLAIMER, ADDR sDisclaimer
  INVOKE SetDlgItemText, hWnd, IDC_SIGNATURE, ADDR sSignature

  ; Set the limit for the name text field
  INVOKE SendDlgItemMessage, hWnd, IDC_NAME, EM_SETLIMITTEXT, SIZEOF sName - 1, 0

  mov nNameSize, SIZEOF sName

  ; Retrieve the default username
  INVOKE GetUserName, ADDR sName, ADDR nNameSize

  .IF eax
    INVOKE SetDlgItemText, hWnd, IDC_NAME, ADDR sName
  .ENDIF

  ret
Initialize ENDP
; ------------------------------------------------------------------------------

; Generation
; ------------------------------------------------------------------------------
Random PROC nRange: DWORD
  INVOKE GetTickCount
  mov ecx, 41C64E6Dh
  mul ecx
  add eax, 3039h
  and eax, 7FFFFFFh
  mov ecx, nRange
  sub edx, edx
  div ecx
  xchg eax, edx
  ret
Random ENDP

Generate PROC USES ebx esi edi hWnd: HWND
  INVOKE SetDlgItemText, hWnd, IDC_ID, ADDR sNull
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL1, ADDR sNull
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL2, ADDR sNull
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL3, ADDR sNull
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL4, ADDR sNull

  INVOKE GetDlgItemText, hWnd, IDC_NAME, ADDR sName, SIZEOF sName
  cmp eax, 2
  jb nameError

  lea esi, sName
  xor ecx, ecx

  checkCharset:
  movzx eax, byte ptr[esi+ecx]
  test eax, eax
  je endCheckCharset
  cmp eax, 128
  jge charsetError
  inc ecx
  jmp checkCharset

  endCheckCharset:
  lea esi, sNum
  lea edi, sSerial
  dec edi

  mov byte ptr[edi+13], '3'                ; char 13 serial

  INVOKE Random, 12
  inc eax
  mov n4, eax
  lea eax, [eax*4]
  INVOKE wsprintf, esi, ADDR sFormat, eax
  mov al, [esi]
  mov [edi+6], al                          ; char 6 serial
  mov al, [esi+1]
  mov [edi+8], al                          ; char 8 serial

  INVOKE Random, 51
  add eax, 49
  mov edx, eax
  add edx, 1951
  mov nDate, edx
  INVOKE wsprintf, esi, ADDR sFormat, eax
  mov al, [esi]
  mov [edi+3], al                          ; char 3 serial
  mov al, [esi+1]
  mov [edi+10], al                         ; char 10 serial

  INVOKE Random, 31
  inc eax
  mov n3, eax
  mov ecx, 3
  mul ecx
  INVOKE wsprintf, esi, ADDR sFormat, eax
  mov al, [esi]
  mov [edi+14], al                         ; char 14 serial
  mov al, [esi+1]
  mov [edi+12], al                         ; char 12 serial

  INVOKE Random, 99
  inc eax
  mov nNot0, eax
  INVOKE wsprintf, esi, ADDR sFormat, eax
  mov al, [esi]
  mov [edi+7], al                          ; char 7 serial
  mov al, [esi+1]
  mov [edi+4], al                          ; char 4 serial


  INVOKE lstrlen, ADDR sName
  cmp eax, 9
  jb shortName
  INVOKE Random, 9
  jmp c16

  shortName:
  INVOKE Random, eax

  c16:
  mov n16, eax
  INVOKE wsprintf, esi, ADDR sFormat, eax
  mov al, [esi+1]
  mov [edi+16], al                         ; char 16 serial

  movzx eax, byte ptr[sName]
  INVOKE wsprintf, esi, ADDR sFormat2, eax
  mov al, [esi+1]
  mov [edi+9], al                          ; char9 serial
  mov al, [esi+2]
  mov [edi+11], al                         ; char 11 serial

  INVOKE lstrlen, ADDR sName
  dec eax
  movzx eax, byte ptr[sName+eax]
  INVOKE wsprintf, esi, ADDR sFormat2, eax
  mov al, [esi+1]
  mov [edi+1], al                          ; char 1 serial
  mov al, [esi+2]
  mov [edi+15], al                         ; char 15 serial

  mov edx, n16
  movzx eax, byte ptr[sName+edx]
  INVOKE wsprintf, esi, ADDR sFormat2, eax
  mov al, [esi+1]
  mov [edi+2], al                          ; char 2 serial
  mov al, [esi+2]
  mov [edi+5], al                          ; char 5 serial

  lea edi, sId
  dec edi

  mov eax, n3
  imul eax, eax, 2
  INVOKE wsprintf, esi, ADDR sFormat, eax
  mov al, [esi]
  mov [edi+1], al                          ; char 1 ID
  mov al, [esi+1]
  mov [edi+8], al                          ; char 8 ID

  mov eax, n4
  imul eax, eax, 3
  INVOKE wsprintf, esi, ADDR sFormat, eax
  mov al, [esi]
  mov [edi+6], al                          ; char 6 ID
  mov al, [esi+1]
  mov [edi+2], al                          ; char 2 ID

  mov eax, nDate
  sub eax, 1915
  INVOKE wsprintf, esi, ADDR sFormat2, eax
  mov al, [esi+1]
  mov [edi+3], al                          ; char 3 ID
  mov al, [esi+2]
  mov [edi+4], al                          ; char 4 ID

  mov eax, nNot0
  INVOKE wsprintf, esi, ADDR sFormat, eax
  mov al, [esi]
  mov [edi+7], al                          ; char 7 ID
  mov al, [esi+1]
  mov [edi+5], al                          ; char 5 ID

  INVOKE SetDlgItemText, hWnd, IDC_ID, ADDR sId
  lea esi, sSerial
  lea edi, sNum
  mov eax, [esi]
  mov [edi], eax
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL1, edi
  mov eax, [esi+4]
  mov [edi], eax
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL2, edi
  mov eax, [esi+8]
  mov [edi], eax
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL3, edi
  mov eax, [esi+12]
  mov [edi], eax
  INVOKE SetDlgItemText, hWnd, IDC_SERIAL4, edi


  INVOKE SetDlgItemText, hWnd, IDC_STATUS, ADDR sGenSuccess
  mov eax, TRUE
  jmp endGenerate

  nameError:
  INVOKE SetDlgItemText, hWnd, IDC_STATUS, ADDR sNameError
  mov eax, FALSE
  jmp endGenerate

  charsetError:
  INVOKE SetDlgItemText, hWnd, IDC_STATUS, ADDR sCharsetError
  mov eax, FALSE
  jmp endGenerate

  endGenerate:
  ret
Generate ENDP
; ------------------------------------------------------------------------------