; Keygen
; ==============================================================================
; Author      : Canterwood <canterwood@altern.org>
; Website     : http://zor.org/canterwood
; IDE         : MASM32 8
; Compilation :
; - RC keygen.rc
; - ML /c /Cp /coff /Gz keygen.asm
; - LINK /RELEASE /SUBSYSTEM:WINDOWS keygen.obj keygen.res
; ==============================================================================
; v1.6a

.486P       ; 486 instruction set, including privilegied ones
.MODEL FLAT

INCLUDE    \masm32\INCLUDE\windows.inc
INCLUDE    \masm32\INCLUDE\user32.inc
INCLUDELIB \masm32\LIB\user32.lib
INCLUDE    \masm32\INCLUDE\kernel32.inc
INCLUDELIB \masm32\LIB\kernel32.lib
INCLUDE    \masm32\INCLUDE\gdi32.inc
INCLUDELIB \masm32\LIB\gdi32.lib

DialogProc    PROTO :HWND, :UINT, :WPARAM, :LPARAM
EnableDlgItem PROTO :HWND, :DWORD, :BOOL

; functions defined in release.asm
Initialize PROTO :HWND
Generate   PROTO :HWND

; MASM32 useful macros (SADD, CTXT...)
INCLUDE \masm32\MACROS\MACROS.ASM

IDI_KEYGEN          = 100
IDD_KEYGEN          = 200
IDC_DISCLAIMER      = 300
IDC_NAME            = 301
IDC_GENERATE        = 302
IDC_ID              = 303
IDC_SERIAL1         = 304
IDC_SERIAL2         = 305
IDC_SERIAL3         = 306
IDC_SERIAL4         = 307
IDC_STATUS          = 308
IDC_SIGNATURE       = 309
IDC_NAMEITEM        = 400
IDC_LICENSEKEYSITEM = 401

.DATA?

hInstance     HINSTANCE ?
hDisclaimerBg HBRUSH    ?

.CODE

; all information about the current release
INCLUDE release.asm

keygen:

INVOKE GetModuleHandle, NULL
mov hInstance, eax
INVOKE DialogBoxParam, eax, IDD_KEYGEN, NULL, ADDR DialogProc, 0
INVOKE ExitProcess, 0

DialogProc PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

  .IF uMsg == WM_COMMAND
    mov eax, wParam ; item, control, or accelerator identifier
    mov edx, eax    ; notification code
    and eax, 0FFFFh
    shr edx, 16

    .IF (eax == IDC_NAME && edx == EN_UPDATE)

      IF AUTO_UPDATE
        INVOKE Generate, hWnd

        .IF eax

          IF MULTI_SERIALS
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, TRUE
          ENDIF

        .ELSE

          IF MULTI_SERIALS
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
          ENDIF

        .ENDIF

      ELSE
        INVOKE EnableDlgItem, hWnd, IDC_GENERATE, TRUE
        INVOKE SetDlgItemText, hWnd, IDC_STATUS, SADD("Please hit Generate...")
      ENDIF

    .ELSEIF eax == IDC_GENERATE

      INVOKE Generate, hWnd

      .IF eax

        IFE AUTO_UPDATE

          IF MULTI_SERIALS
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, TRUE
          ELSE
            INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
          ENDIF

        ENDIF

      .ELSE

        IFE AUTO_UPDATE
          INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
        ENDIF

      .ENDIF

    .ENDIF

  .ELSEIF uMsg == WM_CTLCOLORSTATIC

    INVOKE GetDlgCtrlID, lParam

    .IF eax == IDC_DISCLAIMER
      INVOKE SetBkMode, wParam, TRANSPARENT
      INVOKE SetTextColor, wParam, 00000FFh
      mov eax, hDisclaimerBg
      ret
    .ENDIF

  .ELSEIF uMsg == WM_INITDIALOG
    INVOKE LoadIcon, hInstance, IDI_KEYGEN
    INVOKE SendMessage, hWnd, WM_SETICON, ICON_BIG, eax

    INVOKE GetSysColor, COLOR_BTNFACE
    INVOKE CreateSolidBrush, eax
    mov hDisclaimerBg, eax

    INVOKE Initialize, hWnd

    IF AUTO_UPDATE
      INVOKE Generate, hWnd

      IFE MULTI_SERIALS
        INVOKE EnableDlgItem, hWnd, IDC_GENERATE, FALSE
      ENDIF
    ELSE
      INVOKE SetDlgItemText, hWnd, IDC_STATUS, SADD("Please hit Generate...")
    ENDIF

  .ELSEIF uMsg == WM_CLOSE
    INVOKE DeleteObject, hDisclaimerBg
    INVOKE EndDialog, hWnd, 0
  .ENDIF

  xor eax, eax
  ret
DialogProc ENDP

EnableDlgItem PROC hWnd:HWND, nDlgItem:DWORD, bEnable:BOOL
  INVOKE GetDlgItem, hWnd, nDlgItem
  INVOKE EnableWindow, eax, bEnable
  ret
EnableDlgItem ENDP

END keygen ; set the entry point of module